/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.releasenotes.model;

import java.util.List;
import java.util.Objects;
import net.openhft.chronicle.releasenotes.model.ReleaseNotes;

public final class AggregatedReleaseNotes {
    private final String tag;
    private final String title;
    private final List<ReleaseNotes> releases;

    public AggregatedReleaseNotes(String tag, String title, List<ReleaseNotes> releases) {
        this.tag = Objects.requireNonNull(tag);
        this.title = Objects.requireNonNull(title);
        this.releases = Objects.requireNonNull(releases);
    }

    public String getTag() {
        return this.tag;
    }

    public String getTitle() {
        return this.title;
    }

    public List<ReleaseNotes> getReleases() {
        return this.releases;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AggregatedReleaseNotes releaseNote = (AggregatedReleaseNotes)o;
        return this.tag.equals(releaseNote.tag) && this.title.equals(releaseNote.title) && this.releases.equals(releaseNote.releases);
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.title, this.releases);
    }

    public String toString() {
        return "Release{tag='" + this.tag + '\'' + ", title='" + this.title + '\'' + ", releases=" + this.releases + '}';
    }
}

