/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Collectors;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.rollcycles.LargeRollCycles;
import net.openhft.chronicle.queue.rollcycles.LegacyRollCycles;
import net.openhft.chronicle.queue.rollcycles.RollCycleArithmetic;
import net.openhft.chronicle.queue.rollcycles.SparseRollCycles;
import net.openhft.chronicle.queue.rollcycles.TestRollCycles;

public enum RollCycles implements RollCycle
{
    FIVE_MINUTELY("yyyyMMdd-HHmm'V'", 300000, 2048, 256),
    TEN_MINUTELY("yyyyMMdd-HHmm'X'", 600000, 2048, 256),
    TWENTY_MINUTELY("yyyyMMdd-HHmm'XX'", 1200000, 2048, 256),
    HALF_HOURLY("yyyyMMdd-HHmm'H'", 1800000, 2048, 256),
    FAST_HOURLY("yyyyMMdd-HH'F'", 3600000, 4096, 256),
    TWO_HOURLY("yyyyMMdd-HH'II'", 0x6DDD00, 4096, 256),
    FOUR_HOURLY("yyyyMMdd-HH'IV'", 14400000, 4096, 256),
    SIX_HOURLY("yyyyMMdd-HH'VI'", 21600000, 4096, 256),
    FAST_DAILY("yyyyMMdd'F'", 86400000, 4096, 256),
    WEEKLY("YYYY'W'ww", 604800000, 4096, 256, 259200000);

    public static final RollCycles DEFAULT;
    private static final Iterable<RollCycle> VALUES;
    private final String format;
    private final int lengthInMillis;
    private final int defaultEpoch;
    private final RollCycleArithmetic arithmetic;
    private final long maxMessagesPerCycle;

    private RollCycles(String format, int lengthInMillis, int indexCount, int indexSpacing) {
        this(format, lengthInMillis, indexCount, indexSpacing, 0);
    }

    private RollCycles(String format, int lengthInMillis, int indexCount, int indexSpacing, int defaultEpoch) {
        this.format = format;
        this.lengthInMillis = lengthInMillis;
        this.defaultEpoch = defaultEpoch;
        this.arithmetic = RollCycleArithmetic.of(indexCount, indexSpacing);
        this.maxMessagesPerCycle = this.arithmetic.maxMessagesPerCycle();
    }

    public static Iterable<RollCycle> all() {
        return VALUES;
    }

    @Override
    public long maxMessagesPerCycle() {
        return this.maxMessagesPerCycle;
    }

    @Override
    public String format() {
        return this.format;
    }

    @Override
    public int lengthInMillis() {
        return this.lengthInMillis;
    }

    @Override
    public int defaultEpoch() {
        return this.defaultEpoch;
    }

    @Override
    public int defaultIndexCount() {
        return this.arithmetic.indexCount();
    }

    @Override
    public int defaultIndexSpacing() {
        return this.arithmetic.indexSpacing();
    }

    @Override
    public long toIndex(int cycle, long sequenceNumber) {
        return this.arithmetic.toIndex(cycle, sequenceNumber);
    }

    @Override
    public long toSequenceNumber(long index) {
        return this.arithmetic.toSequenceNumber(index);
    }

    @Override
    public int toCycle(long index) {
        return this.arithmetic.toCycle(index);
    }

    static {
        DEFAULT = FAST_DAILY;
        ArrayList<Enum> allCycles = new ArrayList<Enum>();
        allCycles.addAll(Arrays.stream(RollCycles.values()).collect(Collectors.toList()));
        allCycles.addAll(Arrays.asList(LegacyRollCycles.values()));
        allCycles.addAll(Arrays.asList(LargeRollCycles.values()));
        allCycles.addAll(Arrays.asList(SparseRollCycles.values()));
        allCycles.addAll(Arrays.asList(TestRollCycles.values()));
        VALUES = Collections.unmodifiableList(allCycles);
    }
}

