/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.BackgroundResourceReleaser;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.ReferenceChangeListener;
import net.openhft.chronicle.core.io.ReferenceCounted;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.util.ThrowingFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferenceCountedCache<K, T extends ReferenceCounted & Closeable, V, E extends Throwable>
extends AbstractCloseable {
    private final Map<K, T> cache = new LinkedHashMap<K, T>();
    private final Function<T, V> transformer;
    private final ThrowingFunction<K, T, E> creator;
    private final ReferenceChangeListener referenceChangeListener;

    public ReferenceCountedCache(Function<T, V> transformer, ThrowingFunction<K, T, E> creator) {
        this.transformer = transformer;
        this.creator = creator;
        this.referenceChangeListener = new TriggerFlushOnLastReferenceRemoval();
        this.singleThreadedCheckDisabled(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    V get(@NotNull K key) throws E {
        V rv;
        this.throwExceptionIfClosed();
        Map<K, T> map = this.cache;
        synchronized (map) {
            @Nullable ReferenceCounted value = (ReferenceCounted)this.cache.get(key);
            if (value == null) {
                value = (ReferenceCounted)this.creator.apply(key);
                value.reserveTransfer(INIT, (ReferenceOwner)this);
                value.addReferenceChangeListener(this.referenceChangeListener);
                this.cache.put(key, value);
            }
            rv = this.transformer.apply(value);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performClose() {
        Map<K, T> map = this.cache;
        synchronized (map) {
            for (ReferenceCounted value : this.cache.values()) {
                this.releaseResource(value);
            }
            this.cache.clear();
        }
    }

    private void releaseResource(T value) {
        try {
            if (value != null) {
                value.release((ReferenceOwner)this);
            }
        }
        catch (Exception e) {
            Jvm.debug().on(((Object)((Object)this)).getClass(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        Map<K, T> map = this.cache;
        synchronized (map) {
            this.releaseResource((ReferenceCounted)this.cache.remove(key));
        }
    }

    private class TriggerFlushOnLastReferenceRemoval
    implements ReferenceChangeListener {
        private final Runnable bgCleanup = this::bgCleanup;

        private TriggerFlushOnLastReferenceRemoval() {
        }

        public void onReferenceRemoved(ReferenceCounted referenceCounted, ReferenceOwner referenceOwner) {
            if (referenceOwner != ReferenceCountedCache.this && referenceCounted.refCount() == 1) {
                BackgroundResourceReleaser.run((Runnable)this.bgCleanup);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void bgCleanup() {
            Map map = ReferenceCountedCache.this.cache;
            synchronized (map) {
                ReferenceCountedCache.this.cache.entrySet().removeIf(entry -> {
                    ReferenceCounted value = (ReferenceCounted)entry.getValue();
                    int refCount = value.refCount();
                    if (refCount == 1) {
                        value.release((ReferenceOwner)ReferenceCountedCache.this);
                    }
                    return refCount <= 1;
                });
            }
        }
    }
}

