/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.internal.util;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.util.FileState;
import org.jetbrains.annotations.NotNull;

public final class InternalFileUtil {
    private static final Comparator<File> EARLIEST_FIRST = Comparator.comparing(File::getName);

    private InternalFileUtil() {
    }

    @NotNull
    public static Stream<File> removableRollFileCandidates(@NotNull File baseDir) {
        Stream<File> stream;
        if (baseDir == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'baseDir') of net/openhft/chronicle/queue/internal/util/InternalFileUtil.removableRollFileCandidates must not be null");
        }
        if (baseDir == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'baseDir') of net/openhft/chronicle/queue/internal/util/InternalFileUtil.removableRollFileCandidates must not be null");
        }
        InternalFileUtil.assertOsSupported();
        File[] files = baseDir.listFiles(InternalFileUtil::hasQueueSuffix);
        if (files == null) {
            Stream<File> stream2 = Stream.empty();
            if (stream2 == null) {
                throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/internal/util/InternalFileUtil.removableRollFileCandidates must not return null");
            }
            if (stream2 == null) {
                throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/internal/util/InternalFileUtil.removableRollFileCandidates must not return null");
            }
            return stream2;
        }
        List sortedInitialCandidates = Stream.of(files).sorted(EARLIEST_FIRST).collect(Collectors.toList());
        Stream.Builder<File> builder = Stream.builder();
        try {
            File file;
            Set<String> allOpenFiles = InternalFileUtil.getAllOpenFiles();
            Iterator iterator = sortedInitialCandidates.iterator();
            while (iterator.hasNext() && InternalFileUtil.state(file = (File)iterator.next(), allOpenFiles) == FileState.CLOSED) {
                builder.accept(file);
            }
            stream = builder.build();
        }
        catch (IOException e) {
            Jvm.warn().on(InternalFileUtil.class, "Error getting removable candidates", (Throwable)e);
            Stream<File> stream3 = Stream.empty();
            if (stream3 == null) {
                throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/internal/util/InternalFileUtil.removableRollFileCandidates must not return null");
            }
            if (stream3 == null) {
                throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/internal/util/InternalFileUtil.removableRollFileCandidates must not return null");
            }
            return stream3;
        }
        if (stream == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/internal/util/InternalFileUtil.removableRollFileCandidates must not return null");
        }
        if (stream == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/internal/util/InternalFileUtil.removableRollFileCandidates must not return null");
        }
        return stream;
    }

    public static boolean hasQueueSuffix(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/internal/util/InternalFileUtil.hasQueueSuffix must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/internal/util/InternalFileUtil.hasQueueSuffix must not be null");
        }
        return file.getName().endsWith(".cq4");
    }

    public static FileState state(@NotNull File file) {
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/internal/util/InternalFileUtil.state must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/internal/util/InternalFileUtil.state must not be null");
        }
        try {
            return InternalFileUtil.state(file, InternalFileUtil.getAllOpenFiles());
        }
        catch (IOException iOException) {
            return FileState.UNDETERMINED;
        }
    }

    public static FileState state(@NotNull File file, Set<String> allOpenFiles) {
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/internal/util/InternalFileUtil.state must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/internal/util/InternalFileUtil.state must not be null");
        }
        InternalFileUtil.assertOsSupported();
        if (!file.exists()) {
            return FileState.NON_EXISTENT;
        }
        String absolutePath = file.getAbsolutePath();
        return allOpenFiles.contains(absolutePath) ? FileState.OPEN : FileState.CLOSED;
    }

    /*
     * Exception decompiling
     */
    private static FileState stateWindows(@NotNull File file) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void assertOsSupported() {
        if (!InternalFileUtil.getAllOpenFilesIsSupportedOnOS()) {
            throw new UnsupportedOperationException("This operation is not supported on your operating system");
        }
    }

    public static boolean getAllOpenFilesIsSupportedOnOS() {
        return Files.exists(Paths.get("/proc/self/fd", new String[0]), new LinkOption[0]);
    }

    public static Set<String> getAllOpenFiles() throws IOException {
        InternalFileUtil.assertOsSupported();
        ProcFdWalker visitor = new ProcFdWalker();
        Files.walkFileTree(Paths.get("/proc/", new String[0]), Collections.emptySet(), 3, visitor);
        return visitor.openFiles;
    }

    private static class ProcFdWalker
    extends SimpleFileVisitor<Path> {
        private final Set<String> openFiles = new HashSet<String>();

        private ProcFdWalker() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
            if (file.toAbsolutePath().toString().matches("/proc/\\d+/fd/\\d+")) {
                try {
                    String e = file.toRealPath(new LinkOption[0]).toAbsolutePath().toString();
                    this.openFiles.add(e);
                }
                catch (AccessDeniedException | NoSuchFileException e) {
                }
                catch (IOException e) {
                    Jvm.warn().on(ProcFdWalker.class, "Error resolving " + file, (Throwable)e);
                }
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) {
            if (!(exc instanceof AccessDeniedException) && !(exc instanceof NoSuchFileException)) {
                Jvm.warn().on(ProcFdWalker.class, "Error visiting file", (Throwable)exc);
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
            if (!dir.toAbsolutePath().toString().matches("/proc(/\\d+(/fd)?)?")) {
                return FileVisitResult.SKIP_SUBTREE;
            }
            return FileVisitResult.CONTINUE;
        }
    }
}

