/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.table;

import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.StackTrace;
import net.openhft.chronicle.core.annotation.UsedViaReflection;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.scoped.ScopedResource;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.MetaDataField;
import net.openhft.chronicle.queue.impl.table.Metadata;
import net.openhft.chronicle.queue.impl.table.TableStoreIterator;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleTableStore<T extends Metadata>
extends AbstractCloseable
implements TableStore<T> {
    public static final String SUFFIX = ".cq4t";
    private static final int EXCLUSIVE_LOCK_SIZE = 1;
    private static final long EXCLUSIVE_LOCK_START = 0x7FFFFFFFFFFFFFFEL;
    private static final long timeoutMS = Jvm.getLong((String)"chronicle.table.store.timeoutMS", (Long)10000L);
    @NotNull
    private final WireType wireType;
    @NotNull
    private final T metadata;
    @NotNull
    private final MappedBytes mappedBytes;
    @NotNull
    private final MappedFile mappedFile;
    @NotNull
    private final Wire mappedWire;

    @UsedViaReflection
    private SingleTableStore(@NotNull WireIn wire) {
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/table/SingleTableStore.<init> must not be null");
        }
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/table/SingleTableStore.<init> must not be null");
        }
        this.wireType = (WireType)Objects.requireNonNull(wire.read((WireKey)MetaDataField.wireType).object(WireType.class));
        this.mappedBytes = (MappedBytes)wire.bytes();
        this.mappedFile = this.mappedBytes.mappedFile();
        wire.consumePadding();
        this.metadata = wire.bytes().readRemaining() > 0L ? (Metadata)Objects.requireNonNull(wire.read((WireKey)MetaDataField.metadata).typedMarshallable()) : Metadata.NoMeta.INSTANCE;
        this.mappedWire = (Wire)this.wireType.apply((Object)this.mappedBytes);
        this.mappedWire.usePadding(true);
        this.singleThreadedCheckDisabled(true);
    }

    SingleTableStore(@NotNull WireType wireType, @NotNull MappedBytes mappedBytes, @NotNull T metadata) {
        if (wireType == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wireType') of net/openhft/chronicle/queue/impl/table/SingleTableStore.<init> must not be null");
        }
        if (mappedBytes == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'mappedBytes') of net/openhft/chronicle/queue/impl/table/SingleTableStore.<init> must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 (parameter 'metadata') of net/openhft/chronicle/queue/impl/table/SingleTableStore.<init> must not be null");
        }
        if (wireType == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wireType') of net/openhft/chronicle/queue/impl/table/SingleTableStore.<init> must not be null");
        }
        if (mappedBytes == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'mappedBytes') of net/openhft/chronicle/queue/impl/table/SingleTableStore.<init> must not be null");
        }
        if (metadata == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 (parameter 'metadata') of net/openhft/chronicle/queue/impl/table/SingleTableStore.<init> must not be null");
        }
        this.wireType = wireType;
        this.metadata = metadata;
        this.mappedBytes = mappedBytes;
        this.mappedFile = mappedBytes.mappedFile();
        this.mappedWire = (Wire)wireType.apply((Object)mappedBytes);
        this.mappedWire.usePadding(true);
        this.singleThreadedCheckDisabled(true);
    }

    public static <T, R> R doWithSharedLock(@NotNull File file, @NotNull Function<T, ? extends R> code, @NotNull Supplier<T> target) {
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithSharedLock must not be null");
        }
        if (code == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'code') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithSharedLock must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 (parameter 'target') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithSharedLock must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithSharedLock must not be null");
        }
        if (code == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'code') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithSharedLock must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 (parameter 'target') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithSharedLock must not be null");
        }
        return SingleTableStore.doWithLock(file, code, target, true);
    }

    public static <T, R> R doWithExclusiveLock(@NotNull File file, @NotNull Function<T, ? extends R> code, @NotNull Supplier<T> target) {
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithExclusiveLock must not be null");
        }
        if (code == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'code') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithExclusiveLock must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 (parameter 'target') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithExclusiveLock must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithExclusiveLock must not be null");
        }
        if (code == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'code') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithExclusiveLock must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 (parameter 'target') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithExclusiveLock must not be null");
        }
        return SingleTableStore.doWithLock(file, code, target, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <T, R> R doWithLock(@NotNull File file, @NotNull Function<T, ? extends R> code, @NotNull Supplier<T> target, boolean shared) {
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithLock must not be null");
        }
        if (code == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'code') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithLock must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 (parameter 'target') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithLock must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'file') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithLock must not be null");
        }
        if (code == null) {
            throw new IllegalArgumentException("NotNull annotated argument 1 (parameter 'code') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithLock must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("NotNull annotated argument 2 (parameter 'target') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithLock must not be null");
        }
        String type = shared ? "shared" : "exclusive";
        StandardOpenOption readOrWrite = shared ? StandardOpenOption.READ : StandardOpenOption.WRITE;
        long timeoutAt = System.currentTimeMillis() + timeoutMS;
        long startMs = System.currentTimeMillis();
        try (FileChannel channel = FileChannel.open(file.toPath(), readOrWrite);){
            int count = 1;
            while (System.currentTimeMillis() < timeoutAt) {
                block42: {
                    try {
                        Throwable throwable;
                        FileLock fileLock;
                        block40: {
                            R r;
                            block41: {
                                fileLock = channel.tryLock(0x7FFFFFFFFFFFFFFEL, 1L, shared);
                                throwable = null;
                                if (fileLock == null) break block40;
                                r = code.apply(target.get());
                                if (fileLock == null) return r;
                                if (throwable == null) break block41;
                                try {
                                    fileLock.close();
                                    return r;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                    return r;
                                }
                            }
                            fileLock.close();
                            return r;
                        }
                        if (fileLock == null) break block42;
                        if (throwable != null) {
                            try {
                                fileLock.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            break block42;
                        } else {
                            fileLock.close();
                        }
                        break block42;
                        catch (Throwable throwable4) {
                            try {
                                throwable = throwable4;
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                if (fileLock == null) throw throwable5;
                                if (throwable == null) {
                                    fileLock.close();
                                    throw throwable5;
                                }
                                try {
                                    fileLock.close();
                                    throw throwable5;
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                    throw throwable5;
                                }
                            }
                        }
                    }
                    catch (IOException | OverlappingFileLockException e) {
                        if (count <= 9 || !Jvm.isDebugEnabled(SingleTableStore.class)) break block42;
                        long elapsedMs = System.currentTimeMillis() - startMs;
                        String message = "Failed to acquire " + type + " lock on the table store file. Retrying, file=" + file.getAbsolutePath() + ", count=" + count + ", elapsed=" + elapsedMs + " ms";
                        Jvm.debug().on(SingleTableStore.class, "", (Throwable)new StackTrace(message));
                    }
                }
                int delay = Math.min(250, count * count);
                Jvm.pause((long)delay);
                ++count;
            }
            throw new IllegalStateException("Unable to claim exclusive " + type + " lock on file " + file);
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't perform operation with " + type + " file lock", e);
        }
    }

    @Override
    @NotNull
    public File file() {
        File file = this.mappedFile.file();
        if (file == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableStore.file must not return null");
        }
        if (file == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableStore.file must not return null");
        }
        return file;
    }

    @Override
    @NotNull
    public String dump() {
        String string = this.dump(this.wireType);
        if (string == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableStore.dump must not return null");
        }
        if (string == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableStore.dump must not return null");
        }
        return string;
    }

    @Override
    public String dump(WireType wireType) {
        return this.dump(wireType, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String dump(@NotNull WireType wireType, boolean abbrev) {
        if (wireType == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wireType') of net/openhft/chronicle/queue/impl/table/SingleTableStore.dump must not be null");
        }
        if (wireType == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wireType') of net/openhft/chronicle/queue/impl/table/SingleTableStore.dump must not be null");
        }
        MappedBytes bytes = MappedBytes.mappedBytes((MappedFile)this.mappedFile);
        try {
            bytes.readLimit(bytes.realCapacity());
            Wire wire = (Wire)wireType.apply((Object)bytes);
            String string = Wires.fromSizePrefixedBlobs((WireIn)wire, (boolean)abbrev);
            return string;
        }
        finally {
            bytes.releaseLast();
        }
    }

    @Override
    @NotNull
    public String shortDump() {
        this.throwExceptionIfClosed();
        String string = this.dump(this.wireType, true);
        if (string == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableStore.shortDump must not return null");
        }
        if (string == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableStore.shortDump must not return null");
        }
        return string;
    }

    protected void performClose() {
        this.mappedBytes.releaseLast();
    }

    @Override
    @NotNull
    public MappedBytes bytes() {
        this.throwExceptionIfClosed();
        MappedBytes mappedBytes = MappedBytes.mappedBytes((MappedFile)this.mappedFile);
        if (mappedBytes == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableStore.bytes must not return null");
        }
        if (mappedBytes == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableStore.bytes must not return null");
        }
        return mappedBytes;
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getSimpleName() + "{wireType=" + this.wireType + ", mappedFile=" + this.mappedFile + '}';
        if (string == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableStore.toString must not return null");
        }
        if (string == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/impl/table/SingleTableStore.toString must not return null");
        }
        return string;
    }

    private void onCleanup() {
        this.mappedBytes.releaseLast();
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/table/SingleTableStore.writeMarshallable must not be null");
        }
        if (wire == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'wire') of net/openhft/chronicle/queue/impl/table/SingleTableStore.writeMarshallable must not be null");
        }
        wire.write((WireKey)MetaDataField.wireType).object((Object)this.wireType);
        if (this.metadata != Metadata.NoMeta.INSTANCE) {
            wire.write((WireKey)MetaDataField.metadata).typedMarshallable(this.metadata);
        }
        wire.writeAlignTo(4, 0);
    }

    @Override
    public synchronized LongValue acquireValueFor(CharSequence key, long defaultValue) {
        if (this.mappedBytes.isClosed()) {
            throw new ClosedIllegalStateException("Closed");
        }
        this.mappedBytes.reserve((ReferenceOwner)this);
        try {
            int header;
            this.mappedBytes.readPosition(0L);
            this.mappedBytes.readLimit(Math.min(this.mappedBytes.writeLimit(), this.mappedBytes.realCapacity()));
            while (this.mappedWire.readDataHeader() && !Wires.isNotComplete((int)(header = this.mappedBytes.readVolatileInt()))) {
                long readPosition = this.mappedBytes.readPosition();
                int length = Wires.lengthOf((int)header);
                ValueIn valueIn = SingleTableStore.readEventIfNameEquals((WireIn)this.mappedWire, key);
                if (valueIn != null) {
                    LongValue longValue = valueIn.int64ForBinding(null);
                    return longValue;
                }
                this.mappedBytes.readPosition(readPosition + (long)length);
            }
            if (this.mappedBytes.isBackingFileReadOnly()) {
                throw new IllegalStateException("key " + key + " does not exist in readOnly TableStore and cannot be created");
            }
            this.mappedBytes.writeLimit(this.mappedBytes.realCapacity());
            long start = this.mappedBytes.readPosition();
            this.mappedBytes.writePosition(start);
            long pos = this.mappedWire.enterHeader(128L);
            LongValue longValue = (LongValue)this.wireType.newLongReference().get();
            this.mappedWire.writeEventName(key).int64forBinding(defaultValue, longValue);
            this.mappedWire.writeAlignTo(4, 0);
            this.mappedWire.updateHeader(pos, false, 0);
            long end = this.mappedBytes.writePosition();
            long chuckSize = this.mappedFile.chunkSize();
            long overlapSize = this.mappedFile.overlapSize();
            long endOfChunk = (start + chuckSize - 1L) / chuckSize * chuckSize;
            if (end >= endOfChunk + overlapSize) {
                throw new IllegalStateException("Misaligned write");
            }
            LongValue longValue2 = longValue;
            return longValue2;
        }
        catch (EOFException | StreamCorruptedException e) {
            throw new IORuntimeException((Throwable)e);
        }
        finally {
            this.mappedBytes.release((ReferenceOwner)this);
        }
    }

    @Nullable
    private static ValueIn readEventIfNameEquals(WireIn wireIn, CharSequence expected) {
        try (ScopedResource stlSb = Wires.acquireStringBuilderScoped();){
            StringBuilder sb = (StringBuilder)stlSb.get();
            ValueIn valueIn = wireIn.readEventName(sb);
            if (StringUtils.equalsCaseIgnore((CharSequence)expected, (CharSequence)sb)) {
                ValueIn valueIn2 = valueIn;
                return valueIn2;
            }
            ValueIn valueIn3 = null;
            return valueIn3;
        }
    }

    @Override
    public synchronized <T> void forEachKey(T accumulator, TableStoreIterator<T> tsIterator) {
        this.mappedBytes.reserve((ReferenceOwner)this);
        try (ScopedResource stlSb = Wires.acquireStringBuilderScoped();){
            StringBuilder sb = (StringBuilder)stlSb.get();
            this.mappedBytes.readPosition(0L);
            this.mappedBytes.readLimit(this.mappedBytes.realCapacity());
            while (this.mappedWire.readDataHeader()) {
                int header = this.mappedBytes.readVolatileInt();
                if (Wires.isNotComplete((int)header)) {
                    break;
                }
                long readPosition = this.mappedBytes.readPosition();
                int length = Wires.lengthOf((int)header);
                ValueIn valueIn = this.mappedWire.readEventName(sb);
                tsIterator.accept(accumulator, sb, valueIn);
                this.mappedBytes.readPosition(readPosition + (long)length);
            }
        }
        catch (EOFException e) {
            throw new IORuntimeException((Throwable)e);
        }
        finally {
            this.mappedBytes.release((ReferenceOwner)this);
        }
    }

    @Override
    public <R> R doWithExclusiveLock(@NotNull Function<TableStore<T>, ? extends R> code) {
        if (code == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'code') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithExclusiveLock must not be null");
        }
        if (code == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'code') of net/openhft/chronicle/queue/impl/table/SingleTableStore.doWithExclusiveLock must not be null");
        }
        return SingleTableStore.doWithExclusiveLock(this.file(), code, () -> this);
    }

    @Override
    public T metadata() {
        return this.metadata;
    }
}

