/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.ThreadLocalAppender;
import net.openhft.chronicle.wire.BinaryMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.VanillaMethodWriterBuilder;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public interface ChronicleQueue
extends Closeable {
    @NotNull
    public static ChronicleQueue single(@NotNull String pathName) {
        if (pathName == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'pathName') of net/openhft/chronicle/queue/ChronicleQueue.single must not be null");
        }
        if (pathName == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'pathName') of net/openhft/chronicle/queue/ChronicleQueue.single must not be null");
        }
        SingleChronicleQueue singleChronicleQueue = SingleChronicleQueueBuilder.single(pathName).build();
        if (singleChronicleQueue == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleQueue.single must not return null");
        }
        if (singleChronicleQueue == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleQueue.single must not return null");
        }
        return singleChronicleQueue;
    }

    @NotNull
    public static SingleChronicleQueueBuilder singleBuilder() {
        SingleChronicleQueueBuilder singleChronicleQueueBuilder = SingleChronicleQueueBuilder.single();
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleQueue.singleBuilder must not return null");
        }
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleQueue.singleBuilder must not return null");
        }
        return singleChronicleQueueBuilder;
    }

    @NotNull
    public static SingleChronicleQueueBuilder singleBuilder(@NotNull String pathName) {
        if (pathName == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'pathName') of net/openhft/chronicle/queue/ChronicleQueue.singleBuilder must not be null");
        }
        if (pathName == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'pathName') of net/openhft/chronicle/queue/ChronicleQueue.singleBuilder must not be null");
        }
        SingleChronicleQueueBuilder singleChronicleQueueBuilder = SingleChronicleQueueBuilder.binary(pathName);
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleQueue.singleBuilder must not return null");
        }
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleQueue.singleBuilder must not return null");
        }
        return singleChronicleQueueBuilder;
    }

    @NotNull
    public static SingleChronicleQueueBuilder singleBuilder(@NotNull File path) {
        if (path == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'path') of net/openhft/chronicle/queue/ChronicleQueue.singleBuilder must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'path') of net/openhft/chronicle/queue/ChronicleQueue.singleBuilder must not be null");
        }
        SingleChronicleQueueBuilder singleChronicleQueueBuilder = SingleChronicleQueueBuilder.binary(path);
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleQueue.singleBuilder must not return null");
        }
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleQueue.singleBuilder must not return null");
        }
        return singleChronicleQueueBuilder;
    }

    @NotNull
    public static SingleChronicleQueueBuilder singleBuilder(@NotNull Path path) {
        if (path == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'path') of net/openhft/chronicle/queue/ChronicleQueue.singleBuilder must not be null");
        }
        if (path == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'path') of net/openhft/chronicle/queue/ChronicleQueue.singleBuilder must not be null");
        }
        SingleChronicleQueueBuilder singleChronicleQueueBuilder = SingleChronicleQueueBuilder.binary(path);
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleQueue.singleBuilder must not return null");
        }
        if (singleChronicleQueueBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleQueue.singleBuilder must not return null");
        }
        return singleChronicleQueueBuilder;
    }

    @NotNull
    public ExcerptTailer createTailer();

    @NotNull
    default public ExcerptTailer createTailer(String id) {
        throw new UnsupportedOperationException("not currently supported in this implementation.");
    }

    default public LongValue indexForId(String id) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Deprecated
    @NotNull
    public ExcerptAppender acquireAppender();

    @NotNull
    public ExcerptAppender createAppender();

    public long firstIndex();

    public long lastIndex();

    @NotNull
    public WireType wireType();

    public void clear();

    @NotNull
    public File file();

    @NotNull
    default public String fileAbsolutePath() {
        String string = this.file().getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleQueue.fileAbsolutePath must not return null");
        }
        if (string == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleQueue.fileAbsolutePath must not return null");
        }
        return string;
    }

    @NotNull
    public String dump();

    public void dump(Writer var1, long var2, long var4);

    /*
     * WARNING - void declaration
     */
    default public void dump(@NotNull OutputStream stream, long fromIndex, long l) {
        void toIndex;
        if (stream == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'stream') of net/openhft/chronicle/queue/ChronicleQueue.dump must not be null");
        }
        if (stream == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'stream') of net/openhft/chronicle/queue/ChronicleQueue.dump must not be null");
        }
        this.dump(new OutputStreamWriter(stream, StandardCharsets.UTF_8), fromIndex, (long)toIndex);
    }

    public int sourceId();

    @NotNull
    default public <T> T methodWriter(@NotNull Class<T> tClass, Class ... additional) {
        if (tClass == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'tClass') of net/openhft/chronicle/queue/ChronicleQueue.methodWriter must not be null");
        }
        if (tClass == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'tClass') of net/openhft/chronicle/queue/ChronicleQueue.methodWriter must not be null");
        }
        VanillaMethodWriterBuilder<T> builder = this.methodWriterBuilder(tClass);
        Stream.of(additional).forEach(arg_0 -> builder.addInterface(arg_0));
        Object object = builder.build();
        if (object == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleQueue.methodWriter must not return null");
        }
        if (object == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleQueue.methodWriter must not return null");
        }
        return (T)object;
    }

    @NotNull
    default public <T> VanillaMethodWriterBuilder<T> methodWriterBuilder(@NotNull Class<T> tClass) {
        if (tClass == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'tClass') of net/openhft/chronicle/queue/ChronicleQueue.methodWriterBuilder must not be null");
        }
        if (tClass == null) {
            throw new IllegalArgumentException("NotNull annotated argument 0 (parameter 'tClass') of net/openhft/chronicle/queue/ChronicleQueue.methodWriterBuilder must not be null");
        }
        Supplier<MarshallableOut> marshallableOutSupplier = () -> ThreadLocalAppender.acquireThreadLocalAppender(this);
        VanillaMethodWriterBuilder builder = new VanillaMethodWriterBuilder(tClass, this.wireType(), () -> new BinaryMethodWriterInvocationHandler(tClass, false, marshallableOutSupplier));
        builder.marshallableOutSupplier(marshallableOutSupplier);
        VanillaMethodWriterBuilder vanillaMethodWriterBuilder = builder;
        if (vanillaMethodWriterBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleQueue.methodWriterBuilder must not return null");
        }
        if (vanillaMethodWriterBuilder == null) {
            throw new IllegalStateException("NotNull method net/openhft/chronicle/queue/ChronicleQueue.methodWriterBuilder must not return null");
        }
        return vanillaMethodWriterBuilder;
    }

    @NotNull
    public RollCycle rollCycle();

    public TimeProvider time();

    public int deltaCheckpointInterval();

    default public long lastIndexReplicated() {
        return -1L;
    }

    default public long lastAcknowledgedIndexReplicated() {
        return -1L;
    }

    default public long lastIndexMSynced() {
        return -1L;
    }

    public void lastIndexReplicated(long var1);

    public void lastAcknowledgedIndexReplicated(long var1);

    default public void lastIndexMSynced(long lastIndexMSynced) {
        throw new UnsupportedOperationException();
    }

    public void refreshDirectoryListing();

    @NotNull
    public String dumpLastHeader();
}

