/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.queue.impl.TableStore;
import net.openhft.chronicle.queue.impl.single.QueueLock;
import net.openhft.chronicle.queue.impl.table.AbstractTSQueueLock;
import net.openhft.chronicle.threads.TimingPauser;

public class TSQueueLock
extends AbstractTSQueueLock
implements QueueLock {
    private static final String LOCK_KEY = "chronicle.queue.lock";
    private static final int PID = Jvm.getProcessId();
    private final long timeout;

    public TSQueueLock(TableStore<?> tableStore, Supplier<TimingPauser> pauser, Long timeoutMs) {
        super(LOCK_KEY, tableStore, pauser);
        this.timeout = timeoutMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void acquireLock() {
        this.throwExceptionIfClosed();
        long tid = Thread.currentThread().getId();
        if (this.isLockHeldByCurrentThread(tid)) {
            return;
        }
        try {
            int count = 0;
            while (!this.lock.compareAndSwapValue(Long.MIN_VALUE, this.getLockValueFromTid(tid))) {
                if (count++ > 1000 && Thread.interrupted()) {
                    throw new IllegalStateException("Interrupted");
                }
                this.pauser.pause(this.timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (TimeoutException e) {
            Jvm.warn().on(this.getClass(), "Couldn't acquire lock after " + this.timeout + "ms for the lock file:" + this.path + ", overriding the lock. Lock was held by PID " + this.lock.getVolatileValue());
            this.forceUnlock();
            this.acquireLock();
        }
        finally {
            this.pauser.reset();
        }
    }

    private long getLockValueFromTid(long tid) {
        return tid << 32 | (long)PID;
    }

    @Override
    public void waitForLock() {
        this.throwExceptionIfClosed();
        long tid = Thread.currentThread().getId();
        if (this.isLockHeldByCurrentThread(tid)) {
            return;
        }
        try {
            while (this.lock.getVolatileValue() != Long.MIN_VALUE) {
                if (Thread.interrupted()) {
                    throw new IllegalStateException("Interrupted");
                }
                this.pauser.pause(this.timeout, TimeUnit.MILLISECONDS);
            }
        }
        catch (TimeoutException e) {
            Jvm.warn().on(this.getClass(), "Queue lock is still held after " + this.timeout + "ms for the lock file:" + this.path + ". Lock is held by PID " + this.lock.getVolatileValue() + ". Unlocking forcibly");
            this.forceUnlock();
        }
        catch (NullPointerException ex) {
            if (!this.tableStore.isClosed()) {
                throw ex;
            }
            throw new IllegalStateException("The table store is closed!", ex);
        }
        finally {
            this.pauser.reset();
        }
    }

    @Override
    public void unlock() {
        if (this.isClosed()) {
            Jvm.warn().on(this.getClass(), "Cannot unlock as already closed");
            return;
        }
        long tid = Thread.currentThread().getId();
        if (!this.isLockHeldByCurrentThread(tid)) {
            String absolutePath = "unknown";
            if (this.tableStore != null && this.tableStore.file() != null) {
                absolutePath = Objects.requireNonNull(this.tableStore.file()).getAbsolutePath();
            }
            throw new IllegalStateException("Can't unlock when lock is not held by this thread, tableStore.file=" + absolutePath);
        }
        if (!this.lock.compareAndSwapValue(this.getLockValueFromTid(tid), Long.MIN_VALUE)) {
            Jvm.warn().on(this.getClass(), "Queue lock was unlocked by someone else!");
        }
    }

    private boolean isLockHeldByCurrentThread(long tid) {
        return this.lock.getVolatileValue() == this.getLockValueFromTid(tid);
    }
}

