/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.wire.BinaryMethodWriterInvocationHandler;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.VanillaMethodWriterBuilder;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public interface ChronicleQueue
extends Closeable {
    public static final int TEST_BLOCK_SIZE = 65536;

    public static ChronicleQueue single(@NotNull String pathName) {
        return SingleChronicleQueueBuilder.single(pathName).build();
    }

    public static SingleChronicleQueueBuilder singleBuilder() {
        return SingleChronicleQueueBuilder.single();
    }

    public static SingleChronicleQueueBuilder singleBuilder(@NotNull String pathName) {
        return SingleChronicleQueueBuilder.binary(pathName);
    }

    public static SingleChronicleQueueBuilder singleBuilder(@NotNull File path) {
        return SingleChronicleQueueBuilder.binary(path);
    }

    public static SingleChronicleQueueBuilder singleBuilder(@NotNull Path path) {
        return SingleChronicleQueueBuilder.binary(path);
    }

    @NotNull
    public ExcerptTailer createTailer();

    @NotNull
    default public ExcerptTailer createTailer(String id) {
        throw new UnsupportedOperationException("not currently supported in this implementation.");
    }

    @NotNull
    public ExcerptAppender acquireAppender();

    @Deprecated
    @NotNull
    default public ExcerptAppender createAppender() {
        return this.acquireAppender();
    }

    public long firstIndex();

    @NotNull
    public WireType wireType();

    public void clear();

    @NotNull
    public File file();

    @NotNull
    default public String fileAbsolutePath() {
        return this.file().getAbsolutePath();
    }

    @NotNull
    public String dump();

    public void dump(Writer var1, long var2, long var4);

    default public void dump(@NotNull OutputStream stream, long fromIndex, long toIndex) {
        this.dump(new OutputStreamWriter(stream, StandardCharsets.UTF_8), fromIndex, toIndex);
    }

    public int sourceId();

    default public <T> T methodWriter(@NotNull Class<T> tClass, Class ... additional) {
        VanillaMethodWriterBuilder<T> builder = this.methodWriterBuilder(tClass);
        Stream.of(additional).forEach(arg_0 -> builder.addInterface(arg_0));
        return (T)builder.build();
    }

    @NotNull
    default public <T> VanillaMethodWriterBuilder<T> methodWriterBuilder(@NotNull Class<T> tClass) {
        VanillaMethodWriterBuilder builder = new VanillaMethodWriterBuilder(tClass, this.wireType(), () -> new BinaryMethodWriterInvocationHandler(false, this::acquireAppender));
        builder.marshallableOut((MarshallableOut)this.acquireAppender());
        return builder;
    }

    public RollCycle rollCycle();

    public TimeProvider time();

    public int deltaCheckpointInterval();

    public long lastIndexReplicated();

    public long lastAcknowledgedIndexReplicated();

    public void lastIndexReplicated(long var1);

    public void lastAcknowledgedIndexReplicated(long var1);

    public void refreshDirectoryListing();

    @NotNull
    public String dumpLastHeader();
}

