/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.text.ParseException;
import java.util.NavigableSet;
import net.openhft.chronicle.core.io.ReferenceOwner;
import net.openhft.chronicle.core.io.SimpleCloseable;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.impl.StoreFileListener;
import net.openhft.chronicle.queue.impl.WireStoreSupplier;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WireStorePool
extends SimpleCloseable {
    @NotNull
    private final WireStoreSupplier supplier;
    private final StoreFileListener storeFileListener;

    private WireStorePool(@NotNull WireStoreSupplier supplier, StoreFileListener storeFileListener) {
        this.supplier = supplier;
        this.storeFileListener = storeFileListener;
    }

    @NotNull
    public static WireStorePool withSupplier(@NotNull WireStoreSupplier supplier, StoreFileListener storeFileListener) {
        return new WireStorePool(supplier, storeFileListener);
    }

    @Nullable
    public SingleChronicleQueueStore acquire(int cycle, long epoch, boolean createIfAbsent, SingleChronicleQueueStore oldStore) {
        this.throwExceptionIfClosed();
        SingleChronicleQueueStore store = this.supplier.acquire(cycle, createIfAbsent);
        if (store != null && store != oldStore) {
            this.storeFileListener.onAcquired(cycle, store.file());
            store.cycle(cycle);
        }
        return store;
    }

    public int nextCycle(int currentCycle, @NotNull TailerDirection direction) throws ParseException {
        this.throwExceptionIfClosed();
        return this.supplier.nextCycle(currentCycle, direction);
    }

    public void release(ReferenceOwner owner, @NotNull SingleChronicleQueueStore store) {
        this.throwExceptionIfClosed();
        store.close();
        this.storeFileListener.onReleased(store.cycle(), store.file());
    }

    public NavigableSet<Long> listCyclesBetween(int lowerCycle, int upperCycle) throws ParseException {
        this.throwExceptionIfClosed();
        return this.supplier.cycles(lowerCycle, upperCycle);
    }
}

