/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.util.function.LongSupplier;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import org.jetbrains.annotations.NotNull;

class PretoucherState {
    private static final int HEAD_ROOM = Integer.getInteger("PretoucherState.headRoom", 0x100000);
    @NotNull
    private final LongSupplier posSupplier;
    private int minHeadRoom;
    private long lastTouchedPage = 0L;
    private long lastTouchedPos = 0L;
    private long lastPos = 0L;
    private int lastBytesHashcode = -1;
    private long averageMove = 0L;

    public PretoucherState(@NotNull LongSupplier posSupplier) {
        this(posSupplier, HEAD_ROOM);
    }

    public PretoucherState(@NotNull LongSupplier posSupplier, int minHeadRoom) {
        this.posSupplier = posSupplier;
        this.minHeadRoom = minHeadRoom;
    }

    static File getFile(MappedBytes bytes) {
        if (bytes == null) {
            return new File("none");
        }
        return bytes.mappedFile().file();
    }

    public void pretouch(MappedBytes bytes) {
        long pos;
        try {
            pos = this.posSupplier.getAsLong();
        }
        catch (NullPointerException npe) {
            throw new IllegalStateException("Encountered an NPE, possibly because the store was released by something else", npe);
        }
        int pageSize = OS.pageSize();
        if (this.lastBytesHashcode != System.identityHashCode(bytes)) {
            this.lastTouchedPage = pos - pos % (long)pageSize;
            this.lastTouchedPos = pos;
            this.lastBytesHashcode = System.identityHashCode(bytes);
            this.averageMove = OS.pageSize();
            this.lastPos = pos;
            if (Jvm.isDebugEnabled(this.getClass())) {
                String message = PretoucherState.getFile(bytes) + " - Reset pretoucher to pos " + pos + " as the underlying MappedBytes changed.";
                this.debug(message);
            }
        } else {
            long moved = pos - this.lastPos;
            this.averageMove = moved / 4L + this.averageMove * 3L / 4L;
            long neededHeadRoom = Math.max((long)this.minHeadRoom, this.averageMove * 4L);
            long neededEnd = pos + neededHeadRoom;
            if (this.lastTouchedPage < neededEnd) {
                Thread thread = Thread.currentThread();
                int count = 0;
                int pretouch = 0;
                while (this.lastTouchedPage < neededEnd && !thread.isInterrupted()) {
                    if (this.touchPage(bytes, this.lastTouchedPage)) {
                        ++pretouch;
                    }
                    ++count;
                    this.lastTouchedPage += (long)pageSize;
                }
                this.onTouched(count);
                if (pretouch < count) {
                    this.minHeadRoom += 262144;
                    if (Jvm.isDebugEnabled(this.getClass())) {
                        this.debug("pretouch for only " + pretouch + " of " + count + " min: " + (this.minHeadRoom >> 20) + " MB.");
                    }
                }
                long pos2 = this.posSupplier.getAsLong();
                if (Jvm.isDebugEnabled(this.getClass())) {
                    String message = PretoucherState.getFile(bytes) + ": Advanced " + (pos - this.lastTouchedPos) / 1024L + " KB, avg " + this.averageMove / 1024L + " KB between pretouch() and " + (pos2 - pos) / 1024L + " KB while mapping of " + pretouch * pageSize / 1024 + " KB ";
                    this.debug(message);
                }
                this.lastTouchedPos = pos;
            }
            this.lastPos = pos;
        }
    }

    protected void debug(String message) {
        Jvm.debug().on(this.getClass(), message);
    }

    protected boolean touchPage(MappedBytes bytes, long offset) {
        return bytes != null && bytes.compareAndSwapLong(offset, 0L, 0L);
    }

    protected void onTouched(int count) {
    }
}

