/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.nio.BufferOverflowException;
import java.text.ParseException;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesIn;
import net.openhft.chronicle.bytes.BytesMarshallable;
import net.openhft.chronicle.bytes.BytesOut;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.NoBytesStore;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.bytes.util.DecoratedBufferUnderflowException;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.UnsafeMemory;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.pool.StringBuilderPool;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.TailerState;
import net.openhft.chronicle.queue.impl.CommonStore;
import net.openhft.chronicle.queue.impl.ExcerptContext;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.WireStorePool;
import net.openhft.chronicle.queue.impl.single.Pretoucher;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.queue.impl.single.StoreComponentReferenceHandler;
import net.openhft.chronicle.queue.impl.single.WriteLock;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.BinaryReadDocumentContext;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.MarshallableOut;
import net.openhft.chronicle.wire.MessageHistory;
import net.openhft.chronicle.wire.NoDocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.SourceContext;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.VanillaMessageHistory;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleChronicleQueueExcerpts {
    private static final boolean CHECK_INTERRUPTS = !Boolean.getBoolean("chronicle.queue.ignoreInterrupts");
    private static final Logger LOG = LoggerFactory.getLogger(SingleChronicleQueueExcerpts.class);
    private static final int MESSAGE_HISTORY_METHOD_ID = -1;
    private static StringBuilderPool SBP = new StringBuilderPool();

    private static void releaseWireResources(Wire wire) {
        StoreComponentReferenceHandler.queueForRelease(wire);
    }

    public static class StoreTailer
    implements ExcerptTailer,
    SourceContext,
    ExcerptContext {
        static final int INDEXING_LINEAR_SCAN_THRESHOLD = 70;
        @NotNull
        private final SingleChronicleQueue queue;
        private final StoreTailerContext context = new StoreTailerContext();
        private final ClosableResources closableResources;
        private final MoveToState moveToState = new MoveToState();
        long index;
        @Nullable
        WireStore store;
        int notPresentCounter = 0;
        private int cycle;
        private long timeForNextCycle = Long.MAX_VALUE;
        private TailerDirection direction = TailerDirection.FORWARD;
        private Wire wireForIndex;
        private boolean readAfterReplicaAcknowledged;
        @NotNull
        private TailerState state = TailerState.UNINITIALISED;
        private long indexAtCreation = Long.MIN_VALUE;
        private boolean readingDocumentFound = false;
        private long address = NoBytesStore.NO_PAGE;

        public StoreTailer(@NotNull SingleChronicleQueue queue) {
            this.queue = queue;
            this.setCycle(Integer.MIN_VALUE);
            this.index = 0L;
            queue.addCloseListener(this, StoreTailer::close);
            this.closableResources = new ClosableResources(queue);
            queue.ensureThatRollCycleDoesNotConflictWithExistingQueueFiles();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        public static MessageHistory readHistory(DocumentContext dc, MessageHistory history) {
            Wire wire = dc.wire();
            if (wire == null) {
                return null;
            }
            Object parent = wire.parent();
            wire.parent(null);
            try {
                Bytes bytes = wire.bytes();
                byte code = bytes.readByte(bytes.readPosition());
                history.reset();
                MessageHistory messageHistory = code == -70 ? StoreTailer.readHistoryFromBytes(wire, history) : StoreTailer.readHistoryFromWire(wire, history);
                return messageHistory;
            }
            finally {
                wire.parent(parent);
            }
        }

        private static MessageHistory readHistoryFromBytes(Wire wire, MessageHistory history) {
            Bytes bytes = wire.bytes();
            if (-1L != wire.readEventNumber()) {
                return null;
            }
            ((BytesMarshallable)history).readMarshallable((BytesIn)bytes);
            return history;
        }

        private static MessageHistory readHistoryFromWire(Wire wire, MessageHistory history) {
            StringBuilder sb = SBP.acquireStringBuilder();
            ValueIn valueIn = wire.read(sb);
            if (!"history".contentEquals(sb)) {
                return null;
            }
            valueIn.object((Object)history, MessageHistory.class);
            return history;
        }

        public boolean readDocument(@NotNull ReadMarshallable reader) {
            try (DocumentContext dc = this.readingDocument(false);){
                if (!dc.isPresent()) {
                    boolean bl = false;
                    return bl;
                }
                reader.readMarshallable((WireIn)dc.wire());
            }
            return true;
        }

        @Override
        @NotNull
        public DocumentContext readingDocument() {
            if (!(this.direction != TailerDirection.NONE || this.index != this.indexAtCreation && this.index != 0L || this.readingDocumentFound)) {
                return NoDocumentContext.INSTANCE;
            }
            return this.readingDocument(false);
        }

        private void close() {
            this.context.wire(null);
            Wire w0 = this.wireForIndex;
            if (w0 != null) {
                w0.bytes().release();
            }
            this.wireForIndex = null;
            if (this.store != null) {
                this.queue.release(this.store);
            }
            this.store = null;
        }

        @Override
        public Wire wire() {
            return this.context.wire();
        }

        @Override
        public Wire wireForIndex() {
            return this.wireForIndex;
        }

        @Override
        public long timeoutMS() {
            return this.queue.timeoutMS;
        }

        @Override
        public int sourceId() {
            return this.queue.sourceId;
        }

        @NotNull
        public String toString() {
            return "StoreTailer{index sequence=" + this.queue.rollCycle().toSequenceNumber(this.index) + ", index cycle=" + this.queue.rollCycle().toCycle(this.index) + ", store=" + this.store + ", queue=" + this.queue + '}';
        }

        @Override
        @NotNull
        public DocumentContext readingDocument(boolean includeMetaData) {
            Jvm.optionalSafepoint();
            if (this.queue.isClosed.get()) {
                throw new IllegalStateException("Queue is closed");
            }
            try {
                Jvm.optionalSafepoint();
                boolean next = false;
                boolean tryAgain = true;
                if (this.state == TailerState.FOUND_CYCLE) {
                    try {
                        Jvm.optionalSafepoint();
                        next = this.inACycle(includeMetaData);
                        Jvm.optionalSafepoint();
                        tryAgain = false;
                    }
                    catch (EOFException eof) {
                        this.state = TailerState.END_OF_CYCLE;
                    }
                }
                Jvm.optionalSafepoint();
                if (tryAgain) {
                    next = this.next0(includeMetaData);
                }
                Jvm.optionalSafepoint();
                if (this.context.present(next)) {
                    Bytes bytes = this.context.wire().bytes();
                    this.context.setStart(bytes.readPosition() - 4L);
                    this.readingDocumentFound = true;
                    this.address = bytes.addressForRead(bytes.readPosition(), 4);
                    Jvm.optionalSafepoint();
                    return this.context;
                }
                Jvm.optionalSafepoint();
                RollCycle rollCycle = this.queue.rollCycle();
                if (this.state == TailerState.CYCLE_NOT_FOUND && this.direction == TailerDirection.FORWARD) {
                    int firstCycle = this.queue.firstCycle();
                    if (rollCycle.toCycle(this.index) < firstCycle) {
                        this.toStart();
                    }
                } else if (!next && this.state == TailerState.CYCLE_NOT_FOUND && this.cycle != this.queue.cycle()) {
                    this.state = TailerState.END_OF_CYCLE;
                }
                if (this.context.wire() == null) {
                    this.address = NoBytesStore.NO_PAGE;
                } else {
                    Bytes bytes = this.context.wire().bytes();
                    this.address = bytes.addressForRead(bytes.readPosition(), 4);
                }
            }
            catch (StreamCorruptedException e) {
                throw new IllegalStateException(e);
            }
            catch (UnrecoverableTimeoutException e) {
            }
            catch (DecoratedBufferUnderflowException e) {
                if (this.queue.isReadOnly()) {
                    Jvm.warn().on(StoreTailer.class, "Tried to read past the end of a read-only view. Underlying data store may have grown since this tailer was created.", (Throwable)e);
                }
                throw e;
            }
            return NoDocumentContext.INSTANCE;
        }

        @Override
        public boolean peekDocument() {
            return UnsafeMemory.UNSAFE.getIntVolatile(null, this.address) > 0;
        }

        private boolean next0(boolean includeMetaData) throws UnrecoverableTimeoutException, StreamCorruptedException {
            block9: for (int i = 0; i < 1000; ++i) {
                switch (this.state) {
                    case UNINITIALISED: {
                        long firstIndex = this.queue.firstIndex();
                        if (firstIndex == Long.MAX_VALUE) {
                            return false;
                        }
                        if (this.moveToIndexInternal(firstIndex)) continue block9;
                        return false;
                    }
                    case FOUND_CYCLE: {
                        try {
                            return this.inACycle(includeMetaData);
                        }
                        catch (EOFException eof) {
                            this.state = TailerState.END_OF_CYCLE;
                            continue block9;
                        }
                    }
                    case END_OF_CYCLE: {
                        if (this.endOfCycle()) continue block9;
                        return false;
                    }
                    case BEYOND_START_OF_CYCLE: {
                        if (this.beyondStartOfCycle()) continue block9;
                        return false;
                    }
                    case CYCLE_NOT_FOUND: {
                        if (this.nextCycleNotFound()) continue block9;
                        return false;
                    }
                    default: {
                        throw new AssertionError((Object)("state=" + (Object)((Object)this.state)));
                    }
                }
            }
            throw new IllegalStateException("Unable to progress to the next cycle, state=" + (Object)((Object)this.state));
        }

        private boolean endOfCycle() {
            long oldIndex = this.index;
            int currentCycle = this.queue.rollCycle().toCycle(oldIndex);
            long nextIndex = this.nextIndexWithNextAvailableCycle(currentCycle);
            if (nextIndex != Long.MIN_VALUE) {
                return this.nextEndOfCycle(nextIndex);
            }
            this.state = TailerState.END_OF_CYCLE;
            return false;
        }

        private boolean beyondStartOfCycle() throws StreamCorruptedException {
            if (this.direction == TailerDirection.FORWARD) {
                this.state = TailerState.UNINITIALISED;
                return true;
            }
            if (this.direction == TailerDirection.BACKWARD) {
                return this.beyondStartOfCycleBackward();
            }
            throw new AssertionError((Object)("direction not set, direction=" + (Object)((Object)this.direction)));
        }

        private boolean nextEndOfCycle(long nextIndex) {
            if (this.moveToIndexInternal(nextIndex)) {
                this.state = TailerState.FOUND_CYCLE;
                return true;
            }
            if (this.state == TailerState.END_OF_CYCLE) {
                return true;
            }
            if (this.cycle < this.queue.lastCycle()) {
                this.state = TailerState.END_OF_CYCLE;
                return true;
            }
            int nextCycle = this.queue.rollCycle().toCycle(nextIndex);
            this.cycle(nextCycle);
            this.state = TailerState.CYCLE_NOT_FOUND;
            return false;
        }

        private boolean beyondStartOfCycleBackward() throws StreamCorruptedException {
            boolean foundCycle = this.cycle(this.queue.rollCycle().toCycle(this.index));
            if (foundCycle) {
                long lastSequenceNumberInThisCycle = this.store().sequenceForPosition(this, Long.MAX_VALUE, false);
                long nextIndex = this.queue.rollCycle().toIndex(this.cycle, lastSequenceNumberInThisCycle);
                this.moveToIndexInternal(nextIndex);
                this.state = TailerState.FOUND_CYCLE;
                return true;
            }
            int cycle = this.queue.rollCycle().toCycle(this.index);
            long nextIndex = this.nextIndexWithNextAvailableCycle(cycle);
            if (nextIndex != Long.MIN_VALUE) {
                this.moveToIndexInternal(nextIndex);
                this.state = TailerState.FOUND_CYCLE;
                return true;
            }
            this.state = TailerState.BEYOND_START_OF_CYCLE;
            return false;
        }

        private boolean nextCycleNotFound() {
            if (this.index == Long.MIN_VALUE) {
                if (this.store != null) {
                    this.queue.release(this.store);
                }
                this.store = null;
                this.closableResources.storeReference = null;
                return false;
            }
            if (this.moveToIndexInternal(this.index)) {
                this.state = TailerState.FOUND_CYCLE;
                return true;
            }
            return false;
        }

        private boolean inACycle(boolean includeMetaData) throws EOFException {
            Jvm.optionalSafepoint();
            Wire wire = this.wire();
            Bytes bytes = wire.bytes();
            bytes.readLimit(bytes.capacity());
            Jvm.optionalSafepoint();
            if (this.readAfterReplicaAcknowledged && this.inACycleCheckRep()) {
                return false;
            }
            Jvm.optionalSafepoint();
            if (this.direction != TailerDirection.FORWARD && this.inACycleNotForward()) {
                return false;
            }
            Jvm.optionalSafepoint();
            switch (wire.readDataHeader(includeMetaData)) {
                case NONE: {
                    Jvm.optionalSafepoint();
                    return false;
                }
                case META_DATA: {
                    Jvm.optionalSafepoint();
                    this.context.metaData(true);
                    break;
                }
                case DATA: {
                    Jvm.optionalSafepoint();
                    this.context.metaData(false);
                }
            }
            Jvm.optionalSafepoint();
            this.inACycleFound(bytes);
            Jvm.optionalSafepoint();
            return true;
        }

        private boolean inACycleCheckRep() {
            long lastSequenceAck = this.store().lastAcknowledgedIndexReplicated();
            long seq = this.queue.rollCycle().toSequenceNumber(this.index);
            return seq > lastSequenceAck;
        }

        private boolean inACycleNotForward() {
            Jvm.optionalSafepoint();
            if (!this.moveToIndexInternal(this.index)) {
                try {
                    Jvm.optionalSafepoint();
                    if (!this.moveToIndexInternal(this.index - 1L)) {
                        Jvm.optionalSafepoint();
                        return true;
                    }
                }
                catch (RuntimeException e) {
                    Jvm.optionalSafepoint();
                    return true;
                }
            }
            Jvm.optionalSafepoint();
            return false;
        }

        private void inACycleFound(Bytes<?> bytes) {
            this.context.closeReadLimit(bytes.capacity());
            this.wire().readAndSetLength(bytes.readPosition());
            long end = bytes.readLimit();
            this.context.closeReadPosition(end);
            Jvm.optionalSafepoint();
        }

        private long nextIndexWithNextAvailableCycle(int cycle) {
            long nextIndex;
            assert (cycle != Integer.MIN_VALUE) : "cycle == Integer.MIN_VALUE";
            if (cycle > this.queue.lastCycle() || this.direction == TailerDirection.NONE) {
                return Long.MIN_VALUE;
            }
            int nextCycle = cycle + this.direction.add();
            boolean found = this.cycle(nextCycle);
            if (found) {
                nextIndex = this.nextIndexWithinFoundCycle(nextCycle);
            } else {
                try {
                    int nextCycle0 = this.queue.nextCycle(this.cycle, this.direction);
                    if (nextCycle0 == -1) {
                        return Long.MIN_VALUE;
                    }
                    nextIndex = this.nextIndexWithinFoundCycle(nextCycle0);
                }
                catch (ParseException e) {
                    throw new IllegalStateException(e);
                }
            }
            if (LOG.isDebugEnabled()) {
                int nextIndexCycle = this.queue.rollCycle().toCycle(nextIndex);
                if (nextIndex != Long.MIN_VALUE && nextIndexCycle - 1 != cycle) {
                    LOG.debug("Rolled " + (nextIndexCycle - cycle) + " times to find the next cycle file. This can occur if your appenders have not written anything for a while, leaving the cycle files with a gap.");
                }
            }
            return nextIndex;
        }

        private long nextIndexWithinFoundCycle(int nextCycle) {
            this.state = TailerState.FOUND_CYCLE;
            if (this.direction == TailerDirection.FORWARD) {
                return this.queue.rollCycle().toIndex(nextCycle, 0L);
            }
            if (this.direction == TailerDirection.BACKWARD) {
                try {
                    long lastSequenceNumber0 = this.store().lastSequenceNumber(this);
                    return this.queue.rollCycle().toIndex(nextCycle, lastSequenceNumber0);
                }
                catch (Exception e) {
                    throw new AssertionError((Object)e);
                }
            }
            throw new IllegalStateException("direction=" + (Object)((Object)this.direction));
        }

        @Override
        public long index() {
            return this.index;
        }

        @Override
        public int cycle() {
            return this.cycle;
        }

        @Override
        public boolean moveToIndex(long index) {
            if (this.moveToState.canReuseLastIndexMove(index, this.state, this.direction, this.queue, this.wire())) {
                return true;
            }
            if (this.moveToState.indexIsCloseToAndAheadOfLastIndexMove(index, this.state, this.direction, this.queue)) {
                boolean found;
                long knownIndex = this.moveToState.lastMovedToIndex;
                boolean bl = found = this.store.linearScanTo(index, knownIndex, this, this.moveToState.readPositionAtLastMove) == ScanResult.FOUND;
                if (found) {
                    this.index(index);
                    this.moveToState.onSuccessfulScan(index, this.direction, this.wire().bytes().readPosition());
                }
                return found;
            }
            return this.moveToIndexInternal(index);
        }

        ScanResult moveToIndexResult(long index) {
            int cycle = this.queue.rollCycle().toCycle(index);
            long sequenceNumber = this.queue.rollCycle().toSequenceNumber(index);
            if (LOG.isTraceEnabled()) {
                Jvm.debug().on(this.getClass(), "moveToIndex: " + Long.toHexString(cycle) + " " + Long.toHexString(sequenceNumber));
            }
            if (!(cycle == this.cycle && this.state == TailerState.FOUND_CYCLE || this.cycle(cycle))) {
                return ScanResult.NOT_REACHED;
            }
            this.index(index);
            ScanResult scanResult = this.store().moveToIndexForRead(this, sequenceNumber);
            Bytes bytes = this.wire().bytes();
            if (scanResult == ScanResult.FOUND) {
                this.state = TailerState.FOUND_CYCLE;
                this.moveToState.onSuccessfulLookup(index, this.direction, bytes.readPosition());
                return scanResult;
            }
            if (scanResult == ScanResult.END_OF_FILE) {
                this.state = TailerState.END_OF_CYCLE;
                return scanResult;
            }
            if (scanResult == ScanResult.NOT_FOUND && this.cycle < this.queue.lastCycle) {
                this.state = TailerState.END_OF_CYCLE;
                return ScanResult.END_OF_FILE;
            }
            bytes.readLimit(bytes.readPosition());
            return scanResult;
        }

        @Override
        @NotNull
        public final ExcerptTailer toStart() {
            assert (this.direction != TailerDirection.BACKWARD);
            int firstCycle = this.queue.firstCycle();
            if (firstCycle == Integer.MAX_VALUE) {
                this.state = TailerState.UNINITIALISED;
                return this;
            }
            if (firstCycle != this.cycle) {
                boolean found = this.cycle(firstCycle);
                assert (found || this.store == null);
                if (found) {
                    this.state = TailerState.FOUND_CYCLE;
                }
            }
            this.index(this.queue.rollCycle().toIndex(this.cycle, 0L));
            this.state = TailerState.FOUND_CYCLE;
            if (this.wire() != null) {
                this.wire().bytes().readPosition(0L);
            }
            return this;
        }

        private boolean moveToIndexInternal(long index) {
            this.moveToState.indexMoveCount++;
            Jvm.optionalSafepoint();
            ScanResult scanResult = this.moveToIndexResult(index);
            Jvm.optionalSafepoint();
            return scanResult == ScanResult.FOUND;
        }

        private long approximateLastIndex() {
            RollCycle rollCycle = this.queue.rollCycle();
            int lastCycle = this.queue.lastCycle();
            try {
                long sequenceNumber;
                if (lastCycle == Integer.MIN_VALUE) {
                    return Long.MIN_VALUE;
                }
                WireStore wireStore = this.queue.storeForCycle(lastCycle, this.queue.epoch(), false);
                this.setCycle(lastCycle);
                if (wireStore == null) {
                    throw new IllegalStateException("Store not found for cycle " + Long.toHexString(lastCycle) + ". Probably the files were removed?");
                }
                if (this.store != null) {
                    this.queue.release(this.store);
                }
                if (this.store != wireStore) {
                    this.store = wireStore;
                    this.closableResources.storeReference = wireStore;
                    this.resetWires();
                }
                if ((sequenceNumber = this.store.lastSequenceNumber(this)) == -1L) {
                    return rollCycle.toIndex(lastCycle, 0L);
                }
                return rollCycle.toIndex(lastCycle, sequenceNumber);
            }
            catch (StreamCorruptedException | UnrecoverableTimeoutException e) {
                throw new IllegalStateException(e);
            }
        }

        private boolean headerNumberCheck(@NotNull AbstractWire wire) {
            wire.headNumberCheck((actual, position) -> {
                try {
                    long expecting = this.store.sequenceForPosition(this, position, false);
                    if (actual == expecting) {
                        return true;
                    }
                    LOG.error("", (Throwable)((Object)new AssertionError((Object)("header number check failed expecting=" + expecting + "  !=  actual=" + actual))));
                    return false;
                }
                catch (Exception e) {
                    LOG.error("", (Throwable)e);
                    return false;
                }
            });
            return true;
        }

        private void resetWires() {
            WireType wireType = this.queue.wireType();
            AbstractWire wire = (AbstractWire)this.readAnywhere((Wire)wireType.apply((Object)this.store().bytes()));
            assert (this.headerNumberCheck(wire));
            this.context.wire(wire);
            wire.parent((Object)this);
            Wire wireForIndexOld = this.wireForIndex;
            this.wireForIndex = this.readAnywhere((Wire)wireType.apply((Object)this.store().bytes()));
            this.closableResources.wireForIndexReference = this.wireForIndex.bytes();
            this.closableResources.wireReference = wire.bytes();
            assert (this.headerNumberCheck((AbstractWire)this.wireForIndex));
            assert (wire != wireForIndexOld);
            if (wireForIndexOld != null) {
                SingleChronicleQueueExcerpts.releaseWireResources(wireForIndexOld);
            }
        }

        @NotNull
        private Wire readAnywhere(@NotNull Wire wire) {
            Bytes bytes = wire.bytes();
            bytes.readLimit(bytes.capacity());
            return wire;
        }

        @Override
        @NotNull
        public ExcerptTailer toEnd() {
            if (this.direction.equals((Object)TailerDirection.BACKWARD)) {
                return this.originalToEnd();
            }
            return this.optimizedToEnd();
        }

        @NotNull
        private ExcerptTailer optimizedToEnd() {
            RollCycle rollCycle = this.queue.rollCycle();
            int lastCycle = this.queue.lastCycle();
            try {
                long sequenceNumber;
                if (lastCycle == Integer.MIN_VALUE) {
                    if (this.state() == TailerState.CYCLE_NOT_FOUND) {
                        this.state = TailerState.UNINITIALISED;
                    }
                    return this;
                }
                WireStore wireStore = this.queue.storeForCycle(lastCycle, this.queue.epoch(), false);
                this.setCycle(lastCycle);
                if (wireStore == null) {
                    throw new IllegalStateException("Store not found for cycle " + Long.toHexString(lastCycle) + ". Probably the files were removed?");
                }
                if (this.store != null) {
                    this.queue.release(this.store);
                }
                if (this.store != wireStore) {
                    this.store = wireStore;
                    this.closableResources.storeReference = wireStore;
                    this.resetWires();
                }
                if ((sequenceNumber = this.store.moveToEndForRead(this.wire())) == -1L) {
                    return this.originalToEnd();
                }
                this.state = Wires.isEndOfFile((int)this.wire().bytes().readVolatileInt(this.wire().bytes().readPosition())) ? TailerState.END_OF_CYCLE : TailerState.FOUND_CYCLE;
                this.index = rollCycle.toIndex(lastCycle, sequenceNumber);
            }
            catch (UnrecoverableTimeoutException e) {
                throw new IllegalStateException(e);
            }
            return this;
        }

        @NotNull
        public ExcerptTailer originalToEnd() {
            long index = this.approximateLastIndex();
            if (index == Long.MIN_VALUE) {
                if (this.state() == TailerState.CYCLE_NOT_FOUND) {
                    this.state = TailerState.UNINITIALISED;
                }
                return this;
            }
            ScanResult scanResult = this.moveToIndexResult(index);
            block0 : switch (scanResult) {
                case NOT_FOUND: {
                    if (this.moveToIndexResult(index - 1L) != ScanResult.FOUND) break;
                    this.state = TailerState.FOUND_CYCLE;
                    break;
                }
                case FOUND: {
                    if (this.direction != TailerDirection.FORWARD) break;
                    ScanResult result = this.moveToIndexResult(++index);
                    switch (result) {
                        case FOUND: {
                            this.state = TailerState.FOUND_CYCLE;
                            break block0;
                        }
                        case NOT_REACHED: {
                            throw new IllegalStateException("NOT_REACHED after FOUND");
                        }
                        case NOT_FOUND: {
                            this.state = TailerState.FOUND_CYCLE;
                            break block0;
                        }
                        case END_OF_FILE: {
                            this.state = TailerState.END_OF_CYCLE;
                            break block0;
                        }
                    }
                    throw new IllegalStateException("Unknown ScanResult: " + (Object)((Object)result));
                }
                case NOT_REACHED: {
                    this.approximateLastIndex();
                    throw new IllegalStateException("NOT_REACHED index: " + Long.toHexString(index));
                }
                case END_OF_FILE: {
                    this.state = TailerState.END_OF_CYCLE;
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown ScanResult: " + (Object)((Object)scanResult));
                }
            }
            return this;
        }

        @Override
        public TailerDirection direction() {
            return this.direction;
        }

        @Override
        @NotNull
        public ExcerptTailer direction(TailerDirection direction) {
            TailerDirection oldDirection = this.direction();
            this.direction = direction;
            if (oldDirection == TailerDirection.BACKWARD && direction == TailerDirection.FORWARD) {
                this.moveToIndexInternal(this.index);
            }
            return this;
        }

        @Override
        @NotNull
        public RollingChronicleQueue queue() {
            return this.queue;
        }

        @Override
        public Runnable getCloserJob() {
            return () -> this.closableResources.releaseResources();
        }

        public void releaseResources() {
            this.queue.removeCloseListener(this);
            this.getCloserJob().run();
        }

        private void incrementIndex() {
            RollCycle rollCycle = this.queue.rollCycle();
            long seq = rollCycle.toSequenceNumber(this.index);
            int cycle = rollCycle.toCycle(this.index);
            seq += (long)this.direction.add();
            switch (this.direction) {
                case NONE: {
                    break;
                }
                case FORWARD: {
                    if (rollCycle.toSequenceNumber(seq) >= seq) break;
                    this.cycle(cycle + 1);
                    LOG.warn("we have run out of sequence numbers, so will start to write to the next .cq4 file, the new cycle=" + cycle);
                    seq = 0L;
                    break;
                }
                case BACKWARD: {
                    if (seq >= 0L) break;
                    this.windBackCycle(cycle);
                    return;
                }
            }
            this.index = rollCycle.toIndex(cycle, seq);
        }

        private void windBackCycle(int cycle) {
            if (this.tryWindBack(cycle - 1)) {
                return;
            }
            --cycle;
            long first = this.queue.firstCycle();
            while ((long)cycle >= first) {
                if (this.tryWindBack(cycle)) {
                    return;
                }
                --cycle;
            }
            this.index(this.queue.rollCycle().toIndex(cycle, -1L));
            this.state = TailerState.BEYOND_START_OF_CYCLE;
        }

        private boolean tryWindBack(int cycle) {
            long count = this.queue.exceptsPerCycle(cycle);
            if (count <= 0L) {
                return false;
            }
            RollCycle rollCycle = this.queue.rollCycle();
            this.moveToIndexInternal(rollCycle.toIndex(cycle, count - 1L));
            this.state = TailerState.FOUND_CYCLE;
            return true;
        }

        void index(long index) {
            this.index = index;
            if (this.indexAtCreation == Long.MIN_VALUE) {
                this.indexAtCreation = index;
            }
            this.moveToState.reset();
        }

        private boolean cycle(int cycle) {
            if (this.cycle == cycle && this.state == TailerState.FOUND_CYCLE) {
                return true;
            }
            WireStore nextStore = this.queue.storeForCycle(cycle, this.queue.epoch(), false);
            if (nextStore == null && this.store == null) {
                return false;
            }
            if (nextStore == null) {
                this.state = this.direction == TailerDirection.BACKWARD ? TailerState.BEYOND_START_OF_CYCLE : TailerState.CYCLE_NOT_FOUND;
                return false;
            }
            if (this.store != null) {
                this.queue.release(this.store);
            }
            if (nextStore == this.store) {
                return true;
            }
            this.context.wire(null);
            this.store = nextStore;
            this.closableResources.storeReference = nextStore;
            this.state = TailerState.FOUND_CYCLE;
            this.setCycle(cycle);
            this.resetWires();
            Wire wire = this.wire();
            wire.parent((Object)this);
            wire.pauser((Pauser)this.queue.pauserSupplier.get());
            return true;
        }

        void release() {
            if (this.store != null) {
                this.queue.release(this.store);
                this.store = null;
                this.closableResources.storeReference = null;
            }
            this.state = TailerState.UNINITIALISED;
        }

        @Override
        public void readAfterReplicaAcknowledged(boolean readAfterReplicaAcknowledged) {
            this.readAfterReplicaAcknowledged = readAfterReplicaAcknowledged;
        }

        @Override
        public boolean readAfterReplicaAcknowledged() {
            return this.readAfterReplicaAcknowledged;
        }

        @Override
        @NotNull
        public TailerState state() {
            return this.state;
        }

        @Override
        @NotNull
        public ExcerptTailer afterLastWritten(@NotNull ChronicleQueue queue) {
            if (queue == this.queue) {
                throw new IllegalArgumentException("You must pass the queue written to, not the queue read");
            }
            ExcerptTailer tailer = queue.createTailer().direction(TailerDirection.BACKWARD).toEnd();
            VanillaMessageHistory messageHistory = new VanillaMessageHistory();
            while (true) {
                DocumentContext context = tailer.readingDocument();
                Throwable throwable = null;
                try {
                    int i;
                    if (!context.isData()) {
                        this.toStart();
                        StoreTailer storeTailer = this;
                        return storeTailer;
                    }
                    MessageHistory veh = StoreTailer.readHistory(context, (MessageHistory)messageHistory);
                    if (veh == null || (i = veh.sources() - 1) < 0 || veh.sourceId(i) != this.sourceId()) continue;
                    long sourceIndex = veh.sourceIndex(i);
                    if (!this.moveToIndexInternal(sourceIndex)) {
                        String errorMessage = String.format("Unable to move to sourceIndex %s in queue %s", Long.toHexString(sourceIndex), this.queue.fileAbsolutePath());
                        throw new IORuntimeException(errorMessage + this.extraInfo(tailer, messageHistory));
                    }
                    try (DocumentContext content = this.readingDocument();){
                        if (!content.isPresent()) {
                            String errorMessage = String.format("No readable document found at sourceIndex %s in queue %s", Long.toHexString(sourceIndex + 1L), this.queue.fileAbsolutePath());
                            throw new IORuntimeException(errorMessage + this.extraInfo(tailer, messageHistory));
                        }
                    }
                    StoreTailer storeTailer = this;
                    return storeTailer;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (context == null) continue;
                    if (throwable != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    context.close();
                    continue;
                }
                break;
            }
        }

        private String extraInfo(@NotNull ExcerptTailer tailer, @NotNull VanillaMessageHistory messageHistory) {
            return String.format(". That sourceIndex was determined fom the last entry written to queue %s (message index %s, message history %s). If source queue is replicated then sourceIndex may not have been replicated yet", tailer.queue().fileAbsolutePath(), Long.toHexString(tailer.index()), WireType.TEXT.asString((Object)messageHistory));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lastAcknowledgedIndexReplicated(long acknowledgeIndex) {
            RollCycle rollCycle;
            int cycle0;
            if (Jvm.isDebugEnabled(this.getClass())) {
                Jvm.debug().on(this.getClass(), "received lastAcknowledgedIndexReplicated=" + Long.toHexString(acknowledgeIndex) + " ,file=" + this.queue().fileAbsolutePath());
            }
            if ((cycle0 = (rollCycle = this.queue.rollCycle()).toCycle(acknowledgeIndex)) == this.cycle()) {
                this.store.lastAcknowledgedIndexReplicated(acknowledgeIndex);
                return;
            }
            StoreTailer temp = this.queue.acquireTailer();
            try {
                if (!temp.cycle(cycle0)) {
                    Jvm.warn().on(this.getClass(), "Got an acknowledge index " + Long.toHexString(acknowledgeIndex) + " for a cycle which could not found");
                    return;
                }
                WireStore store = temp.store;
                if (store == null) {
                    Jvm.warn().on(this.getClass(), "Got an acknowledge index " + Long.toHexString(acknowledgeIndex) + " discarded.");
                    return;
                }
                store.lastAcknowledgedIndexReplicated(acknowledgeIndex);
            }
            finally {
                temp.release();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void lastIndexReplicated(long lastIndexReplicated) {
            RollCycle rollCycle;
            int cycle0;
            if (Jvm.isDebugEnabled(this.getClass())) {
                Jvm.debug().on(this.getClass(), "received lastIndexReplicated=" + Long.toHexString(lastIndexReplicated) + " ,file=" + this.queue().fileAbsolutePath());
            }
            if ((cycle0 = (rollCycle = this.queue.rollCycle()).toCycle(lastIndexReplicated)) == this.cycle()) {
                this.store().lastIndexReplicated(lastIndexReplicated);
                return;
            }
            StoreTailer temp = this.queue.acquireTailer();
            try {
                if (!temp.cycle(cycle0)) {
                    Jvm.warn().on(this.getClass(), "Got an acknowledge index " + Long.toHexString(lastIndexReplicated) + " for a cycle which could not found");
                    return;
                }
                if (temp.store == null) {
                    Jvm.warn().on(this.getClass(), "Got an acknowledge index " + Long.toHexString(lastIndexReplicated) + " discarded.");
                    return;
                }
                temp.store().lastIndexReplicated(lastIndexReplicated);
            }
            finally {
                temp.release();
            }
        }

        public long lastAcknowledgedIndexReplicated() {
            return ((StoreAppender)this.queue.acquireAppender()).store().lastAcknowledgedIndexReplicated();
        }

        public long lastIndexReplicated() {
            return ((StoreAppender)this.queue.acquireAppender()).store().lastIndexReplicated();
        }

        public void setCycle(int cycle) {
            this.cycle = cycle;
            this.timeForNextCycle = cycle == Integer.MIN_VALUE ? Long.MAX_VALUE : (long)(cycle + 1) * (long)this.queue.rollCycle().length() + this.queue.epoch();
        }

        int getIndexMoveCount() {
            return this.moveToState.indexMoveCount;
        }

        @Deprecated
        @NotNull
        WireStore store() {
            if (this.store == null) {
                this.setCycle(this.cycle());
            }
            return this.store;
        }

        class StoreTailerContext
        extends BinaryReadDocumentContext {
            boolean rollbackOnClose;

            StoreTailerContext() {
                super(null);
                this.rollbackOnClose = false;
            }

            public void rollbackOnClose() {
                this.rollbackOnClose = true;
            }

            public long index() {
                return StoreTailer.this.index();
            }

            public int sourceId() {
                return StoreTailer.this.sourceId();
            }

            public void close() {
                try {
                    if (this.rollbackOnClose) {
                        this.present = false;
                        if (this.start != -1L) {
                            ((Bytes)this.wire.bytes().readPosition(this.start)).readLimit(this.readLimit);
                        }
                        this.start = -1L;
                        return;
                    }
                    if (this.isPresent() && !this.isMetaData()) {
                        StoreTailer.this.incrementIndex();
                    }
                    super.close();
                }
                finally {
                    this.rollbackOnClose = false;
                }
            }

            boolean present(boolean present) {
                this.present = present;
                return this.present;
            }

            public void wire(@Nullable AbstractWire wire) {
                if (wire == this.wire) {
                    return;
                }
                AbstractWire oldWire = this.wire;
                this.wire = wire;
                if (oldWire != null) {
                    SingleChronicleQueueExcerpts.releaseWireResources((Wire)oldWire);
                }
            }
        }

        private static final class MoveToState {
            private long lastMovedToIndex = Long.MIN_VALUE;
            private TailerDirection directionAtLastMoveTo = TailerDirection.NONE;
            private long readPositionAtLastMove = Long.MIN_VALUE;
            private int indexMoveCount = 0;

            private MoveToState() {
            }

            void onSuccessfulLookup(long movedToIndex, TailerDirection direction, long readPosition) {
                this.lastMovedToIndex = movedToIndex;
                this.directionAtLastMoveTo = direction;
                this.readPositionAtLastMove = readPosition;
            }

            void onSuccessfulScan(long movedToIndex, TailerDirection direction, long readPosition) {
                this.lastMovedToIndex = movedToIndex;
                this.directionAtLastMoveTo = direction;
                this.readPositionAtLastMove = readPosition;
            }

            void reset() {
                this.lastMovedToIndex = Long.MIN_VALUE;
                this.directionAtLastMoveTo = TailerDirection.NONE;
                this.readPositionAtLastMove = Long.MIN_VALUE;
            }

            private boolean indexIsCloseToAndAheadOfLastIndexMove(long index, TailerState state, TailerDirection direction, SingleChronicleQueue queue) {
                return this.lastMovedToIndex != Long.MIN_VALUE && index - this.lastMovedToIndex < 70L && state == TailerState.FOUND_CYCLE && direction == this.directionAtLastMoveTo && queue.rollCycle().toCycle(index) == queue.rollCycle().toCycle(this.lastMovedToIndex) && index > this.lastMovedToIndex;
            }

            private boolean canReuseLastIndexMove(long index, TailerState state, TailerDirection direction, SingleChronicleQueue queue, Wire wire) {
                return (wire == null || wire.bytes().readPosition() == this.readPositionAtLastMove) && index == this.lastMovedToIndex && index != 0L && state == TailerState.FOUND_CYCLE && direction == this.directionAtLastMoveTo && queue.rollCycle().toCycle(index) == queue.rollCycle().toCycle(this.lastMovedToIndex);
            }
        }
    }

    private static final class ClosableResources {
        private final SingleChronicleQueue queue;
        private volatile Bytes wireReference = null;
        private volatile Bytes bufferWireReference = null;
        private volatile Bytes wireForIndexReference = null;
        private volatile CommonStore storeReference = null;

        ClosableResources(SingleChronicleQueue queue) {
            this.queue = queue;
        }

        private static void releaseIfNotNull(Bytes bytesReference) {
            if (bytesReference != null && bytesReference.refCount() > 0L) {
                bytesReference.release();
            }
        }

        private void releaseResources() {
            ClosableResources.releaseIfNotNull(this.wireForIndexReference);
            ClosableResources.releaseIfNotNull(this.wireReference);
            ClosableResources.releaseIfNotNull(this.bufferWireReference);
            if (this.storeReference != null && this.storeReference.refCount() > 0L) {
                this.queue.release(this.storeReference);
            }
        }
    }

    static class StoreAppender
    implements ExcerptAppender,
    ExcerptContext,
    InternalAppender {
        @NotNull
        private final SingleChronicleQueue queue;
        @NotNull
        private final WriteLock writeLock;
        @NotNull
        private final StoreAppenderContext context;
        private final ClosableResources closableResources;
        private final WireStorePool storePool;
        @Nullable
        WireStore store;
        private int cycle = Integer.MIN_VALUE;
        @Nullable
        private Wire wire;
        @Nullable
        private Wire bufferWire;
        @Nullable
        private Wire wireForIndex;
        private long position = 0L;
        private long lastIndex = Long.MIN_VALUE;
        private long lastPosition;
        private int lastCycle;
        @Nullable
        private Pretoucher pretoucher = null;
        private MarshallableOut.Padding padToCacheLines = MarshallableOut.Padding.SMART;

        StoreAppender(@NotNull SingleChronicleQueue queue, @NotNull WireStorePool storePool) {
            this.queue = queue;
            this.writeLock = queue.writeLock();
            queue.addCloseListener(this, StoreAppender::close);
            this.context = new StoreAppenderContext();
            this.storePool = storePool;
            this.closableResources = new ClosableResources(queue);
            queue.ensureThatRollCycleDoesNotConflictWithExistingQueueFiles();
        }

        @Deprecated
        @NotNull
        WireStore store() {
            if (this.store == null) {
                this.setCycle(this.cycle());
            }
            return this.store;
        }

        @Override
        @NotNull
        public MarshallableOut.Padding padToCacheAlignMode() {
            return this.padToCacheLines;
        }

        @Override
        public void padToCacheAlign(MarshallableOut.Padding padToCacheLines) {
            this.padToCacheLines = padToCacheLines;
        }

        public void writeBytes(@NotNull WriteBytesMarshallable marshallable) throws UnrecoverableTimeoutException {
            try (DocumentContext dc = this.writingDocument();){
                marshallable.writeMarshallable((BytesOut)dc.wire().bytes());
                if (this.padToCacheAlignMode() != MarshallableOut.Padding.ALWAYS) {
                    ((StoreAppenderContext)dc).padToCacheAlign = false;
                }
            }
        }

        public void writeText(@NotNull CharSequence text) throws UnrecoverableTimeoutException {
            try (DocumentContext dc = this.writingDocument();){
                dc.wire().bytes().append8bit(text);
                if (this.padToCacheAlignMode() != MarshallableOut.Padding.ALWAYS) {
                    ((StoreAppenderContext)dc).padToCacheAlign = false;
                }
            }
        }

        void close() {
            Wire w0 = this.wireForIndex;
            this.wireForIndex = null;
            if (w0 != null) {
                w0.bytes().release();
            }
            Wire w = this.wire;
            this.wire = null;
            if (w != null) {
                w.bytes().release();
            }
            if (this.pretoucher != null) {
                this.pretoucher.close();
            }
            if (this.store != null) {
                this.storePool.release(this.store);
            }
            if (this.bufferWire != null) {
                this.bufferWire.bytes().release();
                this.bufferWire = null;
            }
            this.store = null;
            this.storePool.close();
        }

        @Override
        public void pretouch() {
            if (this.queue.isClosed()) {
                throw new RuntimeException("Queue Closed");
            }
            try {
                if (this.pretoucher == null) {
                    this.pretoucher = new Pretoucher(this.queue());
                }
                this.pretoucher.execute();
            }
            catch (Throwable e) {
                Jvm.warn().on(this.getClass(), e);
                Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        @Nullable
        public Wire wire() {
            return this.wire;
        }

        @Override
        @Nullable
        public Wire wireForIndex() {
            return this.wireForIndex;
        }

        @Override
        public long timeoutMS() {
            return this.queue.timeoutMS;
        }

        void lastIndex(long index) {
            this.lastIndex = index;
        }

        public boolean recordHistory() {
            return this.sourceId() != 0;
        }

        void setCycle(int cycle) {
            if (cycle != this.cycle) {
                this.setCycle2(cycle, true);
            }
        }

        private void setCycle2(int cycle, boolean createIfAbsent) {
            if (cycle < 0) {
                throw new IllegalArgumentException("You can not have a cycle that starts before Epoch. cycle=" + cycle);
            }
            SingleChronicleQueue queue = this.queue;
            WireStore store = this.store;
            if (store != null) {
                this.storePool.release(store);
            }
            this.store = this.storePool.acquire(cycle, queue.epoch(), createIfAbsent);
            this.closableResources.storeReference = this.store;
            this.resetWires(queue);
            this.cycle = cycle;
            assert (this.wire.startUse());
            this.wire.parent((Object)this);
            this.wire.pauser((Pauser)queue.pauserSupplier.get());
            this.resetPosition();
            queue.onRoll(cycle);
        }

        private void resetWires(@NotNull SingleChronicleQueue queue) {
            WireType wireType = queue.wireType();
            Wire oldw = this.wire;
            this.wire = (Wire)wireType.apply((Object)this.store.bytes());
            this.closableResources.wireReference = this.wire.bytes();
            assert (this.wire != oldw);
            if (oldw != null) {
                SingleChronicleQueueExcerpts.releaseWireResources(oldw);
            }
            Wire old = this.wireForIndex;
            this.wireForIndex = (Wire)wireType.apply((Object)this.store.bytes());
            this.closableResources.wireForIndexReference = this.wireForIndex.bytes();
            assert (this.wire != old);
            if (old != null) {
                SingleChronicleQueueExcerpts.releaseWireResources(old);
            }
        }

        private void resetPosition() throws UnrecoverableTimeoutException {
            try {
                if (this.store == null || this.wire == null) {
                    return;
                }
                this.position(this.store.writePosition());
                assert (this.position == 0L || Wires.isReadyData((int)this.wire.bytes().readVolatileInt(this.position)));
                long headerNumber = this.store.lastSequenceNumber(this);
                this.wire.headerNumber(this.queue.rollCycle().toIndex(this.cycle, headerNumber + 1L) - 1L);
                assert (this.wire.headerNumber() != -1L || this.checkIndex(this.wire.headerNumber(), this.position));
            }
            catch (StreamCorruptedException | BufferOverflowException e) {
                throw new AssertionError((Object)e);
            }
            assert (this.checkWritePositionHeaderNumber());
        }

        @NotNull
        public DocumentContext writingDocument(boolean metaData) throws UnrecoverableTimeoutException {
            if (this.queue.isClosed.get()) {
                throw new IllegalStateException("Queue is closed");
            }
            this.writeLock.lock();
            assert (this.checkWritePositionHeaderNumber());
            int cycle = this.queue.cycle();
            if (this.wire == null) {
                int lastCycle = this.queue.lastCycle();
                if (lastCycle == Integer.MIN_VALUE) {
                    lastCycle = cycle;
                }
                this.setCycle2(lastCycle, true);
            }
            if (this.cycle != cycle) {
                this.rollCycleTo(cycle);
            }
            int safeLength = (int)this.queue.overlapSize();
            this.openContext(metaData, safeLength);
            return this.context;
        }

        private long writeHeader(@NotNull Wire wire, int safeLength) {
            Bytes bytes = wire.bytes();
            long pos = this.position;
            long lastPos = this.store.writePosition();
            if (pos < lastPos) {
                try {
                    wire.headerNumber(this.queue.rollCycle().toIndex(this.cycle, this.store.lastSequenceNumber(this)));
                }
                catch (StreamCorruptedException ex) {
                    Jvm.warn().on(this.getClass(), "Couldn't find last sequence", (Throwable)ex);
                }
            }
            int header = bytes.readVolatileInt(lastPos);
            assert (header != 0);
            lastPos += (long)(Wires.lengthOf((int)bytes.readVolatileInt(lastPos)) + 4);
            bytes.writePosition(lastPos);
            return wire.enterHeader(safeLength);
        }

        private void openContext(boolean metaData, int safeLength) {
            assert (this.wire != null);
            this.position(this.writeHeader(this.wire, safeLength));
            this.context.isClosed = false;
            this.context.rollbackOnClose = false;
            this.context.wire = this.wire;
            this.context.padToCacheAlign = this.padToCacheAlignMode() != MarshallableOut.Padding.NEVER;
            this.context.metaData(metaData);
        }

        boolean checkWritePositionHeaderNumber() {
            if (this.wire == null || this.wire.headerNumber() == Long.MIN_VALUE) {
                return true;
            }
            try {
                long pos = this.position;
                long seq1 = this.queue.rollCycle().toSequenceNumber(this.wire.headerNumber() + 1L) - 1L;
                long seq2 = this.store.sequenceForPosition(this, pos, true);
                if (seq1 != seq2) {
                    String message = "~~~~~~~~~~~~~~ thread: " + Thread.currentThread().getName() + " pos: " + pos + " header: " + this.wire.headerNumber() + " seq1: " + seq1 + " seq2: " + seq2;
                    ((Throwable)((Object)new AssertionError((Object)message))).printStackTrace();
                    throw new AssertionError((Object)message);
                }
            }
            catch (Exception e) {
                Jvm.fatal().on(this.getClass(), (Throwable)e);
                throw Jvm.rethrow((Throwable)e);
            }
            return true;
        }

        @Override
        @NotNull
        public DocumentContext writingDocument(long index) {
            this.writeLock.lock();
            this.context.isClosed = false;
            this.context.wire = this.acquireBufferWire();
            this.context.wire.headerNumber(index);
            this.context.isClosed = false;
            return this.context;
        }

        @Override
        public int sourceId() {
            return this.queue.sourceId;
        }

        @Override
        public void writeBytes(@NotNull BytesStore bytes) throws UnrecoverableTimeoutException {
            this.writeLock.lock();
            try {
                int cycle = this.queue.cycle();
                if (this.cycle != cycle || this.wire == null) {
                    this.rollCycleTo(cycle);
                }
                this.position(this.writeHeader(this.wire, (int)this.queue.overlapSize()));
                assert (((AbstractWire)this.wire).isInsideHeader());
                this.beforeAppend(this.wire, this.wire.headerNumber() + 1L);
                this.wire.bytes().write(bytes);
                this.wire.updateHeader(this.position, false, 0);
                this.lastIndex(this.wire.headerNumber());
                this.lastPosition = this.position;
                this.lastCycle = cycle;
                this.store.writePosition(this.position);
                this.writeIndexForPosition(this.lastIndex, this.position);
            }
            catch (StreamCorruptedException e) {
                throw new AssertionError((Object)e);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        @NotNull
        Wire acquireBufferWire() {
            if (this.bufferWire == null) {
                this.bufferWire = (Wire)this.queue.wireType().apply((Object)Bytes.elasticByteBuffer());
                this.closableResources.bufferWireReference = this.bufferWire.bytes();
            } else {
                this.bufferWire.clear();
            }
            return this.bufferWire;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void writeBytes(long index, @NotNull BytesStore bytes) {
            if (this.queue.isClosed.get()) {
                throw new IllegalStateException("Queue is closed");
            }
            this.writeLock.lock();
            try {
                boolean rollbackDontClose;
                int cycle = this.queue.rollCycle().toCycle(index);
                if (this.wire == null) {
                    this.setCycle2(cycle, true);
                } else if (this.cycle < cycle) {
                    this.rollCycleTo(cycle);
                }
                boolean bl = rollbackDontClose = index != this.wire.headerNumber() + 1L;
                if (rollbackDontClose) {
                    if (index > this.wire.headerNumber() + 1L) {
                        throw new IllegalStateException("Unable to move to index " + Long.toHexString(index) + " beyond the end of the queue");
                    }
                    Jvm.warn().on(this.getClass(), "Trying to overwrite index " + Long.toHexString(index) + " which is before the end of the queue");
                    return;
                }
                this.writeBytesInternal(index, bytes);
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeBytesInternal(long index, @NotNull BytesStore bytes) {
            assert (this.writeLock.locked());
            try {
                if (this.wire == null) {
                    int cycle = this.queue.rollCycle().toCycle(index);
                    this.setCycle2(cycle, true);
                }
                int safeLength = (int)this.queue.overlapSize();
                this.openContext(false, safeLength);
                try {
                    this.context.wire().bytes().write(bytes);
                }
                finally {
                    this.context.close(false);
                }
            }
            finally {
                this.context.isClosed = true;
            }
        }

        private void position(long position) {
            if (position > this.store.writePosition() + this.queue.blockSize()) {
                throw new IllegalArgumentException("pos: " + position + ", store.writePosition()=" + this.store.writePosition() + " queue.blockSize()=" + this.queue.blockSize());
            }
            this.position = position;
        }

        @Override
        public long lastIndexAppended() {
            if (this.lastIndex != Long.MIN_VALUE) {
                return this.lastIndex;
            }
            if (this.lastPosition == Long.MIN_VALUE || this.wire == null) {
                throw new IllegalStateException("nothing has been appended, so there is no last index");
            }
            try {
                long sequenceNumber = this.store.sequenceForPosition(this, this.lastPosition, true);
                long index = this.queue.rollCycle().toIndex(this.lastCycle, sequenceNumber);
                this.lastIndex(index);
                return index;
            }
            catch (Exception e) {
                throw Jvm.rethrow((Throwable)e);
            }
        }

        @Override
        public int cycle() {
            if (this.cycle == Integer.MIN_VALUE) {
                int cycle = this.queue.lastCycle();
                if (cycle < 0) {
                    cycle = this.queue.cycle();
                }
                this.setCycle2(cycle, true);
            }
            return this.cycle;
        }

        @Override
        @NotNull
        public SingleChronicleQueue queue() {
            return this.queue;
        }

        @Override
        public Runnable getCloserJob() {
            return () -> this.closableResources.releaseResources();
        }

        void beforeAppend(Wire wire, long index) {
        }

        private void rollCycleTo(int cycle) throws UnrecoverableTimeoutException {
            if (this.wire != null) {
                if (this.cycle == cycle) {
                    throw new AssertionError();
                }
                this.store.writeEOF(this.wire, this.timeoutMS());
            }
            this.setCycle2(cycle, true);
        }

        void writeEndOfCycleIfRequired() {
            if (this.wire != null && this.queue.cycle() != this.cycle) {
                this.store.writeEOF(this.wire, this.timeoutMS());
            }
        }

        void writeIndexForPosition(long index, long position) throws UnrecoverableTimeoutException, StreamCorruptedException {
            long sequenceNumber = this.queue.rollCycle().toSequenceNumber(index);
            this.store.setPositionForSequenceNumber(this, sequenceNumber, position);
        }

        boolean checkIndex(long index, long position) {
            try {
                long seq1 = this.queue.rollCycle().toSequenceNumber(index + 1L) - 1L;
                long seq2 = this.store.sequenceForPosition(this, position, true);
                if (seq1 != seq2) {
                    long seq3 = ((SingleChronicleQueueStore)this.store).indexing.linearScanByPosition(this.wireForIndex(), position, 0L, 0L, true);
                    System.out.println("Thread=" + Thread.currentThread().getName() + " pos: " + position + " seq1: " + Long.toHexString(seq1) + " seq2: " + Long.toHexString(seq2) + " seq3: " + Long.toHexString(seq3));
                    System.out.println(this.store.dump());
                    assert (seq1 == seq3) : "seq1=" + seq1 + ", seq3=" + seq3;
                    assert (seq1 == seq2) : "seq1=" + seq1 + ", seq2=" + seq2;
                }
            }
            catch (EOFException | StreamCorruptedException | UnrecoverableTimeoutException e) {
                throw new AssertionError((Object)e);
            }
            return true;
        }

        public String toString() {
            return "StoreAppender{queue=" + this.queue + ", cycle=" + this.cycle + ", position=" + this.position + ", lastIndex=" + this.lastIndex + ", lastPosition=" + this.lastPosition + ", lastCycle=" + this.lastCycle + '}';
        }

        class StoreAppenderContext
        implements DocumentContext {
            boolean isClosed;
            boolean padToCacheAlign = true;
            private boolean metaData = false;
            private boolean rollbackOnClose = false;
            @Nullable
            private Wire wire;

            StoreAppenderContext() {
            }

            public int sourceId() {
                return StoreAppender.this.sourceId();
            }

            public boolean isPresent() {
                return false;
            }

            public Wire wire() {
                return this.wire;
            }

            public boolean isMetaData() {
                return this.metaData;
            }

            public void metaData(boolean metaData) {
                this.metaData = metaData;
            }

            public boolean isClosed() {
                return this.isClosed;
            }

            public void rollbackOnClose() {
                this.rollbackOnClose = true;
            }

            public void close() {
                this.close(true);
            }

            public void close(boolean unlock) {
                block32: {
                    if (this.isClosed) {
                        LOG.warn("Already Closed, close was called twice.");
                        return;
                    }
                    try {
                        boolean interrupted;
                        boolean bl = interrupted = CHECK_INTERRUPTS && Thread.currentThread().isInterrupted();
                        if (this.rollbackOnClose || interrupted) {
                            if (interrupted) {
                                LOG.warn("Thread is interrupted. Can't guarantee complete message, so not committing");
                            }
                            for (long i = StoreAppender.this.position; i <= this.wire.bytes().writePosition(); ++i) {
                                this.wire.bytes().writeByte(i, (byte)0);
                            }
                            StoreAppender.this.position = StoreAppender.this.lastPosition;
                            this.wire.bytes().writePosition(StoreAppender.this.position);
                            ((AbstractWire)this.wire).forceNotInsideHeader();
                            return;
                        }
                        if (this.wire == StoreAppender.this.wire) {
                            block31: {
                                if (this.padToCacheAlign) {
                                    this.wire.padToCacheAlign();
                                }
                                try {
                                    this.wire.updateHeader(StoreAppender.this.position, this.metaData, 0);
                                }
                                catch (IllegalStateException e) {
                                    if (!StoreAppender.this.queue.isClosed()) break block31;
                                    if (unlock) {
                                        try {
                                            StoreAppender.this.writeLock.unlock();
                                        }
                                        catch (Exception ex) {
                                            Jvm.warn().on(this.getClass(), "Exception while unlocking: ", (Throwable)ex);
                                        }
                                    }
                                    return;
                                }
                            }
                            StoreAppender.this.lastPosition = StoreAppender.this.position;
                            StoreAppender.this.lastCycle = StoreAppender.this.cycle;
                            if (!this.metaData) {
                                StoreAppender.this.lastIndex(this.wire.headerNumber());
                                StoreAppender.this.store.writePosition(StoreAppender.this.position);
                                if (StoreAppender.this.lastIndex != Long.MIN_VALUE) {
                                    StoreAppender.this.writeIndexForPosition(StoreAppender.this.lastIndex, StoreAppender.this.position);
                                } else assert (StoreAppender.this.lastIndex == Long.MIN_VALUE || StoreAppender.this.checkIndex(StoreAppender.this.lastIndex, StoreAppender.this.position));
                            }
                            assert (StoreAppender.this.checkWritePositionHeaderNumber());
                            break block32;
                        }
                        if (this.wire != null) {
                            this.isClosed = true;
                            StoreAppender.this.writeBytesInternal(this.wire.headerNumber(), (BytesStore)this.wire.bytes());
                            this.wire = StoreAppender.this.wire;
                        }
                    }
                    catch (StreamCorruptedException | UnrecoverableTimeoutException e) {
                        throw new IllegalStateException(e);
                    }
                    finally {
                        if (unlock) {
                            try {
                                StoreAppender.this.writeLock.unlock();
                            }
                            catch (Exception ex) {
                                Jvm.warn().on(this.getClass(), "Exception while unlocking: ", (Throwable)ex);
                            }
                        }
                    }
                }
            }

            public long index() throws IORuntimeException {
                if (this.wire.headerNumber() == Long.MIN_VALUE) {
                    try {
                        this.wire.headerNumber(StoreAppender.this.queue.rollCycle().toIndex(StoreAppender.this.cycle, StoreAppender.this.store.lastSequenceNumber(StoreAppender.this)));
                        long headerNumber0 = this.wire.headerNumber();
                        assert (((AbstractWire)this.wire).isInsideHeader());
                        return this.isMetaData() ? headerNumber0 : headerNumber0 + 1L;
                    }
                    catch (IOException e) {
                        throw new IORuntimeException((Throwable)e);
                    }
                }
                return this.isMetaData() ? Long.MIN_VALUE : this.wire.headerNumber() + 1L;
            }

            public boolean isNotComplete() {
                throw new UnsupportedOperationException();
            }
        }
    }

    public static interface InternalAppender {
        public void writeBytes(long var1, BytesStore var3);
    }
}

