/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.nio.file.Path;
import java.util.Optional;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.single.QueueFiles;
import net.openhft.chronicle.wire.WireType;

public enum RollCycleRetriever {

    private static final RollCycles[] ROLL_CYCLES = RollCycles.values();

    public static Optional<RollCycle> getRollCycle(Path queuePath, WireType wireType, long blockSize) {
        return QueueFiles.processLastQueueFile(queuePath, wireType, blockSize, !OS.isWindows(), (w, qs) -> {
            int rollCycleLength = qs.rollCycleLength();
            int rollCycleIndexCount = qs.rollIndexCount();
            int rollCycleIndexSpacing = qs.rollIndexSpacing();
            for (RollCycles cycle : ROLL_CYCLES) {
                if (!RollCycleRetriever.rollCycleMatches(cycle, rollCycleLength, rollCycleIndexCount, rollCycleIndexSpacing)) continue;
                return cycle;
            }
            return null;
        });
    }

    private static boolean rollCycleMatches(RollCycle cycle, int rollCycleLength, int rollCycleIndexCount, int rollCycleIndexSpacing) {
        return cycle.length() == rollCycleLength && cycle.defaultIndexCount() == rollCycleIndexCount && cycle.defaultIndexSpacing() == rollCycleIndexSpacing;
    }
}

