/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.io.Writer;
import java.text.ParseException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.RollingResourcesCache;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.WireStorePool;
import net.openhft.chronicle.queue.impl.single.MetaDataKeys;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import net.openhft.chronicle.queue.impl.single.StoreRecoveryFactory;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.TextWire;
import net.openhft.chronicle.wire.UnrecoverableTimeoutException;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleChronicleQueue
implements RollingChronicleQueue {
    public static final String SUFFIX = ".cq4";
    protected final ThreadLocal<ExcerptAppender> excerptAppenderThreadLocal = ThreadLocal.withInitial(this::newAppender);
    protected final int sourceId;
    final Supplier<Pauser> pauserSupplier;
    final long timeoutMS;
    @NotNull
    private final RollCycle rollCycle;
    @NotNull
    private final RollingResourcesCache dateCache;
    @NotNull
    private final WireStorePool pool;
    private final long epoch;
    private final boolean isBuffered;
    @NotNull
    private final File path;
    @NotNull
    private final WireType wireType;
    private final long blockSize;
    @NotNull
    private final Consumer<BytesRingBufferStats> onRingBufferStats;
    private final EventLoop eventLoop;
    private final long bufferCapacity;
    private final int indexSpacing;
    private final int indexCount;
    @NotNull
    private final TimeProvider time;
    @NotNull
    private final BiFunction<RollingChronicleQueue, Wire, WireStore> storeFactory;
    private final StoreRecoveryFactory recoverySupplier;

    protected SingleChronicleQueue(@NotNull SingleChronicleQueueBuilder builder) {
        this.rollCycle = builder.rollCycle();
        this.epoch = builder.epoch();
        this.dateCache = new RollingResourcesCache(this.rollCycle, this.epoch, name -> new File(builder.path(), name + SUFFIX));
        this.pool = WireStorePool.withSupplier(this::acquireStore);
        this.isBuffered = builder.buffered();
        this.path = builder.path();
        this.wireType = builder.wireType();
        this.blockSize = builder.blockSize();
        this.eventLoop = builder.eventLoop();
        this.bufferCapacity = builder.bufferCapacity();
        this.onRingBufferStats = builder.onRingBufferStats();
        this.indexCount = builder.indexCount();
        this.indexSpacing = builder.indexSpacing();
        this.time = builder.timeProvider();
        this.pauserSupplier = builder.pauserSupplier();
        this.timeoutMS = builder.timeoutMS();
        this.storeFactory = builder.storeFactory();
        this.sourceId = builder.sourceId();
        this.recoverySupplier = builder.recoverySupplier();
    }

    @Override
    public int sourceId() {
        return this.sourceId;
    }

    @Override
    public RollCycle rollcycle() {
        return this.rollCycle;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    @NotNull
    public File file() {
        return this.path;
    }

    @Override
    public String dump() {
        StringBuilder sb = new StringBuilder();
        int max = this.lastCycle();
        for (int i = this.firstCycle(); i <= max; ++i) {
            WireStore wireStore = this.storeForCycle(i, this.epoch, false);
            if (wireStore == null) continue;
            sb.append(wireStore.dump());
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void dump(Writer writer, long fromIndex, long toIndex) {
        try {
            long firstIndex = this.firstIndex();
            writer.append("# firstIndex: ").append(Long.toHexString(firstIndex)).append("\n");
            writer.append("# nextToWrite: ").append(Long.toHexString(this.nextIndexToWrite())).append("\n");
            ExcerptTailer tailer = this.createTailer();
            if (!tailer.moveToIndex(fromIndex)) {
                if (firstIndex <= fromIndex) return;
                tailer.toStart();
            }
            Bytes bytes = Wires.acquireBytes();
            TextWire text = new TextWire(bytes);
            while (true) {
                Throwable throwable;
                DocumentContext dc;
                block40: {
                    block41: {
                        block38: {
                            block39: {
                                dc = tailer.readingDocument();
                                throwable = null;
                                if (dc.isPresent()) break block38;
                                writer.append("# no more messages at ").append(Long.toHexString(dc.index())).append("\n");
                                if (dc == null) return;
                                if (throwable == null) break block39;
                                try {
                                    dc.close();
                                    return;
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                    return;
                                }
                            }
                            dc.close();
                            return;
                        }
                        if (dc.index() <= toIndex) break block40;
                        if (dc == null) return;
                        if (throwable == null) break block41;
                        try {
                            dc.close();
                            return;
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                            return;
                        }
                    }
                    dc.close();
                    return;
                }
                try {
                    writer.append("# index: ").append(Long.toHexString(dc.index())).append("\n");
                    Wire wire = dc.wire();
                    long start = wire.bytes().readPosition();
                    try {
                        text.clear();
                        wire.copyTo((WireOut)text);
                        writer.append(bytes.toString());
                    }
                    catch (Exception e) {
                        wire.bytes().readPosition(start);
                        writer.append((CharSequence)wire.bytes()).append("\n");
                    }
                    continue;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                catch (Throwable throwable5) {
                    throw throwable5;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace(new PrintWriter(writer));
            return;
        }
        finally {
            try {
                writer.flush();
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public int indexCount() {
        return this.indexCount;
    }

    @Override
    public int indexSpacing() {
        return this.indexSpacing;
    }

    @Override
    public long epoch() {
        return this.epoch;
    }

    @Override
    @NotNull
    public RollCycle rollCycle() {
        return this.rollCycle;
    }

    public StoreRecoveryFactory recoverySupplier() {
        return this.recoverySupplier;
    }

    public boolean buffered() {
        return this.isBuffered;
    }

    @Nullable
    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    protected ExcerptAppender newAppender() {
        return new SingleChronicleQueueExcerpts.StoreAppender(this);
    }

    @Override
    @NotNull
    public ExcerptAppender createAppender() {
        return this.excerptAppenderThreadLocal.get();
    }

    @Override
    @NotNull
    public ExcerptTailer createTailer() {
        return new SingleChronicleQueueExcerpts.StoreTailer(this);
    }

    @Override
    @Nullable
    public final WireStore storeForCycle(int cycle, long epoch, boolean createIfAbsent) {
        return this.pool.acquire(cycle, epoch, createIfAbsent);
    }

    public void close() {
        this.pool.close();
    }

    @Override
    public final void release(@NotNull WireStore store) {
        this.pool.release(store);
    }

    @Override
    public final int cycle() {
        return this.rollCycle.current(this.time, this.epoch);
    }

    @Override
    public long firstIndex() {
        int cycle = this.firstCycle();
        if (cycle == Integer.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.rollCycle().toIndex(cycle, 0L);
    }

    String[] getList() {
        return this.path.list();
    }

    @Override
    public int firstCycle() {
        int firstCycle = Integer.MAX_VALUE;
        String[] files = this.getList();
        if (files == null) {
            return Integer.MAX_VALUE;
        }
        for (String file : files) {
            try {
                int fileCycle;
                if (!file.endsWith(SUFFIX) || firstCycle <= (fileCycle = this.dateCache.parseCount(file = file.substring(0, file.length() - SUFFIX.length())))) continue;
                firstCycle = fileCycle;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return firstCycle;
    }

    @Override
    public long nextIndexToWrite() {
        try {
            int lastCycle = this.lastCycle();
            if (lastCycle == Integer.MIN_VALUE) {
                return this.rollCycle.toIndex(this.rollCycle.current(this.time, this.epoch), 0L);
            }
            WireStore store = this.storeForCycle(lastCycle, this.epoch, false);
            if (store == null) {
                return Long.MIN_VALUE;
            }
            Wire wire = (Wire)this.wireType().apply((Object)store.bytes());
            long position = store.writePosition();
            long sequenceNumber = store.indexForPosition(wire, position, 0L);
            return this.rollCycle.toIndex(lastCycle, sequenceNumber);
        }
        catch (EOFException | StreamCorruptedException | UnrecoverableTimeoutException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int lastCycle() {
        int lastCycle = Integer.MIN_VALUE;
        String[] files = this.getList();
        if (files == null) {
            return Integer.MIN_VALUE;
        }
        for (String file : files) {
            try {
                int fileCycle;
                if (!file.endsWith(SUFFIX) || lastCycle >= (fileCycle = this.dateCache.parseCount(file = file.substring(0, file.length() - SUFFIX.length())))) continue;
                lastCycle = fileCycle;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return lastCycle;
    }

    public Consumer<BytesRingBufferStats> onRingBufferStats() {
        return this.onRingBufferStats;
    }

    public long blockSize() {
        return this.blockSize;
    }

    @Override
    @NotNull
    public WireType wireType() {
        return this.wireType;
    }

    public long bufferCapacity() {
        return this.bufferCapacity;
    }

    private MappedBytes mappedBytes(File cycleFile) throws FileNotFoundException {
        long chunkSize = OS.pageAlign((long)this.blockSize);
        long overlapSize = OS.pageAlign((long)(this.blockSize / 4L));
        return MappedBytes.mappedBytes((File)cycleFile, (long)chunkSize, (long)overlapSize);
    }

    @net.openhft.chronicle.core.annotation.Nullable
    private WireStore acquireStore(int cycle, long epoch, boolean createIfAbsent) {
        RollingResourcesCache.Resource dateValue = this.dateCache.resourceFor(cycle);
        try {
            WireStore wireStore;
            File path = dateValue.path;
            File parentFile = path.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            if (!path.exists() && !createIfAbsent) {
                return null;
            }
            MappedBytes mappedBytes = this.mappedBytes(path);
            AbstractWire wire = (AbstractWire)this.wireType.apply((Object)mappedBytes);
            assert (wire.startUse());
            wire.pauser(this.pauserSupplier.get());
            wire.headerNumber(this.rollCycle.toIndex(cycle, 0L));
            if (wire.writeFirstHeader()) {
                wireStore = this.storeFactory.apply(this, (Wire)wire);
                wireStore.writePosition(wire.bytes().writePosition());
                wire.updateFirstHeader();
            } else {
                wire.readFirstHeader(this.timeoutMS, TimeUnit.MILLISECONDS);
                StringBuilder name = Wires.acquireStringBuilder();
                ValueIn valueIn = wire.readEventName(name);
                if (StringUtils.isEqual((CharSequence)name, (CharSequence)MetaDataKeys.header.name())) {
                    wireStore = (WireStore)valueIn.typedMarshallable();
                } else {
                    throw new StreamCorruptedException("The first message should be the header, was " + name);
                }
            }
            return wireStore;
        }
        catch (IOException | TimeoutException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    public String toString() {
        return "SingleChronicleQueue{sourceId=" + this.sourceId + ", path=" + this.path + '}';
    }
}

