/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StreamCorruptedException;
import java.text.ParseException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.RollingResourcesCache;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.WireStorePool;
import net.openhft.chronicle.queue.impl.single.MetaDataKeys;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueExcerpts;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleChronicleQueue
implements RollingChronicleQueue {
    public static final String SUFFIX = ".cq4";
    protected final ThreadLocal<ExcerptAppender> excerptAppenderThreadLocal = ThreadLocal.withInitial(this::newAppender);
    protected final int sourceId;
    final Supplier<Pauser> pauserSupplier;
    final long timeoutMS;
    @NotNull
    private final RollCycle rollCycle;
    @NotNull
    private final RollingResourcesCache dateCache;
    @NotNull
    private final WireStorePool pool;
    private final long epoch;
    private final boolean isBuffered;
    @NotNull
    private final File path;
    @NotNull
    private final WireType wireType;
    private final long blockSize;
    @NotNull
    private final Consumer<BytesRingBufferStats> onRingBufferStats;
    private final EventLoop eventLoop;
    private final long bufferCapacity;
    private final int indexSpacing;
    private final int indexCount;
    @NotNull
    private final TimeProvider time;
    @NotNull
    private final BiFunction<RollingChronicleQueue, Wire, WireStore> storeFactory;

    protected SingleChronicleQueue(@NotNull SingleChronicleQueueBuilder builder) {
        this.rollCycle = builder.rollCycle();
        this.epoch = builder.epoch();
        this.dateCache = new RollingResourcesCache(this.rollCycle, this.epoch, name -> new File(builder.path(), name + SUFFIX));
        this.pool = WireStorePool.withSupplier(this::acquireStore);
        this.isBuffered = builder.buffered();
        this.path = builder.path();
        this.wireType = builder.wireType();
        this.blockSize = builder.blockSize();
        this.eventLoop = builder.eventLoop();
        this.bufferCapacity = builder.bufferCapacity();
        this.onRingBufferStats = builder.onRingBufferStats();
        this.indexCount = builder.indexCount();
        this.indexSpacing = builder.indexSpacing();
        this.time = builder.timeProvider();
        this.pauserSupplier = builder.pauserSupplier();
        this.timeoutMS = builder.timeoutMS();
        this.storeFactory = builder.storeFactory();
        this.sourceId = builder.sourceId();
    }

    @Override
    public int sourceId() {
        return this.sourceId;
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    @Override
    @NotNull
    public File file() {
        return this.path;
    }

    @Override
    public String dump() {
        StringBuilder sb = new StringBuilder();
        int max = this.lastCycle();
        for (int i = this.firstCycle(); i <= max; ++i) {
            sb.append(this.storeForCycle(i, this.epoch).dump());
        }
        return sb.toString();
    }

    @Override
    public int indexCount() {
        return this.indexCount;
    }

    @Override
    public int indexSpacing() {
        return this.indexSpacing;
    }

    @Override
    public long epoch() {
        return this.epoch;
    }

    @Override
    @NotNull
    public RollCycle rollCycle() {
        return this.rollCycle;
    }

    public boolean buffered() {
        return this.isBuffered;
    }

    @Nullable
    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    protected ExcerptAppender newAppender() {
        return new SingleChronicleQueueExcerpts.StoreAppender(this);
    }

    @Override
    @NotNull
    public ExcerptAppender createAppender() {
        return this.excerptAppenderThreadLocal.get();
    }

    @Override
    @NotNull
    public ExcerptTailer createTailer() {
        return new SingleChronicleQueueExcerpts.StoreTailer(this);
    }

    @Override
    @NotNull
    public final WireStore storeForCycle(int cycle, long epoch) {
        return this.pool.acquire(cycle, epoch);
    }

    public void close() {
        this.pool.close();
    }

    @Override
    public final void release(@NotNull WireStore store) {
        this.pool.release(store);
    }

    @Override
    public final int cycle() {
        return this.rollCycle.current(this.time, this.epoch);
    }

    @Override
    public long firstIndex() {
        int cycle = this.firstCycle();
        if (cycle == Integer.MAX_VALUE) {
            return Long.MAX_VALUE;
        }
        return this.rollCycle().toIndex(cycle, 0L);
    }

    @Override
    public int firstCycle() {
        int firstCycle = Integer.MAX_VALUE;
        String[] files = this.path.list();
        if (files == null) {
            return Integer.MAX_VALUE;
        }
        for (String file : files) {
            try {
                int fileCycle;
                if (!file.endsWith(SUFFIX) || firstCycle <= (fileCycle = this.dateCache.parseCount(file = file.substring(0, file.length() - SUFFIX.length())))) continue;
                firstCycle = fileCycle;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return firstCycle;
    }

    @Override
    public long lastIndex() {
        for (int i = 0; i < 100; ++i) {
            try {
                Wire wire;
                int lastCycle = this.lastCycle();
                if (lastCycle == Integer.MIN_VALUE) {
                    return Long.MIN_VALUE;
                }
                WireStore store = this.storeForCycle(lastCycle, this.epoch);
                long sequenceNumber = store.indexForPosition(wire = (Wire)this.wireType().apply((Object)store.mappedBytes()), store.writePosition(), 0L);
                if (sequenceNumber == -1L) {
                    ++sequenceNumber;
                }
                return this.rollCycle.toIndex(lastCycle, sequenceNumber);
            }
            catch (EOFException lastCycle) {
                continue;
            }
            catch (TimeoutException e) {
                throw new AssertionError((Object)e);
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public int lastCycle() {
        int lastCycle = Integer.MIN_VALUE;
        String[] files = this.path.list();
        if (files == null) {
            return Integer.MIN_VALUE;
        }
        for (String file : files) {
            try {
                int fileCycle;
                if (!file.endsWith(SUFFIX) || lastCycle >= (fileCycle = this.dateCache.parseCount(file = file.substring(0, file.length() - SUFFIX.length())))) continue;
                lastCycle = fileCycle;
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return lastCycle;
    }

    public Consumer<BytesRingBufferStats> onRingBufferStats() {
        return this.onRingBufferStats;
    }

    public long blockSize() {
        return this.blockSize;
    }

    @Override
    @NotNull
    public WireType wireType() {
        return this.wireType;
    }

    public long bufferCapacity() {
        return this.bufferCapacity;
    }

    private MappedBytes mappedBytes(File cycleFile) throws FileNotFoundException {
        long chunkSize = OS.pageAlign((long)this.blockSize);
        long overlapSize = OS.pageAlign((long)(this.blockSize / 4L));
        return MappedBytes.mappedBytes((File)cycleFile, (long)chunkSize, (long)overlapSize);
    }

    @NotNull
    private WireStore acquireStore(int cycle, long epoch) {
        RollingResourcesCache.Resource dateValue = this.dateCache.resourceFor(cycle);
        try {
            File parentFile = dateValue.path.getParentFile();
            if (parentFile != null && !parentFile.exists()) {
                parentFile.mkdirs();
            }
            MappedBytes mappedBytes = this.mappedBytes(dateValue.path);
            AbstractWire wire = (AbstractWire)this.wireType.apply((Object)mappedBytes);
            assert (wire.startUse());
            wire.pauser(this.pauserSupplier.get());
            wire.headerNumber(this.rollCycle.toIndex(cycle, 0L));
            if (wire.writeFirstHeader()) {
                SingleChronicleQueue queue = this;
                WireStore wireStore = this.storeFactory.apply(queue, (Wire)wire);
                wireStore.writePosition(wire.bytes().writePosition());
                wire.updateFirstHeader();
                return wireStore;
            }
            wire.readFirstHeader(this.timeoutMS, TimeUnit.MILLISECONDS);
            StringBuilder name = Wires.acquireStringBuilder();
            ValueIn valueIn = wire.readEventName(name);
            if (StringUtils.isEqual((CharSequence)name, (CharSequence)MetaDataKeys.header.name())) {
                return (WireStore)valueIn.typedMarshallable();
            }
            throw new StreamCorruptedException("The first message should be the header, was " + name);
        }
        catch (IOException | TimeoutException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    public String toString() {
        return "SingleChronicleQueue{sourceId=" + this.sourceId + ", path=" + this.path + '}';
    }
}

