/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.util.LinkedHashMap;
import java.util.Map;
import net.openhft.chronicle.core.pool.StringInterner;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.Wires;

enum QueueInternal {

    static final StringInterner INTERNER = new StringInterner(128);

    static Map<String, Object> readMap(ExcerptTailer tailer) {
        try (DocumentContext context = tailer.readingDocument();){
            if (!context.isData()) {
                Map<String, Object> map = null;
                return map;
            }
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            StringBuilder sb = Wires.acquireStringBuilder();
            Wire wire = context.wire();
            while (wire.hasMore()) {
                Object object = wire.readEventName(sb).object();
                map.put(INTERNER.intern((CharSequence)sb), object);
            }
            LinkedHashMap<String, Object> linkedHashMap = map;
            return linkedHashMap;
        }
    }

    static void writeMap(ExcerptAppender appender, Map<String, ?> map) {
        try (DocumentContext context = appender.writingDocument();){
            Wire wire = context.wire();
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                wire.writeEventName((CharSequence)entry.getKey()).object(entry.getValue());
            }
        }
    }
}

