/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.EOFException;
import java.io.StreamCorruptedException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.ReadBytesMarshallable;
import net.openhft.chronicle.bytes.WriteBytesMarshallable;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.StringUtils;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.TailerDirection;
import net.openhft.chronicle.queue.VanillaExcerptHistory;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.single.NoDocumentContext;
import net.openhft.chronicle.queue.impl.single.ScanResult;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueue;
import net.openhft.chronicle.wire.AbstractWire;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleChronicleQueueExcerpts {
    private static final Logger LOG = LoggerFactory.getLogger(SingleChronicleQueueExcerpts.class);

    public static class StoreTailer
    extends ReadDocumentContext
    implements ExcerptTailer {
        @NotNull
        private final SingleChronicleQueue queue;
        private int cycle;
        private long index;
        private WireStore store;
        private TailerDirection direction = TailerDirection.FORWARD;

        public StoreTailer(@NotNull SingleChronicleQueue queue) {
            super(null);
            this.queue = queue;
            this.cycle = Integer.MIN_VALUE;
            this.index = 0L;
            this.toStart();
        }

        public int sourceId() {
            return this.queue.sourceId;
        }

        public String toString() {
            return "StoreTailer{index sequence=" + this.queue.rollCycle().toSequenceNumber(this.index) + ", index cycle=" + this.queue.rollCycle().toCycle(this.index) + ", store=" + this.store + ", queue=" + this.queue + '}';
        }

        @Override
        public boolean readDocument(@NotNull ReadMarshallable marshaller) {
            try {
                return this.read(marshaller, ReadMarshallable::readMarshallable, this.queue.timeoutMS);
            }
            catch (TimeoutException e) {
                return false;
            }
        }

        @Override
        public boolean readBytes(@NotNull Bytes using) {
            try {
                return this.read(using, (t, w) -> t.write((BytesStore)w.bytes()), this.queue.timeoutMS);
            }
            catch (TimeoutException e) {
                return false;
            }
        }

        @Override
        public DocumentContext readingDocument(boolean includeMetaData) {
            block3: {
                while (true) {
                    try {
                        this.present = this.next();
                    }
                    catch (TimeoutException ignored) {
                        this.present = false;
                    }
                    if (!this.present) break block3;
                    if (includeMetaData || !this.isMetaData()) break;
                    this.close();
                }
                return this;
            }
            return NoDocumentContext.INSTANCE;
        }

        @Override
        public String readText() {
            StringBuilder sb = Wires.acquireStringBuilder();
            return this.readText(sb) ? sb.toString() : null;
        }

        @Override
        @Nullable
        public boolean readText(StringBuilder sb) {
            try {
                if (this.read(sb, (t, w) -> w.bytes().parseUtf8((Appendable)sb, (int)w.bytes().readRemaining()), this.queue.timeoutMS)) {
                    return true;
                }
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
            sb.setLength(0);
            sb.append("No message");
            return false;
        }

        public void close() {
            if (this.isPresent()) {
                this.incrementIndex();
            }
            super.close();
        }

        private boolean next() throws TimeoutException {
            if (this.store == null) {
                long firstIndex = this.queue.firstIndex();
                if (firstIndex == Long.MAX_VALUE) {
                    return false;
                }
                if (!this.moveToIndex(firstIndex)) {
                    return false;
                }
            }
            Bytes bytes = this.wire.bytes();
            bytes.readLimit(bytes.capacity());
            for (int i = 0; i < 1000; ++i) {
                try {
                    if (this.direction != TailerDirection.FORWARD) {
                        try {
                            this.moveToIndex(this.index);
                        }
                        catch (TimeoutException notReady) {
                            return false;
                        }
                    }
                    if (this.wire.readDataHeader()) {
                        this.closeReadLimit(bytes.capacity());
                        this.wire.readAndSetLength(bytes.readPosition());
                        long end = bytes.readLimit();
                        this.closeReadPosition(end);
                        return true;
                    }
                    return false;
                }
                catch (EOFException eof) {
                    if (this.cycle <= this.queue.lastCycle() && this.direction != TailerDirection.NONE) {
                        try {
                            if (this.moveToIndex(this.cycle + this.direction.add(), 0L)) {
                                bytes = this.wire.bytes();
                                continue;
                            }
                        }
                        catch (TimeoutException timeoutException) {
                            // empty catch block
                        }
                    }
                    return false;
                }
            }
            throw new IllegalStateException("Unable to progress to the next cycle");
        }

        @Override
        public boolean readBytes(@NotNull ReadBytesMarshallable using) {
            try {
                return this.read(using, (t, w) -> t.readMarshallable(w.bytes()), this.queue.timeoutMS);
            }
            catch (TimeoutException e) {
                return false;
            }
        }

        @Override
        public long index() {
            if (this.store == null) {
                throw new IllegalArgumentException("This tailer is not bound to any cycle");
            }
            return this.queue.rollCycle().toIndex(this.cycle, this.index);
        }

        @Override
        public int cycle() {
            return this.cycle;
        }

        @Override
        public boolean moveToIndex(long index) throws TimeoutException {
            return this.moveToIndex(this.queue.rollCycle().toCycle(index), this.queue.rollCycle().toSequenceNumber(index), index);
        }

        boolean moveToIndex(int cycle, long sequenceNumber) throws TimeoutException {
            return this.moveToIndex(cycle, sequenceNumber, this.queue.rollCycle().toIndex(cycle, sequenceNumber));
        }

        boolean moveToIndex(int cycle, long sequenceNumber, long index) throws TimeoutException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("moveToIndex: " + Long.toHexString(cycle) + " " + Long.toHexString(sequenceNumber));
            }
            if (cycle != this.cycle) {
                this.cycle(cycle);
            }
            this.index = index;
            ScanResult scanResult = this.store.moveToIndex((Wire)this.wire, sequenceNumber, this.queue.timeoutMS);
            Bytes bytes = this.wire.bytes();
            if (scanResult == ScanResult.FOUND) {
                return true;
            }
            bytes.readLimit(bytes.readPosition());
            return false;
        }

        @Override
        @NotNull
        public final ExcerptTailer toStart() {
            assert (this.direction != TailerDirection.BACKWARD);
            int firstCycle = this.queue.firstCycle();
            if (firstCycle == Integer.MAX_VALUE) {
                return this;
            }
            if (firstCycle != this.cycle) {
                this.cycle(firstCycle);
            }
            this.index = this.queue.rollCycle().toIndex(this.cycle, 0L);
            this.wire.bytes().readPosition(0L);
            return this;
        }

        @Override
        @NotNull
        public ExcerptTailer toEnd() {
            long index = this.queue.lastIndex();
            if (index == Long.MIN_VALUE) {
                return this;
            }
            try {
                if (this.direction == TailerDirection.FORWARD || this.queue.rollCycle().toSequenceNumber(index + 1L) == 0L) {
                    ++index;
                }
                this.moveToIndex(index);
            }
            catch (TimeoutException e) {
                throw new AssertionError((Object)e);
            }
            return this;
        }

        @Override
        public TailerDirection direction() {
            return this.direction;
        }

        @Override
        public ExcerptTailer direction(TailerDirection direction) {
            this.direction = direction;
            return this;
        }

        public RollingChronicleQueue queue() {
            return this.queue;
        }

        private <T> boolean read(@NotNull T t, @NotNull BiConsumer<T, Wire> c, long timeoutMS) throws TimeoutException {
            if (this.store == null) {
                this.toStart();
                if (this.store == null) {
                    return false;
                }
            }
            if (this.read0(t, c)) {
                this.incrementIndex();
                return true;
            }
            return false;
        }

        private void incrementIndex() {
            RollCycle rollCycle = this.queue.rollCycle();
            long seq = rollCycle.toSequenceNumber(this.index);
            if (rollCycle.toSequenceNumber(seq += (long)this.direction.add()) < seq) {
                this.cycle(this.cycle + 1);
                seq = 0L;
            } else if (seq < 0L) {
                seq = 0L;
            }
            this.index = rollCycle.toIndex(this.cycle, seq);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private <T> boolean read0(@NotNull T t, @NotNull BiConsumer<T, Wire> c) {
            Bytes bytes = this.wire.bytes();
            bytes.readLimit(bytes.capacity());
            for (int i = 0; i < 1000; ++i) {
                boolean bl;
                if (this.direction != TailerDirection.FORWARD) {
                    try {
                        this.moveToIndex(this.index);
                    }
                    catch (TimeoutException notReady) {
                        return false;
                    }
                }
                if (!this.wire.readDataHeader()) return false;
                this.wire.readAndSetLength(bytes.readPosition());
                long end = bytes.readLimit();
                try {
                    c.accept(t, (Wire)this.wire);
                    bl = true;
                }
                catch (Throwable throwable) {
                    try {
                        ((Bytes)bytes.readLimit(bytes.capacity())).readPosition(end);
                        throw throwable;
                    }
                    catch (EOFException eof) {
                        if (this.cycle > this.queue.lastCycle() || this.direction == TailerDirection.NONE) return false;
                        try {
                            if (!this.moveToIndex(this.cycle + this.direction.add(), 0L)) return false;
                            bytes = this.wire.bytes();
                            continue;
                        }
                        catch (TimeoutException timeoutException) {
                            // empty catch block
                        }
                        return false;
                    }
                }
                ((Bytes)bytes.readLimit(bytes.capacity())).readPosition(end);
                return bl;
            }
            throw new IllegalStateException("Unable to progress to the next cycle");
        }

        @NotNull
        private StoreTailer cycle(int cycle) {
            if (this.cycle != cycle) {
                if (this.store != null) {
                    this.queue.release(this.store);
                }
                this.cycle = cycle;
                this.store = this.queue.storeForCycle(cycle, this.queue.epoch());
                this.wire = (AbstractWire)this.queue.wireType().apply((Object)this.store.mappedBytes());
                this.wire.parent((Object)this);
                this.wire.pauser(this.queue.pauserSupplier.get());
            }
            return this;
        }

        public long lastIndex(int cycle) {
            this.cycle(cycle);
            long sequenceNumber = this.store.lastEntryIndexed((Wire)this.wire, this.queue.timeoutMS);
            return this.queue.rollCycle().toIndex(this.cycle, sequenceNumber + 1L) - 1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public ExcerptTailer afterLastWritten(ChronicleQueue queue) {
            ExcerptTailer tailer = queue.createTailer().direction(TailerDirection.BACKWARD).toEnd();
            StringBuilder sb = new StringBuilder();
            VanillaExcerptHistory veh = new VanillaExcerptHistory();
            int sourceId = queue.sourceId();
            while (true) {
                DocumentContext context = tailer.readingDocument();
                Throwable throwable = null;
                if (!context.isData()) {
                    this.toStart();
                    StoreTailer storeTailer = this;
                    return storeTailer;
                }
                ValueIn valueIn = context.wire().readEventName(sb);
                if (!StringUtils.isEqual((CharSequence)"history", (CharSequence)sb)) continue;
                Object parent = this.wire.parent();
                try {
                    this.wire.parent(null);
                    valueIn.marshallable((ReadMarshallable)veh);
                }
                finally {
                    this.wire.parent(parent);
                }
                int i = veh.sources() - 1;
                if (i < 0 || veh.sourceId(i) != sourceId) continue;
                long sourceIndex = veh.sourceIndex(i);
                if (!this.moveToIndex(sourceIndex)) {
                    throw new IORuntimeException("Unable to wind to index: " + sourceIndex);
                }
                try (DocumentContext content = this.readingDocument();){
                    if (!content.isPresent()) {
                        throw new IORuntimeException("Unable to wind to index: " + (sourceIndex + 1L));
                    }
                }
                StoreTailer storeTailer = this;
                return storeTailer;
                {
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                finally {
                    if (context == null) continue;
                    if (throwable != null) {
                        try {
                            context.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    context.close();
                    continue;
                }
                break;
            }
        }
    }

    public static class StoreAppender
    implements ExcerptAppender,
    DocumentContext {
        @NotNull
        private final SingleChronicleQueue queue;
        private int cycle = Integer.MIN_VALUE;
        private WireStore store;
        private AbstractWire wire;
        private long position = -1L;
        private boolean metaData = false;
        private volatile Thread appendingThread = null;

        public StoreAppender(@NotNull SingleChronicleQueue queue) {
            this.queue = queue;
            int cycle = this.queue.lastCycle();
            if (cycle < 0) {
                cycle = queue.cycle();
            }
            this.setCycle2(cycle);
        }

        public int sourceId() {
            return this.queue.sourceId;
        }

        public long index() {
            throw new UnsupportedOperationException("TODO");
        }

        private void setCycle(int cycle) {
            if (cycle != this.cycle) {
                this.setCycle2(cycle);
            }
        }

        private void setCycle2(int cycle) {
            if (cycle < 0) {
                throw new IllegalArgumentException("You can not have a cycle that starts before Epoch. cycle=" + cycle);
            }
            this.cycle = cycle;
            SingleChronicleQueue queue = this.queue;
            if (this.store != null) {
                queue.release(this.store);
            }
            this.store = queue.storeForCycle(cycle, queue.epoch());
            MappedBytes mappedBytes = this.store.mappedBytes();
            if (LOG.isDebugEnabled()) {
                LOG.debug("appender file=" + mappedBytes.mappedFile().file().getAbsolutePath());
            }
            this.wire = (AbstractWire)queue.wireType().apply((Object)mappedBytes);
            this.wire.parent((Object)this);
            this.wire.pauser(queue.pauserSupplier.get());
            this.wire.bytes().writePosition(this.store.writePosition());
        }

        public boolean isPresent() {
            return false;
        }

        public Wire wire() {
            return this.wire;
        }

        @Override
        public DocumentContext writingDocument() {
            try {
                this.position = this.wire.writeHeader(this.queue.timeoutMS, TimeUnit.MILLISECONDS);
                this.metaData = false;
            }
            catch (TimeoutException e) {
                throw new IllegalStateException(e);
            }
            catch (EOFException e) {
                throw new UnsupportedOperationException("Must roll to the next cycle");
            }
            return this;
        }

        public boolean isMetaData() {
            return this.metaData;
        }

        public void metaData(boolean metaData) {
            this.metaData = metaData;
        }

        public void close() {
            try {
                this.wire.updateHeader(this.position, this.metaData);
                long position = this.wire.bytes().writePosition();
                this.store.writePosition(position);
            }
            catch (StreamCorruptedException e) {
                throw new IllegalStateException(e);
            }
        }

        @Override
        public void writeDocument(@NotNull WriteMarshallable writer) {
            this.append(0, WriteMarshallable::writeMarshallable, writer);
        }

        public void writeBytes(@NotNull Bytes bytes) {
            this.append(Maths.toUInt31((long)bytes.readRemaining()), (m, w) -> {
                Bytes cfr_ignored_0 = (Bytes)w.bytes().write((BytesStore)m);
            }, bytes);
        }

        @Override
        public void writeBytes(long index, Bytes<?> bytes) throws StreamCorruptedException {
            assert (this.checkAppendingThread());
            try {
                int cycle = this.queue.rollCycle().toCycle(index);
                if (!this.moveToIndex(cycle, this.queue.rollCycle().toSequenceNumber(index))) {
                    throw new StreamCorruptedException("Unable to move to index " + Long.toHexString(index));
                }
                Bytes wireBytes = this.wire.bytes();
                try {
                    int length = bytes.length();
                    this.position = this.wire.writeHeader(length, this.queue.timeoutMS, TimeUnit.MILLISECONDS);
                    wireBytes.write(bytes);
                    this.wire.updateHeader(length, this.position, false);
                }
                catch (EOFException theySeeMeRolling) {
                    if (wireBytes.compareAndSwapInt(wireBytes.writePosition(), -1073741824, Integer.MIN_VALUE)) {
                        wireBytes.write(bytes);
                        this.wire.updateHeader(0, this.position, false);
                    }
                }
            }
            catch (StreamCorruptedException | TimeoutException e) {
                throw Jvm.rethrow((Throwable)e);
            }
            finally {
                Bytes wireBytes = this.wire.bytes();
                this.store.writePosition(wireBytes.writePosition());
                assert (this.resetAppendingThread());
            }
        }

        boolean moveToIndex(int cycle, long sequenceNumber) throws TimeoutException {
            if (LOG.isDebugEnabled()) {
                LOG.debug("moveToIndex: " + Long.toHexString(cycle) + " " + Long.toHexString(sequenceNumber));
            }
            if (this.cycle != cycle) {
                if (cycle > this.cycle) {
                    this.rollCycleTo(cycle);
                } else {
                    this.setCycle2(cycle);
                }
            }
            ScanResult scanResult = this.store.moveToIndex((Wire)this.wire, sequenceNumber, this.queue.timeoutMS);
            Bytes bytes = this.wire.bytes();
            if (scanResult == ScanResult.NOT_FOUND) {
                this.wire.bytes().writePosition(this.wire.bytes().readPosition());
                return true;
            }
            bytes.readLimit(bytes.readPosition());
            return false;
        }

        @Override
        public void writeBytes(@NotNull WriteBytesMarshallable marshallable) {
            this.append(0, (m, w) -> m.writeMarshallable(w.bytes()), marshallable);
        }

        @Override
        public long lastIndexAppended() {
            if (this.position == -1L) {
                throw new IllegalStateException("no messages written");
            }
            try {
                long index;
                long sequenceNumber = this.store.indexForPosition((Wire)this.wire, this.position, this.queue.timeoutMS);
                long l = index = this.queue.rollCycle().toIndex(this.cycle, sequenceNumber);
                return l;
            }
            catch (EOFException | TimeoutException e) {
                throw new AssertionError((Object)e);
            }
            finally {
                this.wire.bytes().writePosition(this.store.writePosition());
            }
        }

        @Override
        public int cycle() {
            return this.cycle;
        }

        public SingleChronicleQueue queue() {
            return this.queue;
        }

        private <T> void append(int length, WireWriter<T> wireWriter, T writer) {
            assert (this.checkAppendingThread());
            try {
                int cycle = this.queue.cycle();
                if (this.cycle != cycle) {
                    this.rollCycleTo(cycle);
                }
                try {
                    this.position = this.wire.writeHeader(length, this.queue.timeoutMS, TimeUnit.MILLISECONDS);
                    wireWriter.write(writer, (WireOut)this.wire);
                    this.wire.updateHeader(length, this.position, false);
                }
                catch (EOFException theySeeMeRolling) {
                    this.append2(length, wireWriter, writer);
                }
            }
            catch (EOFException | StreamCorruptedException | TimeoutException e) {
                throw Jvm.rethrow((Throwable)e);
            }
            finally {
                this.store.writePosition(this.wire.bytes().writePosition());
                assert (this.resetAppendingThread());
            }
        }

        private void rollCycleTo(int cycle) throws TimeoutException {
            this.wire.writeEndOfWire(this.queue.timeoutMS, TimeUnit.MILLISECONDS);
            this.setCycle2(cycle);
        }

        private <T> void append2(int length, WireWriter<T> wireWriter, T writer) throws TimeoutException, EOFException, StreamCorruptedException {
            this.setCycle(Math.max(this.queue.cycle(), this.cycle + 1));
            this.position = this.wire.writeHeader(length, this.queue.timeoutMS, TimeUnit.MILLISECONDS);
            wireWriter.write(writer, (WireOut)this.wire);
            this.wire.updateHeader(length, this.position, false);
        }

        private boolean checkAppendingThread() {
            Thread appendingThread = this.appendingThread;
            if (appendingThread != null) {
                throw new IllegalStateException("Attempting to use Appneder in " + Thread.currentThread() + " while used by " + appendingThread);
            }
            this.appendingThread = Thread.currentThread();
            return true;
        }

        private boolean resetAppendingThread() {
            if (this.appendingThread == null) {
                throw new IllegalStateException("Attempting to release Appender in " + Thread.currentThread() + " but already released");
            }
            this.appendingThread = null;
            return true;
        }
    }

    @FunctionalInterface
    public static interface WireWriter<T> {
        public void write(T var1, WireOut var2);
    }
}

