/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.File;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.time.SystemTimeProvider;
import net.openhft.chronicle.core.time.TimeProvider;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ChronicleQueueBuilder;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollCycles;
import net.openhft.chronicle.queue.impl.RollingChronicleQueue;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.TimeoutPauser;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractChronicleQueueBuilder<B extends ChronicleQueueBuilder<B, Q>, Q extends ChronicleQueue>
implements ChronicleQueueBuilder<B, Q> {
    protected final Logger log = LoggerFactory.getLogger((String)this.getClass().getName());
    protected final File path;
    protected long blockSize = 0x4000000L;
    @NotNull
    protected WireType wireType;
    @NotNull
    protected RollCycle rollCycle;
    protected long epoch;
    protected boolean isBuffered;
    protected Consumer<Throwable> onThrowable = Throwable::printStackTrace;
    @Nullable
    protected EventLoop eventLoop;
    private long bufferCapacity;
    private int indexSpacing;
    private int indexCount;
    private Consumer<BytesRingBufferStats> onRingBufferStats = NoBytesRingBufferStats.NONE;
    private TimeProvider timeProvider = SystemTimeProvider.INSTANCE;
    private Supplier<Pauser> pauserSupplier = () -> new TimeoutPauser(500000);
    private long timeoutMS = 10000L;
    private BiFunction<RollingChronicleQueue, Wire, WireStore> storeFactory;

    public AbstractChronicleQueueBuilder(File path) {
        this.rollCycle = RollCycles.DAILY;
        this.path = path;
        this.wireType = WireType.BINARY;
        this.epoch = 0L;
        this.bufferCapacity = 0x200000L;
        this.indexSpacing = -1;
        this.indexCount = -1;
    }

    @Override
    @NotNull
    public B onRingBufferStats(@NotNull Consumer<BytesRingBufferStats> onRingBufferStats) {
        this.onRingBufferStats = onRingBufferStats;
        return (B)this;
    }

    @Override
    public Consumer<BytesRingBufferStats> onRingBufferStats() {
        return this.onRingBufferStats;
    }

    @Override
    @NotNull
    public File path() {
        return this.path;
    }

    @Override
    @NotNull
    public B blockSize(int blockSize) {
        this.blockSize = blockSize;
        return (B)this;
    }

    @Override
    public long blockSize() {
        return this.blockSize;
    }

    @Override
    @NotNull
    public B wireType(@NotNull WireType wireType) {
        this.wireType = wireType;
        return (B)this;
    }

    @Override
    @NotNull
    public WireType wireType() {
        return this.wireType;
    }

    @Override
    @NotNull
    public B rollCycle(@NotNull RollCycle rollCycle) {
        this.rollCycle = rollCycle;
        return (B)this;
    }

    @Override
    public long bufferCapacity() {
        return this.bufferCapacity;
    }

    @Override
    @NotNull
    public B bufferCapacity(long ringBufferSize) {
        this.bufferCapacity = ringBufferSize;
        return (B)this;
    }

    @Override
    @NotNull
    public B epoch(long epoch) {
        this.epoch = epoch;
        return (B)this;
    }

    @Override
    public long epoch() {
        return this.epoch;
    }

    @Override
    @NotNull
    public RollCycle rollCycle() {
        return this.rollCycle;
    }

    @Override
    @NotNull
    public B onThrowable(@NotNull Consumer<Throwable> onThrowable) {
        this.onThrowable = onThrowable;
        return (B)this;
    }

    @Override
    @NotNull
    public B buffered(boolean isBuffered) {
        this.isBuffered = isBuffered;
        return (B)this;
    }

    @Override
    public boolean buffered() {
        return this.isBuffered;
    }

    @Override
    @Nullable
    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    @Override
    @NotNull
    public B eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
        return (B)this;
    }

    @Override
    @NotNull
    public B bufferCapacity(int bufferCapacity) {
        this.bufferCapacity = bufferCapacity;
        this.isBuffered = true;
        return (B)this;
    }

    @Override
    public B indexCount(int indexCount) {
        this.indexCount = Maths.nextPower2((int)indexCount, (int)8);
        return (B)this;
    }

    @Override
    public int indexCount() {
        return this.indexCount <= 0 ? this.rollCycle.defaultIndexCount() : this.indexCount;
    }

    @Override
    public B indexSpacing(int indexSpacing) {
        this.indexSpacing = Maths.nextPower2((int)indexSpacing, (int)1);
        return (B)this;
    }

    @Override
    public int indexSpacing() {
        return this.indexSpacing <= 0 ? this.rollCycle.defaultIndexSpacing() : this.indexSpacing;
    }

    public TimeProvider timeProvider() {
        return this.timeProvider;
    }

    public B timeProvider(TimeProvider timeProvider) {
        this.timeProvider = timeProvider;
        return (B)this;
    }

    public Supplier<Pauser> pauserSupplier() {
        return this.pauserSupplier;
    }

    public B pauserSupplier(Supplier<Pauser> pauser) {
        this.pauserSupplier = pauser;
        return (B)this;
    }

    public B timeoutMS(long timeoutMS) {
        this.timeoutMS = timeoutMS;
        return (B)this;
    }

    public long timeoutMS() {
        return this.timeoutMS;
    }

    public void storeFactory(BiFunction<RollingChronicleQueue, Wire, WireStore> storeFactory) {
        this.storeFactory = storeFactory;
    }

    @Override
    public BiFunction<RollingChronicleQueue, Wire, WireStore> storeFactory() {
        return this.storeFactory;
    }

    static enum NoBytesRingBufferStats implements Consumer<BytesRingBufferStats>
    {
        NONE;


        @Override
        public void accept(BytesRingBufferStats bytesRingBufferStats) {
        }
    }
}

