/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl;

import java.io.File;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import java.util.function.Function;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.queue.RollCycle;
import org.jetbrains.annotations.NotNull;

public class RollingResourcesCache {
    private static final int SIZE = 32;
    @NotNull
    private final Function<String, File> fileFactory;
    @NotNull
    private final DateFormat formatter;
    @NotNull
    private final Resource[] values;
    private final int length;

    public RollingResourcesCache(@NotNull RollCycle cycle, @NotNull Function<String, File> fileFactory) {
        this(cycle.length(), cycle.format(), cycle.zone(), fileFactory);
    }

    private RollingResourcesCache(int length, @NotNull String format, @NotNull ZoneId zoneId, @NotNull Function<String, File> fileFactory) {
        this.length = length;
        this.values = new Resource[32];
        this.formatter = new SimpleDateFormat(format);
        this.formatter.setTimeZone(TimeZone.getTimeZone(zoneId));
        this.fileFactory = fileFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Resource resourceFor(long cycle) {
        long millis = cycle * (long)this.length;
        int hash = Maths.hash32((long)millis) & 0x1F;
        Resource dv = this.values[hash];
        if (dv == null || dv.millis != millis) {
            DateFormat dateFormat = this.formatter;
            synchronized (dateFormat) {
                String text = this.formatter.format(new Date(millis));
                this.values[hash] = dv = new Resource(millis, text, this.fileFactory.apply(text));
            }
        }
        return dv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long parseCount(@NotNull String name) throws ParseException {
        DateFormat dateFormat = this.formatter;
        synchronized (dateFormat) {
            return this.formatter.parse(name).getTime() / (long)this.length;
        }
    }

    public static class Resource {
        public final long millis;
        public final String text;
        public final File path;

        Resource(long millis, String text, File path) {
            this.millis = millis;
            this.text = text;
            this.path = path;
        }
    }
}

