/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.Closeable;
import java.io.IOException;
import java.time.ZoneId;
import java.util.function.Supplier;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.bytes.MappedFile;
import net.openhft.chronicle.core.ReferenceCounter;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.core.values.LongValue;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.wire.Demarshallable;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireInternal;
import net.openhft.chronicle.wire.WireKey;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SingleChronicleQueueStore
implements WireStore {
    private static final long NUMBER_OF_ENTRIES_IN_EACH_INDEX = 131072L;
    @NotNull
    private final WireType wireType;
    @NotNull
    private final Roll roll;
    @NotNull
    private final Bounds bounds;
    private final MappedFile mappedFile;
    @Nullable
    private Closeable resourceCleaner;
    private final ReferenceCounter refCount = ReferenceCounter.onReleased(this::performRelease);
    @NotNull
    private final Indexing indexing;
    public static final WriteMarshallable INDEX_TEMPLATE;

    private SingleChronicleQueueStore(WireIn wire) {
        this.wireType = (WireType)wire.read((WireKey)MetaDataField.wireType).object(WireType.class);
        assert (this.wireType != null);
        this.bounds = (Bounds)wire.read((WireKey)MetaDataField.bounds).typedMarshallable();
        this.roll = (Roll)wire.read((WireKey)MetaDataField.roll).typedMarshallable();
        MappedBytes mappedBytes = (MappedBytes)wire.bytes();
        this.mappedFile = mappedBytes.mappedFile();
        this.indexing = (Indexing)wire.read((WireKey)MetaDataField.indexing).typedMarshallable();
    }

    SingleChronicleQueueStore(@Nullable RollCycle rollCycle, @NotNull WireType wireType, @NotNull MappedBytes mappedBytes, long rollEpoc) {
        this.roll = new Roll(rollCycle, rollEpoc, wireType);
        this.resourceCleaner = null;
        this.wireType = wireType;
        this.mappedFile = mappedBytes.mappedFile();
        this.indexing = new Indexing(wireType);
        this.bounds = new Bounds(wireType.newLongReference());
    }

    @Override
    public long writePosition() {
        return this.bounds.writePosition();
    }

    @Override
    public WireStore writePosition(long position) {
        this.bounds.writePosition(position);
        return this;
    }

    @Override
    public long cycle() {
        return this.roll.cycle();
    }

    SingleChronicleQueueStore cycle(long cycle) {
        this.roll.cycle(cycle);
        return this;
    }

    @Override
    public long epoch() {
        return this.roll.epoch();
    }

    @Override
    public long firstSequenceNumber() {
        return this.indexing.firstSequenceNumber();
    }

    @Override
    public long sequenceNumber() {
        return this.indexing.lastSequenceNumber();
    }

    @Override
    public boolean appendRollMeta(@NotNull Wire wire, long cycle) {
        if (!this.roll.casNextRollCycle(cycle)) {
            return false;
        }
        wire.writeDocument(true, d -> d.write((WireKey)MetaDataField.roll).int32(cycle));
        this.bounds.writePosition(wire.bytes().writePosition());
        return true;
    }

    @Override
    public long moveToIndex(@NotNull Wire wire, long index) {
        return this.indexing.moveToIndex(wire, index);
    }

    public void reserve() throws IllegalStateException {
        this.refCount.reserve();
    }

    public void release() throws IllegalStateException {
        this.refCount.release();
    }

    public long refCount() {
        return this.refCount.get();
    }

    @Override
    @NotNull
    public MappedBytes mappedBytes() {
        MappedBytes mappedBytes = new MappedBytes(this.mappedFile);
        mappedBytes.readPosition(0L);
        mappedBytes.writePosition(this.writePosition());
        return mappedBytes;
    }

    @Override
    public void storeIndexLocation(@NotNull Wire wire, long position, long sequenceNumber) {
        this.indexing.storeIndexLocation(wire, position, sequenceNumber);
    }

    private synchronized void performRelease() {
        try {
            if (this.resourceCleaner != null) {
                this.resourceCleaner.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void writeMarshallable(@NotNull WireOut wire) {
        wire.write((WireKey)MetaDataField.wireType).object((Object)this.wireType).write((WireKey)MetaDataField.bounds).typedMarshallable((WriteMarshallable)this.bounds).write((WireKey)MetaDataField.roll).typedMarshallable((WriteMarshallable)this.roll).write((WireKey)MetaDataField.indexing).typedMarshallable((WriteMarshallable)this.indexing);
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(Bounds.class, "Bounds");
        ClassAliasPool.CLASS_ALIASES.addAlias(Indexing.class, "Indexing");
        ClassAliasPool.CLASS_ALIASES.addAlias(Roll.class, "Roll");
        INDEX_TEMPLATE = w -> w.writeEventName(() -> "index").int64array(131072L);
    }

    static class Roll
    implements Demarshallable,
    WriteMarshallable {
        private final long epoch;
        private final int length;
        @Nullable
        private final String format;
        @Nullable
        private final ZoneId zoneId;
        @Nullable
        private final LongValue cycle;
        @Nullable
        private final LongValue nextCycle;
        @Nullable
        private final LongValue nextCycleMetaPosition;

        private Roll(WireIn wire) {
            this.nextCycleMetaPosition = wire.newLongReference();
            this.nextCycle = wire.newLongReference();
            this.cycle = wire.newLongReference();
            wire.read((WireKey)RollFields.cycle).int64(this.cycle, (Object)this, (o, i) -> o.cycle.setOrderedValue(i.getVolatileValue()));
            this.length = wire.read((WireKey)RollFields.length).int32();
            this.format = wire.read((WireKey)RollFields.format).text();
            this.zoneId = ZoneId.of(wire.read((WireKey)RollFields.timeZone).text());
            wire.read((WireKey)RollFields.nextCycle).int64(this.nextCycle, (Object)this, (o, i) -> o.nextCycle.setOrderedValue(i.getVolatileValue()));
            this.epoch = wire.read((WireKey)RollFields.epoch).int64();
            wire.read((WireKey)RollFields.nextCycleMetaPosition).int64(this.nextCycleMetaPosition, (Object)this, (o, i) -> o.nextCycleMetaPosition.setOrderedValue(i.getVolatileValue()));
        }

        Roll(@Nullable RollCycle rollCycle, long rollEpoch, WireType wireType) {
            this.length = rollCycle != null ? rollCycle.length() : -1;
            this.format = rollCycle != null ? rollCycle.format() : null;
            this.zoneId = rollCycle != null ? rollCycle.zone() : null;
            this.epoch = rollEpoch;
            this.cycle = (LongValue)wireType.newLongReference().get();
            this.nextCycle = (LongValue)wireType.newLongReference().get();
            this.nextCycleMetaPosition = (LongValue)wireType.newLongReference().get();
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            wire.write((WireKey)RollFields.cycle).int64forBinding(-1L, this.cycle).write((WireKey)RollFields.length).int32(this.length).write((WireKey)RollFields.format).text((CharSequence)this.format).write((WireKey)RollFields.timeZone).text((CharSequence)this.zoneId.getId()).write((WireKey)RollFields.nextCycle).int64forBinding(-1L, this.nextCycle).write((WireKey)RollFields.epoch).int64(this.epoch).write((WireKey)RollFields.nextCycleMetaPosition).int64forBinding(-1L, this.nextCycleMetaPosition);
        }

        public long epoch() {
            return this.epoch;
        }

        public long cycle() {
            return this.cycle.getVolatileValue();
        }

        @NotNull
        public Roll cycle(long rollCycle) {
            this.cycle.setOrderedValue(rollCycle);
            return this;
        }

        @NotNull
        public Roll nextCycleMetaPosition(long position) {
            this.nextCycleMetaPosition.setOrderedValue(position);
            return this;
        }

        public boolean casNextRollCycle(long rollCycle) {
            return this.nextCycle.compareAndSwapValue(-1L, rollCycle);
        }
    }

    static enum RollFields implements WireKey
    {
        cycle,
        length,
        format,
        timeZone,
        epoch,
        firstCycle,
        lastCycle,
        nextCycle,
        nextCycleMetaPosition;

    }

    static class Indexing
    implements Demarshallable,
    WriteMarshallable {
        private int indexCount = 131072;
        private int indexSpacing = 64;
        private final LongValue index2Index;
        private final LongValue lastSequenceNumber;
        private final LongValue firstIndex;
        private final ThreadLocal<LongArrayValues> longArray;

        private Indexing(@NotNull WireIn wire) {
            this.index2Index = wire.newLongReference();
            this.lastSequenceNumber = wire.newLongReference();
            this.firstIndex = wire.newLongReference();
            this.longArray = ThreadLocal.withInitial(() -> ((WireIn)wire).newLongArrayReference());
            wire.read((WireKey)IndexingFields.indexCount).int32((Object)this, (o, i) -> {
                o.indexCount = i;
            }).read((WireKey)IndexingFields.indexSpacing).int32((Object)this, (o, i) -> {
                o.indexSpacing = i;
            }).read((WireKey)IndexingFields.index2Index).int64(this.index2Index, (Object)this, (o, i) -> o.index2Index.setOrderedValue(i.getVolatileValue())).read((WireKey)IndexingFields.fistIndex).int64(this.firstIndex, (Object)this, (o, i) -> o.firstIndex.setOrderedValue(i.getVolatileValue())).read((WireKey)IndexingFields.lastIndex).int64(this.lastSequenceNumber, (Object)this, (o, i) -> o.lastSequenceNumber.setOrderedValue(i.getVolatileValue()));
        }

        Indexing(@NotNull WireType wireType) {
            this.index2Index = (LongValue)wireType.newLongReference().get();
            this.firstIndex = (LongValue)wireType.newLongReference().get();
            this.lastSequenceNumber = (LongValue)wireType.newLongReference().get();
            this.longArray = ThreadLocal.withInitial(wireType.newLongArrayReference());
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            wire.write((WireKey)IndexingFields.indexCount).int32(this.indexCount).write((WireKey)IndexingFields.indexSpacing).int32(this.indexSpacing).write((WireKey)IndexingFields.index2Index).int64forBinding(0L, this.index2Index).write((WireKey)IndexingFields.fistIndex).int64forBinding(-1L, this.firstIndex).write((WireKey)IndexingFields.lastIndex).int64forBinding(-1L, this.lastSequenceNumber);
        }

        public boolean lastSequenceNumber(long lastIndex) {
            long v = this.lastSequenceNumber.getVolatileValue();
            return v < lastIndex && this.lastSequenceNumber.compareAndSwapValue(v, lastIndex);
        }

        public long lastSequenceNumber() {
            if (this.lastSequenceNumber == null) {
                return 0L;
            }
            return this.lastSequenceNumber.getVolatileValue();
        }

        public long firstSequenceNumber() {
            if (this.index2Index.getVolatileValue() == 0L) {
                return -1L;
            }
            if (this.firstIndex == null) {
                return 0L;
            }
            return this.firstIndex.getVolatileValue();
        }

        long indexToIndex(@NotNull Wire wire) {
            while (true) {
                long index2Index;
                if ((index2Index = this.index2Index.getVolatileValue()) == Integer.MIN_VALUE) {
                    continue;
                }
                if (index2Index != 0L) {
                    return index2Index;
                }
                if (this.index2Index.compareAndSwapValue(0L, Integer.MIN_VALUE)) break;
            }
            long index = this.newIndex(wire);
            this.index2Index.setOrderedValue(index);
            return index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void storeIndexLocation(@NotNull Wire wire, long address, long sequenceNumber) {
            this.lastSequenceNumber(sequenceNumber);
            long writePosition = wire.bytes().writePosition();
            try {
                if (sequenceNumber % 64L != 0L) {
                    return;
                }
                LongArrayValues array = this.longArray.get();
                long indexToIndex0 = this.indexToIndex(wire);
                try (DocumentContext context = wire.readingDocument(indexToIndex0);){
                    long primaryOffset;
                    if (!context.isPresent()) {
                        throw new IllegalStateException("document not found");
                    }
                    if (!context.isMetaData()) {
                        throw new IllegalStateException("sequenceNumber not found");
                    }
                    LongArrayValues primaryIndex = this.array((WireIn)wire, array);
                    long secondaryAddress = primaryIndex.getValueAt(primaryOffset = IndexOffset.toAddress0(sequenceNumber));
                    if (secondaryAddress == 0L) {
                        secondaryAddress = this.newIndex(wire);
                        writePosition = Math.max(writePosition, wire.bytes().writePosition());
                        primaryIndex.setValueAt(primaryOffset, secondaryAddress);
                    }
                    Bytes bytes = wire.bytes();
                    bytes.readLimit(bytes.capacity());
                    try (DocumentContext context0 = wire.readingDocument(secondaryAddress);){
                        LongArrayValues array1 = this.array((WireIn)wire, array);
                        if (!context0.isPresent()) {
                            throw new IllegalStateException("document not found");
                        }
                        if (!context0.isMetaData()) {
                            throw new IllegalStateException("sequenceNumber not found");
                        }
                        array1.setValueAt(IndexOffset.toAddress1(sequenceNumber), address);
                    }
                }
            }
            finally {
                wire.bytes().writePosition(writePosition);
            }
        }

        @NotNull
        private LongArrayValues array(@NotNull WireIn w, @NotNull LongArrayValues using) {
            StringBuilder sb = Wires.acquireStringBuilder();
            ValueIn valueIn = w.readEventName(sb);
            if (!"index".contentEquals(sb)) {
                throw new IllegalStateException("expecting index");
            }
            valueIn.int64array(using, (Object)this, (o1, o2) -> {});
            return using;
        }

        long newIndex(@NotNull Wire wire) {
            long position;
            while ((position = WireInternal.writeWireOrAdvanceIfNotEmpty((WireOut)wire, (boolean)true, (WriteMarshallable)INDEX_TEMPLATE)) <= 0L) {
            }
            return position;
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public long moveToIndex(@NotNull Wire wire, long index) {
            block46: {
                array = this.longArray.get();
                bytes = wire.bytes();
                indexToIndex0 = this.indexToIndex(wire);
                readPosition = bytes.readPosition();
                ((Bytes)bytes.readLimit(bytes.capacity())).readPosition(indexToIndex0);
                startIndex = index / 64L * 64L;
                documentContext0 = wire.readingDocument();
                var13_9 = null;
                try {
                    if (!documentContext0.isPresent()) {
                        throw new IllegalStateException("document is not present");
                    }
                    if (documentContext0.isData()) {
                        throw new IllegalStateException("Invalid index, expecting and index at pos=" + indexToIndex0 + ", but found data instead.");
                    }
                    primaryIndex = this.array((WireIn)wire, array);
                    primaryOffset = IndexOffset.toAddress0(index);
                    while (true) {
                        block44: {
                            block43: {
                                block45: {
                                    secondaryAddress = primaryIndex.getValueAt(primaryOffset);
                                    if (secondaryAddress == 0L) {
                                        startIndex -= 0x800000L;
                                        --primaryOffset;
                                    }
                                    bytes.readLimit(bytes.capacity());
                                    bytes.readPosition(secondaryAddress);
                                    documentContext1 = wire.readingDocument();
                                    var20_16 = null;
                                    try {
                                        if (!documentContext1.isPresent()) {
                                            throw new IllegalStateException("document is not present");
                                        }
                                        if (!documentContext1.isData()) break block43;
                                        if (documentContext1 == null) break block44;
                                        if (var20_16 == null) break block45;
                                    }
                                    catch (Throwable var21_20) {
                                        var20_16 = var21_20;
                                        throw var21_20;
                                    }
                                    catch (Throwable var29_29) {
                                        throw var29_29;
                                    }
                                    try {
                                        documentContext1.close();
                                    }
                                    catch (Throwable var21_17) {
                                        var20_16.addSuppressed(var21_17);
                                    }
                                }
                                documentContext1.close();
                            }
                            ** try [egrp 3[TRYBLOCK] [7, 11 : 304->365)] { 
lbl52:
                            // 1 sources

                            array1 = this.array((WireIn)wire, array);
                            secondaryOffset = IndexOffset.toAddress1(index);
                            while ((fromAddress = array1.getValueAt(secondaryOffset)) == 0L) {
                                startIndex -= 64L;
                                if (--secondaryOffset >= 0L) continue;
                                break block46;
                            }
                            if (index == startIndex) {
                                var26_23 = fromAddress;
                                return var26_23;
                            }
                            bytes.readLimit(bytes.realCapacity());
                            var26_24 = this.linearScan(wire, index, startIndex, fromAddress);
                            return var26_24;
lbl65:
                            // 1 sources

                            finally {
                                if (documentContext1 != null) {
                                    if (var20_16 != null) {
                                        try {
                                            documentContext1.close();
                                        }
                                        catch (Throwable var28_25) {
                                            var20_16.addSuppressed(var28_25);
                                        }
                                    } else {
                                        documentContext1.close();
                                    }
                                }
                            }
                        }
                        break;
                    }
                }
                catch (Throwable var14_12) {
                    var13_9 = var14_12;
                    throw var14_12;
                }
                finally {
                    if (primaryOffset >= 0L) ** continue;
                }
            }
            bytes.readPosition(readPosition);
            return -1L;
        }

        private long linearScan(@NotNull Wire context, long toIndex, long fromKnownIndex, long knownAddress) {
            Bytes bytes = context.bytes();
            long p = bytes.readPosition();
            long l = bytes.readLimit();
            bytes.readLimit(bytes.capacity());
            bytes.readPosition(knownAddress);
            long i = fromKnownIndex;
            while (bytes.readRemaining() > 0L) {
                while (!Wires.isReady((long)bytes.readVolatileInt(bytes.readPosition()))) {
                    Thread.yield();
                }
                DocumentContext documentContext = context.readingDocument();
                Throwable throwable = null;
                try {
                    if (!documentContext.isPresent()) {
                        long l2 = -1L;
                        return l2;
                    }
                    if (!documentContext.isData()) continue;
                    if (toIndex == i) {
                        context.bytes().readSkip(-4L);
                        long l3 = context.bytes().readPosition();
                        return l3;
                    }
                    ++i;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (documentContext == null) continue;
                    if (throwable != null) {
                        try {
                            documentContext.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    documentContext.close();
                }
            }
            ((Bytes)bytes.readLimit(l)).readPosition(p);
            return -1L;
        }
    }

    public static enum IndexOffset {


        public static long toAddress0(long index) {
            long siftedIndex = index >> 23;
            long mask = 131071L;
            long maskedShiftedIndex = mask & siftedIndex;
            return maskedShiftedIndex * 8L;
        }

        public static long toAddress1(long index) {
            long siftedIndex = index >> 6;
            long mask = 131071L;
            return mask & siftedIndex;
        }

        @NotNull
        public static String toBinaryString(long i) {
            StringBuilder sb = new StringBuilder();
            for (int n = 63; n >= 0; --n) {
                sb.append((i & 1L << n) != 0L ? "1" : "0");
            }
            return sb.toString();
        }

        @NotNull
        public static String toScale() {
            int n;
            StringBuilder units = new StringBuilder();
            StringBuilder tens = new StringBuilder();
            for (n = 64; n >= 1; --n) {
                units.append(0 == n % 10 ? "|" : Integer.valueOf(n % 10));
            }
            for (n = 64; n >= 1; --n) {
                tens.append(0 == n % 10 ? Integer.valueOf(n / 10) : " ");
            }
            return units.toString() + "\n" + tens.toString();
        }
    }

    static enum IndexingFields implements WireKey
    {
        indexCount,
        indexSpacing,
        index2Index,
        fistIndex,
        lastIndex;

    }

    static class Bounds
    implements Demarshallable,
    WriteMarshallable {
        @Nullable
        private final LongValue writePosition;
        @Nullable
        private final LongValue readPosition;

        private Bounds(WireIn wire) {
            this.writePosition = wire.newLongReference();
            this.readPosition = wire.newLongReference();
            wire.read((WireKey)BoundsField.writePosition).int64(this.writePosition).read((WireKey)BoundsField.readPosition).int64(this.readPosition);
        }

        Bounds(Supplier<LongValue> supplier) {
            this.writePosition = supplier.get();
            this.readPosition = supplier.get();
        }

        public void writeMarshallable(@NotNull WireOut wire) {
            wire.write((WireKey)BoundsField.writePosition).int64forBinding(0L, this.writePosition).write((WireKey)BoundsField.readPosition).int64forBinding(0L, this.readPosition);
        }

        public long readPosition() {
            return this.readPosition.getVolatileValue();
        }

        public void readPosition(long position) {
            this.readPosition.setOrderedValue(position);
        }

        public long writePosition() {
            return this.writePosition.getVolatileValue();
        }

        public void writePosition(long writePosition) {
            long wp;
            while (writePosition > (wp = this.writePosition())) {
                if (!this.writePosition.compareAndSwapValue(wp, writePosition)) continue;
                return;
            }
        }

        public String toString() {
            return "Bounds{writePosition=" + this.writePosition + ", readPosition=" + this.readPosition + '}';
        }
    }

    static enum BoundsField implements WireKey
    {
        writePosition,
        readPosition;

    }

    static enum MetaDataField implements WireKey
    {
        bounds,
        indexing,
        roll,
        wireType;

    }
}

