/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.ParseException;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.BytesRingBuffer;
import net.openhft.chronicle.bytes.BytesRingBufferStats;
import net.openhft.chronicle.bytes.MappedBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.pool.ClassAliasPool;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.RollCycle;
import net.openhft.chronicle.queue.RollDateCache;
import net.openhft.chronicle.queue.impl.AbstractChronicleQueue;
import net.openhft.chronicle.queue.impl.Excerpts;
import net.openhft.chronicle.queue.impl.WireStore;
import net.openhft.chronicle.queue.impl.WireStorePool;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueBuilder;
import net.openhft.chronicle.queue.impl.single.SingleChronicleQueueStore;
import net.openhft.chronicle.threads.api.EventLoop;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WiredBytes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SingleChronicleQueue
extends AbstractChronicleQueue {
    private static final String SUFFIX = ".cq4";
    @NotNull
    private final SingleChronicleQueueBuilder builder;
    @NotNull
    private final RollCycle cycle;
    @NotNull
    private final RollDateCache dateCache;
    @NotNull
    private final WireStorePool pool;
    private final boolean bufferedAppends;
    private final long epoch;
    @Nullable
    private final EventLoop eventloop;
    private final Consumer<BytesRingBufferStats> onRingBufferStats;

    SingleChronicleQueue(@NotNull SingleChronicleQueueBuilder builder) {
        this.cycle = builder.rollCycle();
        this.dateCache = new RollDateCache(this.cycle);
        this.builder = builder;
        this.pool = WireStorePool.withSupplier(this::acquireStore);
        this.storeForCycle(this.cycle(), builder.epoch());
        this.epoch = builder.epoch();
        this.bufferedAppends = builder.buffered();
        this.eventloop = builder.eventLoop();
        this.onRingBufferStats = builder.onRingBufferStats();
    }

    @Override
    public long epoch() {
        return this.epoch;
    }

    @Override
    @NotNull
    public ExcerptAppender createAppender() {
        Excerpts.StoreAppender storeAppender = new Excerpts.StoreAppender(this);
        if (this.bufferedAppends) {
            long ringBufferCapacity = BytesRingBuffer.sizeFor((long)this.builder.bufferCapacity());
            return new Excerpts.BufferedAppender(this.eventloop, storeAppender, ringBufferCapacity, this.onRingBufferStats);
        }
        return storeAppender;
    }

    @Override
    @NotNull
    public ExcerptTailer createTailer() throws IOException {
        return new Excerpts.StoreTailer(this);
    }

    @Override
    @NotNull
    protected WireStore storeForCycle(long cycle, long epoch) {
        return this.pool.acquire(cycle, epoch);
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    protected void release(@NotNull WireStore store) {
        this.pool.release(store);
    }

    @Override
    protected long cycle() {
        return this.cycle.current(this.builder.epoch());
    }

    @Override
    public long firstIndex() {
        long cycle = this.firstCycle();
        if (cycle == -1L) {
            return -1L;
        }
        WireStore store = this.acquireStore(cycle, this.epoch());
        long sequenceNumber = store.firstSequenceNumber();
        return ChronicleQueue.index(store.cycle(), sequenceNumber);
    }

    private long firstCycle() {
        long firstCycle = -1L;
        String basePath = this.builder.path().getAbsolutePath();
        File[] files = this.builder.path().listFiles();
        if (files != null && files.length > 0) {
            long firstDate = Long.MAX_VALUE;
            for (int i = files.length - 1; i >= 0; --i) {
                try {
                    String name = files[i].getAbsolutePath();
                    if (!name.endsWith(SUFFIX)) continue;
                    name = name.substring(basePath.length() + 1);
                    long date = this.dateCache.parseCount(name = name.substring(0, name.indexOf(46)));
                    if (firstDate <= date) continue;
                    firstDate = date;
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            firstCycle = firstDate;
        }
        if (firstCycle == Long.MAX_VALUE) {
            return -1L;
        }
        return firstCycle;
    }

    @Override
    public long lastIndex() {
        long lastCycle = this.lastCycle();
        if (lastCycle == -1L) {
            return -1L;
        }
        long lastSequenceNumber = this.acquireStore(lastCycle, this.epoch()).sequenceNumber();
        return ChronicleQueue.index(lastCycle, lastSequenceNumber);
    }

    private long lastCycle() {
        String basePath = this.builder.path().getAbsolutePath();
        File[] files = this.builder.path().listFiles();
        if (files != null && files.length > 0) {
            long lastDate = Long.MIN_VALUE;
            for (int i = files.length - 1; i >= 0; --i) {
                try {
                    String name = files[i].getAbsolutePath();
                    if (!name.endsWith(SUFFIX)) continue;
                    name = name.substring(basePath.length() + 1);
                    long date = this.dateCache.parseCount(name = name.substring(0, name.indexOf(46)));
                    if (lastDate >= date) continue;
                    lastDate = date;
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            return lastDate;
        }
        return -1L;
    }

    @Override
    @NotNull
    public WireType wireType() {
        return this.builder.wireType();
    }

    @NotNull
    private WireStore acquireStore(long cycle, long epoch) {
        File parentFile;
        String cycleFormat = this.dateCache.formatFor(cycle);
        File cycleFile = new File(this.builder.path(), cycleFormat + SUFFIX);
        Function<File, MappedBytes> toMappedBytes = file -> {
            try {
                long chunkSize = OS.pageAlign((long)this.builder.blockSize());
                long overlapSize = OS.pageAlign((long)(this.builder.blockSize() / 4L));
                return MappedBytes.mappedBytes((File)file, (long)chunkSize, (long)overlapSize);
            }
            catch (FileNotFoundException e) {
                throw Jvm.rethrow((Throwable)e);
            }
        };
        if (cycleFile.exists()) {
            MappedBytes bytes = toMappedBytes.apply(cycleFile);
            Wire wire = (Wire)this.builder.wireType().apply((Object)bytes);
            try (DocumentContext context = wire.readingDocument();){
                if (context.isPresent() && context.isMetaData()) {
                    WireStore wireStore = (WireStore)wire.getValueIn().typedMarshallable();
                    return wireStore;
                }
            }
        }
        if ((parentFile = cycleFile.getParentFile()) != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        Consumer<WiredBytes> consumer = ws -> ((WireStore)ws.delegate()).install(ws.headerLength(), ws.headerCreated(), cycle, this.builder);
        Function<MappedBytes, WireStore> supplyStore = mappedBytes -> new SingleChronicleQueueStore(this.builder.rollCycle(), this.builder.wireType(), (MappedBytes)mappedBytes, epoch);
        return (WireStore)WiredBytes.build((File)cycleFile, toMappedBytes, (WireType)this.builder.wireType(), supplyStore, consumer).delegate();
    }

    static {
        ClassAliasPool.CLASS_ALIASES.addAlias(SingleChronicleQueueStore.class, "WireStore");
    }
}

