/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.ZoneId;
import java.util.Date;
import java.util.TimeZone;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.queue.RollCycle;
import org.jetbrains.annotations.NotNull;

public class RollDateCache {
    private static final int SIZE = 32;
    @NotNull
    private final DateFormat formatter;
    @NotNull
    private final DateValue[] values;
    private final int length;

    public RollDateCache(@NotNull RollCycle cycle) {
        this(cycle.length(), cycle.format(), cycle.zone());
    }

    private RollDateCache(int length, @NotNull String format, @NotNull ZoneId zoneId) {
        this.length = length;
        this.values = new DateValue[32];
        this.formatter = new SimpleDateFormat(format);
        this.formatter.setTimeZone(TimeZone.getTimeZone(zoneId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String formatFor(long cycle) {
        long millis = cycle * (long)this.length;
        int hash = Maths.hash32((long)millis) & 0x1F;
        DateValue dv = this.values[hash];
        if (dv == null || dv.millis != millis) {
            DateFormat dateFormat = this.formatter;
            synchronized (dateFormat) {
                String text = this.formatter.format(new Date(millis));
                this.values[hash] = new DateValue(millis, text);
                return text;
            }
        }
        return dv.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long parseCount(@NotNull String name) throws ParseException {
        DateFormat dateFormat = this.formatter;
        synchronized (dateFormat) {
            return this.formatter.parse(name).getTime() / (long)this.length;
        }
    }

    static class DateValue {
        final long millis;
        final String text;

        DateValue(long millis, String text) {
            this.millis = millis;
            this.text = text;
        }
    }
}

