/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single.work.in.progress;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import net.openhft.chronicle.bytes.VanillaBytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.values.LongArrayValues;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptTailer;
import net.openhft.chronicle.queue.impl.single.work.in.progress.AbstractChronicle;
import net.openhft.chronicle.queue.impl.single.work.in.progress.IndexedSingleChronicleQueue;
import net.openhft.chronicle.queue.impl.single.work.in.progress.Indexer;
import net.openhft.chronicle.wire.ByteableLongArrayValues;
import net.openhft.chronicle.wire.ReadMarshallable;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public class SingleTailer
implements ExcerptTailer {
    @NotNull
    private final IndexedSingleChronicleQueue chronicle;
    private final VanillaBytes bytes = new VanillaBytes((BytesStore)Bytes.elasticByteBuffer());
    private final Wire wire;
    LongArrayValues values = null;
    private long index;
    private ThreadLocal<ByteableLongArrayValues> value;

    public SingleTailer(@NotNull AbstractChronicle chronicle, @NotNull Function<Bytes, Wire> wireProvider, WireType wireType) {
        this.chronicle = (IndexedSingleChronicleQueue)chronicle;
        this.wire = wireProvider.apply((Bytes)this.bytes);
        this.value = Indexer.newLongArrayValuesPool(wireType);
        this.toStart();
    }

    public boolean readDocument(Consumer<WireIn> reader) {
        return this.wire.readDocument(null, wire1 -> reader.accept(wire1));
    }

    @Override
    public boolean readDocument(@NotNull ReadMarshallable reader) throws IOException {
        throw new UnsupportedOperationException("todo");
    }

    @Override
    public long index() {
        return 0L;
    }

    @Override
    public long cycle() {
        return 0L;
    }

    @Override
    public boolean index(long index) {
        long lastKnownIndex;
        assert (this.bytes.capacity() > 0L);
        long writeByte = this.chronicle.header.getWriteByte();
        assert (this.bytes.capacity() > 0L);
        assert (this.bytes.capacity() > 0L);
        long pos = this.bytes.readPosition();
        long start = 0L;
        long address = 0L;
        long index2index = this.chronicle.indexToIndex();
        assert (index2index != 0L);
        long address1 = this.readIndexAt(index2index, Indexer.IndexOffset.toAddress0(index));
        if (address1 != 0L) {
            long address2 = this.readIndexAt(address1, Indexer.IndexOffset.toAddress1(index));
            if (address2 != 0L) {
                this.wire.bytes().readPosition(address2);
                start = index / 64L * 64L;
                address = address2;
            } else {
                lastKnownIndex = start;
                long lastKnownAddress = this.chronicle.firstBytes();
                for (long count = 0L; count < 131072L; ++count) {
                    address = this.readIndexAt(address1, count);
                    if (address != 0L) {
                        if (count <= 0L) continue;
                        lastKnownIndex += 0x800000L;
                        lastKnownAddress = address;
                        continue;
                    }
                    start = lastKnownIndex;
                    address = lastKnownAddress;
                    break;
                }
            }
        } else {
            lastKnownIndex = 0L;
            for (long count = 0L; count < 131072L; ++count) {
                address = this.readIndexAt(this.chronicle.indexToIndex(), count);
                if (address != 0L) {
                    if (count <= 0L) continue;
                    lastKnownIndex += 64L;
                    continue;
                }
                start = lastKnownIndex;
                break;
            }
        }
        assert (this.bytes.capacity() > 0L);
        if (address != 0L) {
            this.bytes.readPosition(address);
        } else {
            this.bytes.readPosition(512L);
        }
        this.bytes.readLimit(writeByte);
        long last = this.chronicle.lastIndex();
        for (long i = start; i < last; ++i) {
            long j = i;
            if (index == j) {
                return true;
            }
            try {
                this.readDocument(wire -> {});
                continue;
            }
            catch (IOException e) {
                Jvm.rethrow((Throwable)e);
            }
        }
        this.wire.bytes().readPosition(pos);
        return false;
    }

    @Override
    public boolean index(long cycle, long index) throws IOException {
        return false;
    }

    @Override
    @NotNull
    public ExcerptTailer toStart() {
        this.index = -1L;
        this.chronicle.index(-1L, this.bytes);
        return this;
    }

    @Override
    @NotNull
    public ExcerptTailer toEnd() {
        this.index(this.chronicle.lastIndex());
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long readIndexAt(long offset, long index) {
        if (offset == 0L) {
            return 0L;
        }
        long pos = this.chronicle.bytes().readPosition();
        try {
            long[] result = new long[1];
            this.chronicle.bytes().readPosition(offset);
            this.chronicle.wire.readDocument(wireIn -> {
                wireIn.read(() -> "index").int64array(this.values, (Object)this, (o, v) -> {
                    o.values = v;
                });
                lArray[0] = this.values.getVolatileValueAt(index);
            }, null);
            long l = result[0];
            return l;
        }
        finally {
            this.chronicle.bytes().readPosition(pos);
        }
    }

    @Override
    public ChronicleQueue queue() {
        return this.chronicle;
    }
}

