/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.single.work.in.progress;

import java.io.IOException;
import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.NativeBytes;
import net.openhft.chronicle.queue.ChronicleQueue;
import net.openhft.chronicle.queue.ExcerptAppender;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class SingleAppender
implements ExcerptAppender {
    @NotNull
    private final ChronicleQueue chronicle;
    private final Bytes buffer = NativeBytes.nativeBytes();
    private final Wire wire;
    private long lastWrittenIndex = -1L;

    public SingleAppender(ChronicleQueue chronicle, Function<Bytes, Wire> bytesToWire) {
        this.chronicle = chronicle;
        this.wire = bytesToWire.apply(this.buffer);
    }

    @Override
    public long writeDocument(WriteMarshallable writer) throws IOException {
        this.buffer.clear();
        writer.writeMarshallable((WireOut)this.wire);
        return this.lastWrittenIndex;
    }

    @Override
    public long index() {
        if (this.lastWrittenIndex == -1L) {
            String message = "No document has been written using this appender, so the lastWrittenIndex() is not available.";
            throw new IllegalStateException(message);
        }
        return this.lastWrittenIndex;
    }

    @Override
    public long cycle() {
        return -1L;
    }

    @NotNull
    public ChronicleQueue chronicle() {
        return this.chronicle;
    }

    @Override
    public ChronicleQueue queue() {
        return this.chronicle;
    }
}

