/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.queue.impl.ringbuffer;

import java.nio.ByteOrder;
import java.util.concurrent.atomic.AtomicLong;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesStore;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BytesRingBuffer {
    private static final int SIZE = 8;
    private static final int LOCKED = -1;
    private static final int FLAG = 1;
    @NotNull
    private final RingBuffer bytes;
    @NotNull
    private final Header header;

    public BytesRingBuffer(@NotNull Bytes buffer) {
        this.header = new Header(buffer);
        BytesStore bytesStore = buffer.bytesStore().subBytes(buffer.writePosition() + 1L, buffer.capacity());
        this.bytes = new RingBuffer(bytesStore.bytesForWrite());
        this.header.setWriteUpTo(this.bytes.capacity());
    }

    public boolean offer(@NotNull Bytes bytes0) throws InterruptedException {
        bytes0.readLimit(bytes0.writeLimit());
        try {
            long flagLoc;
            long offset;
            long len;
            while (true) {
                long writeLocation = this.writeLocation();
                assert (writeLocation >= 0L);
                if (Thread.currentThread().isInterrupted()) {
                    throw new InterruptedException();
                }
                if (this.remainingForWrite(writeLocation) < bytes0.readRemaining() + 8L + 1L) {
                    return false;
                }
                len = bytes0.readLimit();
                long messageLen = 9L + len;
                offset = writeLocation;
                if (!this.header.compareAndSetWriteLocation(writeLocation, -1L)) continue;
                flagLoc = offset;
                offset = this.bytes.writeByte(offset, States.BUSY.ordinal());
                if (this.header.compareAndSetWriteLocation(-1L, writeLocation + messageLen)) break;
            }
            offset = this.bytes.write(offset, len);
            this.bytes.write(offset, bytes0);
            this.bytes.writeByte(flagLoc, States.READY.ordinal());
            return true;
        }
        catch (IllegalStateException e) {
            return false;
        }
    }

    private long writeLocation() {
        long writeLocation;
        while ((writeLocation = this.header.getWriteLocation()) == -1L) {
        }
        return writeLocation;
    }

    private long remainingForWrite(long offset) {
        return this.header.getWriteUpTo() - 1L - offset;
    }

    @NotNull
    public Bytes take(@NotNull BytesProvider bytesProvider) throws InterruptedException, IllegalStateException {
        Bytes poll;
        while ((poll = this.poll(bytesProvider)) == null) {
        }
        return poll;
    }

    @Nullable
    public Bytes poll(@NotNull BytesProvider bytesProvider) throws InterruptedException, IllegalStateException {
        long flag;
        byte state;
        long writeLoc = this.writeLocation();
        long offset = this.header.getReadLocation();
        long readLocation = offset;
        if (readLocation >= writeLoc) {
            return null;
        }
        assert (readLocation <= writeLoc) : "reader has go ahead of the writer";
        if ((state = this.bytes.readByte(flag = offset++)) == States.BUSY.ordinal()) {
            return null;
        }
        assert (state == States.READY.ordinal()) : " we are reading a message that we shouldn't,  state=" + state;
        long elementSize = this.bytes.readLong(offset);
        long next = (offset += 8L) + elementSize;
        Bytes using = bytesProvider.provide(elementSize);
        BytesRingBuffer.checkSize(using, elementSize);
        this.bytes.read(using, offset, elementSize);
        this.bytes.write(flag, States.USED.ordinal());
        this.header.setWriteUpTo(next + this.bytes.capacity());
        this.header.setReadLocation(next);
        return using;
    }

    private static void checkSize(@NotNull Bytes using, long elementSize) {
        if (using.writeRemaining() < elementSize) {
            throw new IllegalStateException("requires size=" + elementSize + " bytes, but only " + using.readRemaining() + " remaining.");
        }
    }

    private class RingBuffer {
        @NotNull
        final Bytes buffer;
        final boolean isBytesBigEndian;

        public RingBuffer(Bytes buffer) {
            this.buffer = buffer;
            this.isBytesBigEndian = buffer.byteOrder() == ByteOrder.BIG_ENDIAN;
        }

        private long write(long offset, @NotNull Bytes bytes0) {
            long len;
            long result = offset + bytes0.writeRemaining();
            long endOffSet = this.nextOffset(offset %= this.capacity(), len = bytes0.writeRemaining());
            if (endOffSet >= offset) {
                this.buffer.write(offset, bytes0);
                return result;
            }
            long limit = bytes0.writeLimit();
            bytes0.writeLimit(this.capacity() - offset);
            this.buffer.write(offset, bytes0);
            bytes0.writePosition(bytes0.writeLimit());
            bytes0.writeLimit(limit);
            this.buffer.write(0L, bytes0);
            return result;
        }

        long capacity() {
            return this.buffer.capacity();
        }

        long nextOffset(long offset, long increment) {
            long result = offset + increment;
            if (result < this.capacity()) {
                return result;
            }
            return result % this.capacity();
        }

        private long write(long offset, long value) {
            long result = offset + 8L;
            if (this.nextOffset(offset %= this.capacity(), 8L) > offset) {
                this.buffer.writeLong(offset, value);
            } else if (this.isBytesBigEndian) {
                this.putLongB(offset, value);
            } else {
                this.putLongL(offset, value);
            }
            return result;
        }

        public long writeByte(long l, int i) {
            this.buffer.writeByte(l % this.capacity(), i);
            return l + 1L;
        }

        private long read(@NotNull Bytes bytes, long offset, long len) {
            long endOffSet = this.nextOffset(offset %= this.capacity(), len);
            if (endOffSet >= offset) {
                bytes.write((BytesStore)this.buffer, offset, len);
                return endOffSet;
            }
            bytes.write((BytesStore)this.buffer, offset, len);
            bytes.write((BytesStore)this.buffer, 0L, len);
            return endOffSet;
        }

        long readLong(long offset) {
            long l;
            if (this.nextOffset(offset %= this.capacity(), 8L) > offset) {
                return this.buffer.readLong(offset);
            }
            if (this.isBytesBigEndian) {
                byte by = this.buffer.readByte(offset);
                long l2 = this.nextOffset(offset);
                offset = l2;
                long l3 = this.nextOffset(offset);
                offset = l3;
                long l4 = this.nextOffset(offset);
                offset = l4;
                long l5 = this.nextOffset(offset);
                offset = l5;
                long l6 = this.nextOffset(offset);
                offset = l6;
                offset = this.nextOffset(offset);
                l = this.makeLong(by, this.buffer.readByte(l2), this.buffer.readByte(l3), this.buffer.readByte(l4), this.buffer.readByte(l5), this.buffer.readByte(l6), this.buffer.readByte(offset), this.buffer.readByte(this.nextOffset(offset)));
            } else {
                l = this.makeLong(this.buffer.readByte(this.nextOffset(offset, 7L)), this.buffer.readByte(this.nextOffset(offset, 6L)), this.buffer.readByte(this.nextOffset(offset, 5L)), this.buffer.readByte(this.nextOffset(offset, 4L)), this.buffer.readByte(this.nextOffset(offset, 3L)), this.buffer.readByte(this.nextOffset(offset, 2L)), this.buffer.readByte(this.nextOffset(offset)), this.buffer.readByte(offset));
            }
            return l;
        }

        private long makeLong(byte b7, byte b6, byte b5, byte b4, byte b3, byte b2, byte b1, byte b0) {
            return (long)b7 << 56 | ((long)b6 & 0xFFL) << 48 | ((long)b5 & 0xFFL) << 40 | ((long)b4 & 0xFFL) << 32 | ((long)b3 & 0xFFL) << 24 | ((long)b2 & 0xFFL) << 16 | ((long)b1 & 0xFFL) << 8 | (long)b0 & 0xFFL;
        }

        long nextOffset(long offset) {
            return this.nextOffset(offset, 1L);
        }

        public byte readByte(long l) {
            this.buffer.readLimit(this.buffer.capacity());
            return this.buffer.readByte(l % this.capacity());
        }

        void putLongB(long offset, long value) {
            this.buffer.writeByte(offset, (byte)(value >> 56));
            offset = this.nextOffset(offset);
            this.buffer.writeByte(offset, (byte)(value >> 48));
            offset = this.nextOffset(offset);
            this.buffer.writeByte(offset, (byte)(value >> 40));
            offset = this.nextOffset(offset);
            this.buffer.writeByte(offset, (byte)(value >> 32));
            offset = this.nextOffset(offset);
            this.buffer.writeByte(offset, (byte)(value >> 24));
            offset = this.nextOffset(offset);
            this.buffer.writeByte(offset, (byte)(value >> 16));
            offset = this.nextOffset(offset);
            this.buffer.writeByte(offset, (byte)(value >> 8));
            this.buffer.writeByte(this.nextOffset(offset), (byte)value);
        }

        void putLongL(long offset, long value) {
            this.buffer.writeByte(offset, (byte)value);
            offset = this.nextOffset(offset);
            this.buffer.writeByte(offset, (byte)(value >> 8));
            offset = this.nextOffset(offset);
            this.buffer.writeByte(offset, (byte)(value >> 16));
            offset = this.nextOffset(offset);
            this.buffer.writeByte(offset, (byte)(value >> 24));
            offset = this.nextOffset(offset);
            this.buffer.writeByte(offset, (byte)(value >> 32));
            offset = this.nextOffset(offset);
            this.buffer.writeByte(offset, (byte)(value >> 40));
            offset = this.nextOffset(offset);
            this.buffer.writeByte(offset, (byte)(value >> 48));
            this.buffer.writeByte(this.nextOffset(offset), (byte)(value >> 56));
        }
    }

    private class Header {
        private final long writeLocationOffset;
        private final long writeUpToOffset;
        private final long readLocationOffset;
        private final Bytes buffer;
        final AtomicLong writeLocationAtomic = new AtomicLong();
        final AtomicLong readLocationAtomic = new AtomicLong();
        final AtomicLong writeUpToOffsetAtomic = new AtomicLong();

        private Header(Bytes buffer) {
            if (buffer.writeRemaining() < 24L) {
                String message = "buffer too small, buffer size=" + buffer.writeRemaining();
                throw new IllegalStateException(message);
            }
            this.readLocationOffset = buffer.writePosition();
            buffer.writeLong(8L);
            this.writeLocationOffset = buffer.writePosition();
            buffer.writeSkip(8L);
            this.writeUpToOffset = buffer.writePosition();
            buffer.writeSkip(8L);
            this.buffer = buffer;
        }

        boolean compareAndSetWriteLocation(long expectedValue, long newValue) {
            return this.writeLocationAtomic.compareAndSet(expectedValue, newValue);
        }

        long getWriteLocation() {
            return this.writeLocationAtomic.get();
        }

        long getWriteUpTo() {
            return this.writeUpToOffsetAtomic.get();
        }

        void setWriteUpTo(long value) {
            this.writeUpToOffsetAtomic.set(value);
        }

        long getReadLocation() {
            return this.readLocationAtomic.get();
        }

        void setReadLocation(long value) {
            this.readLocationAtomic.set(value);
        }

        public String toString() {
            return "Header{writeLocation=" + this.buffer.readVolatileLong(this.writeLocationOffset) + ", writeUpTo=" + this.buffer.readVolatileLong(this.writeUpToOffset) + ", readLocation=" + this.buffer.readVolatileLong(this.readLocationOffset) + "}";
        }
    }

    public static interface BytesProvider {
        @NotNull
        public Bytes provide(long var1);
    }

    private static enum States {
        BUSY,
        READY,
        USED;

    }
}

