/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketOption;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.tcp.ChronicleServerSocket;
import net.openhft.chronicle.network.tcp.ChronicleServerSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannelFactory;

public class VanillaChronicleServerSocketChannel
implements ChronicleServerSocketChannel {
    final ServerSocketChannel ssc;
    private String hostPort;

    public VanillaChronicleServerSocketChannel() {
        try {
            this.ssc = ServerSocketChannel.open();
            this.hostPort = this.ssc.getLocalAddress().toString();
        }
        catch (IOException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    public VanillaChronicleServerSocketChannel(String hostPort) {
        try {
            this.ssc = ServerSocketChannel.open();
            this.hostPort = hostPort;
        }
        catch (IOException e) {
            throw Jvm.rethrow((Throwable)e);
        }
    }

    @Override
    public ChronicleSocketChannel accept() throws IOException {
        this.ssc.configureBlocking(true);
        SocketChannel accept = this.ssc.accept();
        return ChronicleSocketChannelFactory.wrap(accept);
    }

    @Override
    public boolean isOpen() {
        return this.ssc.isOpen();
    }

    @Override
    public ChronicleServerSocket socket() {
        return new ChronicleServerSocket(){

            @Override
            public int getLocalPort() {
                return VanillaChronicleServerSocketChannel.this.ssc.socket().getLocalPort();
            }

            @Override
            public void close() {
                Closeable.closeQuietly((Object)VanillaChronicleServerSocketChannel.this.ssc.socket());
            }

            @Override
            public void setReuseAddress(boolean b) throws SocketException {
                VanillaChronicleServerSocketChannel.this.ssc.socket().setReuseAddress(b);
            }

            @Override
            public SocketAddress getLocalSocketAddress() {
                return VanillaChronicleServerSocketChannel.this.ssc.socket().getLocalSocketAddress();
            }
        };
    }

    @Override
    public void close() {
        Closeable.closeQuietly((Object)this.ssc);
    }

    @Override
    public void bind(InetSocketAddress address) throws IOException {
        this.ssc.bind(address);
    }

    @Override
    public SocketAddress getLocalAddress() throws IOException {
        return this.ssc.getLocalAddress();
    }

    @Override
    public void setOption(SocketOption<Boolean> soReuseaddr, boolean b) throws IOException {
        this.ssc.setOption((SocketOption)soReuseaddr, (Object)b);
    }

    @Override
    public void configureBlocking(boolean configureBlocking) throws IOException {
        this.ssc.configureBlocking(configureBlocking);
    }

    @Override
    public String hostPort() {
        return this.hostPort;
    }

    public VanillaChronicleServerSocketChannel hostPort(String hostPort) {
        this.hostPort = hostPort;
        return this;
    }

    public String toString() {
        return "VanillaChronicleServerSocketChannel{ssc=" + this.ssc + ", hostPort=" + this.hostPort + '}';
    }
}

