/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.Selector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.VanillaClientConnectionMonitor;
import net.openhft.chronicle.network.connection.ClientConnectionMonitor;
import net.openhft.chronicle.network.connection.FatalFailureMonitor;
import net.openhft.chronicle.network.connection.SocketAddressSupplier;
import net.openhft.chronicle.network.tcp.ChronicleSocket;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannelFactory;
import net.openhft.chronicle.wire.Marshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ConnectionStrategy
extends Marshallable,
Closeable {
    default public ClientConnectionMonitor clientConnectionMonitor() {
        return new VanillaClientConnectionMonitor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static ChronicleSocketChannel socketChannel(@NotNull InetSocketAddress socketAddress, int tcpBufferSize, int socketConnectionTimeoutMs) throws IOException {
        ChronicleSocketChannel chronicleSocketChannel;
        boolean failed;
        Selector selector;
        ChronicleSocketChannel result;
        block16: {
            ChronicleSocketChannel chronicleSocketChannel2;
            block15: {
                ChronicleSocketChannel chronicleSocketChannel3;
                block14: {
                    result = ChronicleSocketChannelFactory.wrap();
                    selector = null;
                    failed = true;
                    try {
                        result.configureBlocking(false);
                        ChronicleSocket socket = result.socket();
                        if (!TcpEventHandler.DISABLE_TCP_NODELAY) {
                            socket.setTcpNoDelay(true);
                        }
                        socket.setReceiveBufferSize(tcpBufferSize);
                        socket.setSendBufferSize(tcpBufferSize);
                        socket.setSoTimeout(0);
                        socket.setSoLinger(false, 0);
                        result.connect(socketAddress);
                        selector = Selector.open();
                        result.register(selector, 8);
                        int select = selector.select(socketConnectionTimeoutMs);
                        if (select == 0) {
                            if (Jvm.isDebugEnabled(ConnectionStrategy.class)) {
                                Jvm.debug().on(ConnectionStrategy.class, "Timed out attempting to connect to " + socketAddress);
                            }
                            chronicleSocketChannel3 = null;
                            net.openhft.chronicle.core.io.Closeable.closeQuietly((Object)selector);
                            if (!failed) return chronicleSocketChannel3;
                            break block14;
                        }
                        if (!result.finishConnect()) {
                            chronicleSocketChannel2 = null;
                            net.openhft.chronicle.core.io.Closeable.closeQuietly((Object)selector);
                            break block15;
                        }
                        failed = false;
                        chronicleSocketChannel = result;
                        net.openhft.chronicle.core.io.Closeable.closeQuietly((Object)selector);
                        break block16;
                    }
                    catch (Exception e) {
                        ChronicleSocketChannel chronicleSocketChannel4 = null;
                        return chronicleSocketChannel4;
                    }
                }
                net.openhft.chronicle.core.io.Closeable.closeQuietly((Object)result);
                return chronicleSocketChannel3;
            }
            if (!failed) return chronicleSocketChannel2;
            net.openhft.chronicle.core.io.Closeable.closeQuietly((Object)result);
            return chronicleSocketChannel2;
        }
        if (!failed) return chronicleSocketChannel;
        net.openhft.chronicle.core.io.Closeable.closeQuietly((Object)result);
        return chronicleSocketChannel;
        finally {
            net.openhft.chronicle.core.io.Closeable.closeQuietly(selector);
            if (failed) {
                net.openhft.chronicle.core.io.Closeable.closeQuietly((Object)result);
            }
        }
    }

    public ChronicleSocketChannel connect(@NotNull String var1, @NotNull SocketAddressSupplier var2, boolean var3, @NotNull FatalFailureMonitor var4) throws InterruptedException;

    @Nullable
    default public ChronicleSocketChannel openSocketChannel(@NotNull InetSocketAddress socketAddress, int tcpBufferSize, long timeoutMs) throws IOException, InterruptedException {
        return this.openSocketChannel(socketAddress, tcpBufferSize, timeoutMs, 1);
    }

    @Nullable
    default public ChronicleSocketChannel openSocketChannel(@NotNull InetSocketAddress socketAddress, int tcpBufferSize, long timeoutMs, int socketConnectionTimeoutMs) throws IOException, InterruptedException {
        if (!1.$assertionsDisabled && timeoutMs <= 0L) {
            throw new AssertionError();
        }
        long start = System.currentTimeMillis();
        ChronicleSocketChannel sc = ConnectionStrategy.socketChannel(socketAddress, tcpBufferSize, socketConnectionTimeoutMs);
        if (sc != null) {
            return sc;
        }
        while (true) {
            this.throwExceptionIfClosed();
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            long startMs = System.currentTimeMillis();
            if (start + timeoutMs < startMs) {
                Jvm.warn().on(ConnectionStrategy.class, "Timed out attempting to connect to " + socketAddress);
                return null;
            }
            sc = ConnectionStrategy.socketChannel(socketAddress, tcpBufferSize, socketConnectionTimeoutMs);
            if (sc != null) {
                return sc;
            }
            Thread.yield();
            this.pauseBeforeReconnect(startMs);
        }
    }

    default public void pauseBeforeReconnect(long startMs) {
        long pauseMillis = startMs + this.pauseMillisBeforeReconnect() - System.currentTimeMillis();
        if (Jvm.isDebugEnabled(this.getClass())) {
            Jvm.debug().on(this.getClass(), "Waiting for reconnect " + pauseMillis + " ms");
        }
        LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(pauseMillis));
    }

    default public long pauseMillisBeforeReconnect() {
        return 500L;
    }

    @Override
    default public void close() {
    }

    default public boolean isClosed() {
        return false;
    }

    default public ConnectionStrategy open() {
        return this;
    }

    default public void throwExceptionIfClosed() throws IllegalStateException {
        if (this.isClosed()) {
            throw new ClosedIllegalStateException("Closed");
        }
    }

    default public long minPauseSec() {
        return Jvm.getInteger((String)"connectionStrategy.pause.min.secs", (Integer)5).intValue();
    }

    default public long maxPauseSec() {
        return Jvm.getInteger((String)"connectionStrategy.pause.max.secs", (Integer)5).intValue();
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

