/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.ClosedIllegalStateException;
import net.openhft.chronicle.network.NetworkUtil;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaWireOutPublisher
extends AbstractCloseable
implements WireOutPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaWireOutPublisher.class);
    private final Bytes<ByteBuffer> bytes = Bytes.elasticByteBuffer((int)NetworkUtil.TCP_BUFFER_SIZE);
    private Wire wire;
    private String connectionDescription = "?";

    public VanillaWireOutPublisher(@NotNull WireType wireType) {
        WireType wireType0 = wireType == WireType.DELTA_BINARY ? WireType.BINARY : wireType;
        this.wire = (Wire)wireType0.apply(this.bytes);
        this.wire.usePadding(NetworkUtil.TCP_USE_PADDING);
        this.bytes.singleThreadedCheckDisabled(true);
        this.singleThreadedCheckDisabled(true);
    }

    @Override
    public WireOutPublisher connectionDescription(String connectionDescription) {
        this.connectionDescription = connectionDescription;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applyAction(@NotNull Bytes<?> bytes) {
        if (this.bytes.readRemaining() > 0L) {
            Object object = this.lock();
            synchronized (object) {
                if (YamlLogging.showServerWrites()) {
                    this.logBuffer();
                }
                if (bytes.writePosition() > (long)NetworkUtil.TCP_BUFFER_SIZE) {
                    return;
                }
                bytes.write(this.bytes);
                this.bytes.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void logBuffer() {
        long pos = this.bytes.readPosition();
        try {
            while (this.wire.bytes().readRemaining() > 0L) {
                DocumentContext dc = this.wire.readingDocument();
                Throwable throwable = null;
                try {
                    Bytes bytes = this.wire.bytes();
                    if (!dc.isPresent()) {
                        bytes.readPosition(bytes.readLimit());
                        return;
                    }
                    LOG.info("Server " + this.connectionDescription + " Sends async event:\n" + Wires.fromSizePrefixedBlobs((DocumentContext)dc));
                    bytes.readPosition(bytes.readLimit());
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                }
            }
            return;
        }
        finally {
            this.bytes.readPosition(pos);
        }
    }

    @Override
    public void applyAction(@NotNull WireOut outWire) {
        this.applyAction(outWire.bytes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean canTakeMoreData() {
        this.throwExceptionIfClosed();
        Object object = this.lock();
        synchronized (object) {
            return this.wire.bytes().writePosition() < (long)NetworkUtil.TCP_SAFE_SIZE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object key, @NotNull WriteMarshallable event) {
        try {
            this.throwExceptionIfClosed();
        }
        catch (ClosedIllegalStateException ise) {
            Jvm.debug().on(this.getClass(), "Server " + this.connectionDescription + " message ignored as closed", (Throwable)ise);
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            long start = this.wire.bytes().writePosition();
            event.writeMarshallable((WireOut)this.wire);
            if (YamlLogging.showServerWrites()) {
                long rp = this.wire.bytes().readPosition();
                long rl = this.wire.bytes().readLimit();
                long wl = this.wire.bytes().writeLimit();
                try {
                    long len = this.wire.bytes().writePosition() - start;
                    this.wire.bytes().readPositionRemaining(start, len);
                    String message = Wires.fromSizePrefixedBlobs((WireIn)this.wire);
                    LOG.info("Server " + this.connectionDescription + " is about to send async event:" + message);
                }
                finally {
                    ((Bytes)((Bytes)this.wire.bytes().writeLimit(wl)).readLimit(rl)).readPosition(rp);
                }
            }
        }
    }

    private Object lock() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performClose() {
        Object object = this.lock();
        synchronized (object) {
            this.bytes.releaseLast();
            this.wire = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wireType(@NotNull WireType wireType) {
        WireType wireType0;
        this.throwExceptionIfClosedInSetter();
        WireType wireType2 = wireType0 = wireType == WireType.DELTA_BINARY ? WireType.BINARY : wireType;
        if (WireType.valueOf((Wire)this.wire) == wireType0) {
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            this.wire = (Wire)wireType0.apply(this.bytes);
            this.wire.usePadding(NetworkUtil.TCP_USE_PADDING);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock();
        synchronized (object) {
            this.wire.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock();
        synchronized (object) {
            return this.bytes.isEmpty();
        }
    }

    @NotNull
    public String toString() {
        String wireStr = this.wire == null ? "wire= null " : this.wire.getClass().getSimpleName() + "=" + this.bytes;
        return "VanillaWireOutPublisher{description=" + this.connectionDescription + ", closed=" + this.isClosed() + ", " + wireStr + '}';
    }
}

