/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.ssl;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.time.Instant;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.network.ssl.BufferHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
final class SslEngineStateMachine {
    private static final Logger LOGGER = LoggerFactory.getLogger(SslEngineStateMachine.class);
    private static final int HANDSHAKE_BUFFER_CAPACITY = 32768;
    private final BufferHandler bufferHandler;
    private final boolean isAcceptor;
    private SSLEngine engine;
    private ByteBuffer outboundApplicationData;
    private ByteBuffer outboundEncodedData;
    private ByteBuffer inboundEncodedData;
    private ByteBuffer inboundApplicationData;
    private ByteBuffer[] precomputedWrapArray;
    private ByteBuffer[] precomputedUnwrapArray;
    private boolean inHandshake = true;

    SslEngineStateMachine(BufferHandler bufferHandler, boolean isAcceptor) {
        this.bufferHandler = bufferHandler;
        this.isAcceptor = isAcceptor;
    }

    void initialise(SSLContext ctx) {
        try {
            this.engine = ctx.createSSLEngine();
            this.engine.setUseClientMode(!this.isAcceptor);
            if (this.isAcceptor) {
                this.engine.setNeedClientAuth(true);
            }
            this.engine.beginHandshake();
            this.outboundApplicationData = ByteBuffer.allocateDirect(Math.max(this.engine.getSession().getApplicationBufferSize(), 32768));
            this.outboundEncodedData = ByteBuffer.allocateDirect(Math.max(this.engine.getSession().getPacketBufferSize(), 32768));
            this.inboundApplicationData = ByteBuffer.allocateDirect(Math.max(this.engine.getSession().getApplicationBufferSize(), 32768));
            this.inboundEncodedData = ByteBuffer.allocateDirect(Math.max(this.engine.getSession().getPacketBufferSize(), 32768));
            this.precomputedWrapArray = new ByteBuffer[]{this.outboundApplicationData};
            this.precomputedUnwrapArray = new ByteBuffer[]{this.inboundApplicationData};
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to perform handshake at " + Instant.now(), e);
        }
    }

    boolean performHandshake() throws IOException {
        SSLEngineResult.HandshakeStatus status = this.engine.getHandshakeStatus();
        boolean reportedInitialStatus = false;
        SSLEngineResult.HandshakeStatus lastStatus = status;
        boolean didSomething = false;
        while (status != SSLEngineResult.HandshakeStatus.FINISHED && status != SSLEngineResult.HandshakeStatus.NOT_HANDSHAKING) {
            if (!reportedInitialStatus) {
                LOGGER.debug("initial status {}", (Object)status);
                reportedInitialStatus = true;
            }
            if (status != lastStatus) {
                LOGGER.debug("status change to {}", (Object)status);
                lastStatus = status;
            }
            block1 : switch (status) {
                case NEED_UNWRAP: {
                    int read = this.bufferHandler.readData(this.inboundEncodedData);
                    if (read > 0) {
                        didSomething = true;
                    }
                    this.inboundEncodedData.flip();
                    int dataReceived = this.inboundEncodedData.remaining();
                    SSLEngineResult result = this.engine.unwrap(this.inboundEncodedData, this.outboundApplicationData);
                    if (dataReceived > 0) {
                        LOGGER.debug("Received {} from handshake peer", (Object)dataReceived);
                    }
                    this.inboundEncodedData.compact();
                    switch (result.getStatus()) {
                        case OK: {
                            break block1;
                        }
                        case BUFFER_UNDERFLOW: {
                            LOGGER.debug("Not enough data read from remote end ({})", (Object)dataReceived);
                            break block1;
                        }
                    }
                    LOGGER.error("Bad handshake status: {}/{}", (Object)result.getStatus(), (Object)result.getHandshakeStatus());
                    break;
                }
                case NEED_WRAP: {
                    this.outboundEncodedData.clear();
                    SSLEngineResult result = this.engine.wrap(this.outboundApplicationData, this.outboundEncodedData);
                    switch (result.getStatus()) {
                        case OK: {
                            this.outboundEncodedData.flip();
                            int remaining = this.outboundEncodedData.remaining();
                            int wrote = this.bufferHandler.writeData(this.outboundEncodedData);
                            if (wrote < remaining) {
                                throw new IOException("Handshake message did not fit in buffer");
                            }
                            LOGGER.debug("Wrote {} to handshake peer", (Object)wrote);
                            didSomething = true;
                            break block1;
                        }
                    }
                    throw new UnsupportedOperationException(result.getStatus().toString());
                }
                case NEED_TASK: {
                    Runnable delegatedTask;
                    while ((delegatedTask = this.engine.getDelegatedTask()) != null) {
                        try {
                            delegatedTask.run();
                            LOGGER.debug("Ran task {}", (Object)delegatedTask);
                            didSomething = true;
                        }
                        catch (RuntimeException e) {
                            LOGGER.error("Delegated task threw exception", (Throwable)e);
                        }
                    }
                    break;
                }
            }
            status = this.engine.getHandshakeStatus();
            if (!didSomething) {
                return false;
            }
            didSomething = false;
        }
        this.outboundApplicationData.clear();
        this.outboundApplicationData.clear();
        this.outboundEncodedData.clear();
        this.inHandshake = false;
        return true;
    }

    public boolean action() {
        boolean busy = false;
        try {
            int read;
            if (this.inHandshake) {
                return this.performHandshake();
            }
            this.bufferHandler.handleDecryptedData(this.inboundApplicationData, this.outboundApplicationData);
            if (this.outboundApplicationData.position() != 0) {
                this.outboundApplicationData.flip();
                if (this.engine.wrap(this.precomputedWrapArray, this.outboundEncodedData).getStatus() == SSLEngineResult.Status.CLOSED) {
                    LOGGER.warn("Socket closed");
                    return false;
                }
                busy = this.outboundApplicationData.hasRemaining();
                this.outboundApplicationData.compact();
            }
            if (this.outboundEncodedData.position() != 0) {
                this.outboundEncodedData.flip();
                this.bufferHandler.writeData(this.outboundEncodedData);
                busy |= this.outboundEncodedData.hasRemaining();
                this.outboundEncodedData.compact();
            }
            if ((read = this.bufferHandler.readData(this.inboundEncodedData)) == -1) {
                throw new IORuntimeException("Socket closed");
            }
            busy |= read != 0;
            if (this.inboundEncodedData.position() != 0) {
                this.inboundEncodedData.flip();
                this.engine.unwrap(this.inboundEncodedData, this.precomputedUnwrapArray);
                busy |= this.inboundEncodedData.hasRemaining();
                this.inboundEncodedData.compact();
            }
            if (this.inboundApplicationData.position() != 0) {
                this.inboundApplicationData.flip();
                this.bufferHandler.handleDecryptedData(this.inboundApplicationData, this.outboundApplicationData);
                busy |= this.inboundApplicationData.hasRemaining();
                this.inboundApplicationData.compact();
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return busy;
    }

    void close() {
        this.engine.closeOutbound();
    }
}

