/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.connection.AbstractConnectionStrategy;
import net.openhft.chronicle.network.connection.ClientConnectionMonitor;
import net.openhft.chronicle.network.connection.FatalFailureMonitor;
import net.openhft.chronicle.network.connection.SocketAddressSupplier;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FatalFailureConnectionStrategy
extends AbstractConnectionStrategy {
    private static final long PAUSE = TimeUnit.MILLISECONDS.toNanos(300L);
    private final int attempts;
    private final boolean blocking;
    private transient boolean hasSentFatalFailure;

    FatalFailureConnectionStrategy() {
        this(1, false);
    }

    public FatalFailureConnectionStrategy(int attempts, boolean blocking) {
        this.attempts = attempts;
        this.blocking = blocking;
    }

    @Override
    public ClientConnectionMonitor clientConnectionMonitor() {
        return this.clientConnectionMonitor;
    }

    public FatalFailureConnectionStrategy clientConnectionMonitor(ClientConnectionMonitor fatalFailureMonitor) {
        this.clientConnectionMonitor = fatalFailureMonitor;
        return this;
    }

    @Override
    @Nullable
    public ChronicleSocketChannel connect(@NotNull String name, @NotNull SocketAddressSupplier socketAddressSupplier, boolean didLogIn, @Nullable FatalFailureMonitor fatalFailureMonitor) throws InterruptedException {
        if (socketAddressSupplier.size() == 0 && !this.hasSentFatalFailure && fatalFailureMonitor != null) {
            this.hasSentFatalFailure = true;
            fatalFailureMonitor.onFatalFailure(name, "no connections have not been configured");
            LockSupport.parkNanos(PAUSE);
            return null;
        }
        int failures = 0;
        int maxFailures = socketAddressSupplier.size() * this.attempts;
        socketAddressSupplier.resetToPrimary();
        while (true) {
            this.throwExceptionIfClosed();
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            if (failures == maxFailures && fatalFailureMonitor != null) {
                if (!this.hasSentFatalFailure) {
                    this.hasSentFatalFailure = true;
                    fatalFailureMonitor.onFatalFailure(name, name);
                }
                return null;
            }
            ChronicleSocketChannel socketChannel = null;
            try {
                @Nullable InetSocketAddress socketAddress = socketAddressSupplier.get();
                if (socketAddress == null) {
                    ++failures;
                    socketAddressSupplier.failoverToNextAddress();
                    LockSupport.parkNanos(PAUSE);
                    continue;
                }
                long millis = TimeUnit.NANOSECONDS.toMillis(PAUSE);
                socketChannel = this.openSocketChannel(socketAddress, this.tcpBufferSize, millis);
                if (socketChannel == null) {
                    Jvm.warn().on(this.getClass(), "unable to connected to " + socketAddressSupplier.toString() + ", name=" + name);
                    ++failures;
                    socketAddressSupplier.failoverToNextAddress();
                    LockSupport.parkNanos(PAUSE);
                    continue;
                }
                socketChannel.configureBlocking(this.blocking);
                if (Jvm.isDebugEnabled(this.getClass())) {
                    Jvm.debug().on(this.getClass(), "successfully connected to " + socketAddressSupplier);
                }
                this.hasSentFatalFailure = false;
                failures = 0;
                return socketChannel;
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (Throwable e) {
                if (socketChannel != null) {
                    Closeable.closeQuietly(socketChannel);
                }
                ++failures;
                socketAddressSupplier.failoverToNextAddress();
                LockSupport.parkNanos(PAUSE);
                continue;
            }
            break;
        }
    }
}

