/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.net.InetSocketAddress;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import net.openhft.chronicle.network.SessionMode;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VanillaSessionDetails
implements SessionDetailsProvider {
    private final Map<Class<?>, Object> infoMap = new LinkedHashMap();
    private String userId = "";
    private String securityToken = "";
    private String domain = "";
    private SessionMode sessionMode = SessionMode.ACTIVE;
    private UUID clientId;
    private InetSocketAddress clientAddress;
    private long connectTimeMS;
    private UUID sessionId;
    @Nullable
    private WireType wireType;
    private byte hostId;

    @NotNull
    public static VanillaSessionDetails of(String userId, String securityToken, String domain) {
        @NotNull VanillaSessionDetails vanillaSessionDetails = new VanillaSessionDetails();
        vanillaSessionDetails.userId(userId);
        vanillaSessionDetails.securityToken(securityToken);
        vanillaSessionDetails.domain(domain);
        return vanillaSessionDetails;
    }

    @Override
    public UUID sessionId() {
        if (this.sessionId == null) {
            this.sessionId = UUID.randomUUID();
        }
        return this.sessionId;
    }

    @Override
    public UUID clientId() {
        if (this.clientId == null) {
            this.clientId = UUID.randomUUID();
        }
        return this.clientId;
    }

    @Override
    public String userId() {
        return this.userId;
    }

    @Override
    public String securityToken() {
        return this.securityToken;
    }

    @Override
    public String domain() {
        return this.domain;
    }

    @Override
    public SessionMode sessionMode() {
        return this.sessionMode;
    }

    @Override
    public void domain(String domain) {
        this.domain = domain;
    }

    @Override
    public void sessionMode(SessionMode sessionMode) {
        this.sessionMode = sessionMode;
    }

    @Override
    public void clientId(UUID clientId) {
        this.clientId = clientId;
    }

    @Override
    public void wireType(@Nullable WireType wireType) {
        this.wireType = wireType;
    }

    @Override
    @Nullable
    public WireType wireType() {
        return this.wireType;
    }

    @Override
    public void hostId(byte hostId) {
        this.hostId = hostId;
    }

    @Override
    public byte hostId() {
        return this.hostId;
    }

    @Override
    public InetSocketAddress clientAddress() {
        return this.clientAddress;
    }

    @Override
    public long connectTimeMS() {
        return this.connectTimeMS;
    }

    @Override
    public <I> void set(Class<I> infoClass, I info) {
        this.infoMap.put(infoClass, info);
    }

    @Override
    @NotNull
    public <I> I get(Class<I> infoClass) {
        return (I)this.infoMap.get(infoClass);
    }

    @Override
    public void connectTimeMS(long connectTimeMS) {
        this.connectTimeMS = connectTimeMS;
    }

    @Override
    public void clientAddress(InetSocketAddress clientAddress) {
        this.clientAddress = clientAddress;
    }

    @Override
    public void securityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    @Override
    public void userId(String userId) {
        this.userId = userId;
    }

    @NotNull
    public String toString() {
        return "VanillaSessionDetails{infoMap=" + this.infoMap + ", userId='" + this.userId + '\'' + ", securityToken='" + this.securityToken + '\'' + ", clientAddress=" + this.clientAddress + ", connectTimeMS=" + this.connectTimeMS + ", sessionId=" + this.sessionId + ", sessionMode=" + (Object)((Object)this.sessionMode) + ", domain=" + this.domain + ", clientId=" + this.clientId + ", wiretype=" + this.wireType + ", hostId=" + this.hostId + '}';
    }
}

