/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.tcp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.network.tcp.ChronicleSocket;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketFactory;

public class VanillaSocketChannel
extends AbstractCloseable
implements ChronicleSocketChannel {
    protected final SocketChannel socketChannel;

    public VanillaSocketChannel(SocketChannel socketChannel) {
        this.socketChannel = socketChannel;
        this.disableThreadSafetyCheck(true);
    }

    @Override
    public SocketChannel socketChannel() {
        return this.socketChannel;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        return this.socketChannel.read(byteBuffer);
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        return this.socketChannel.write(byteBuffer);
    }

    @Override
    public long write(ByteBuffer[] byteBuffer) throws IOException {
        return this.socketChannel.write(byteBuffer);
    }

    @Override
    public ChronicleSocket socket() {
        return ChronicleSocketFactory.toChronicleSocket(this.socketChannel.socket());
    }

    @Override
    public void configureBlocking(boolean blocking) throws IOException {
        this.socketChannel.configureBlocking(blocking);
    }

    @Override
    public void connect(InetSocketAddress socketAddress) throws IOException {
        this.socketChannel.connect(socketAddress);
    }

    @Override
    public void register(Selector selector, int opConnect) throws ClosedChannelException {
        this.socketChannel.register(selector, opConnect);
    }

    @Override
    public boolean finishConnect() throws IOException {
        return this.socketChannel.finishConnect();
    }

    @Override
    public void setOption(SocketOption<Boolean> soReuseaddr, boolean b) throws IOException {
        this.socketChannel.setOption((SocketOption)soReuseaddr, (Object)b);
    }

    @Override
    public InetSocketAddress getRemoteAddress() throws IORuntimeException {
        try {
            return (InetSocketAddress)this.socketChannel.getRemoteAddress();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    @Override
    public InetSocketAddress getLocalAddress() throws IORuntimeException {
        try {
            return (InetSocketAddress)this.socketChannel.getLocalAddress();
        }
        catch (IOException e) {
            throw new IORuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isOpen() {
        return this.socketChannel.isOpen();
    }

    @Override
    public boolean isBlocking() {
        return this.socketChannel.isBlocking();
    }

    protected boolean shouldPerformCloseInBackground() {
        return true;
    }

    protected void performClose() {
        Closeable.closeQuietly((Object)this.socketChannel);
    }

    public String toString() {
        return "VanillaSocketChannel{socketChannel=" + this.socketChannel + '}';
    }
}

