/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import gnu.trove.map.TIntObjectMap;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.Closeable;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.io.ManagedCloseable;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.RemoteConnector;
import net.openhft.chronicle.network.ServerThreadingStrategy;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.cluster.Cluster;
import net.openhft.chronicle.network.cluster.ClusterAcceptorEventHandler;
import net.openhft.chronicle.network.cluster.ClusteredNetworkContext;
import net.openhft.chronicle.network.cluster.ConnectionManager;
import net.openhft.chronicle.network.cluster.HostConnector;
import net.openhft.chronicle.network.cluster.HostDetails;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.threads.BlockingEventLoop;
import net.openhft.chronicle.threads.EventGroup;
import net.openhft.chronicle.threads.Pauser;
import net.openhft.chronicle.threads.PauserMode;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public abstract class ClusterContext<C extends ClusterContext<C, T>, T extends ClusteredNetworkContext<T>>
extends SelfDescribingMarshallable
implements net.openhft.chronicle.core.io.Closeable,
ManagedCloseable {
    public static PauserMode DEFAULT_PAUSER_MODE = PauserMode.busy;
    private transient Function<WireType, WireOutPublisher> wireOutPublisherFactory;
    private transient Function<C, NetworkStatsListener<T>> networkStatsListenerFactory;
    protected transient EventLoop eventLoop;
    private transient Cluster<T, C> cluster;
    private transient EventLoop acceptorLoop;
    private transient ClusterAcceptorEventHandler<C, T> acceptorEventHandler;
    private final transient TIntObjectMap<HostConnector<T, C>> hostConnectors = new TIntObjectHashMap();
    private final transient TIntObjectMap<ConnectionManager<T>> connManagers = new TIntObjectHashMap();
    private transient boolean closed = false;
    private final transient List<Closeable> closeables = new CopyOnWriteArrayList<Closeable>();
    private Function<C, T> networkContextFactory;
    private long heartbeatTimeoutMs = 40000L;
    private long heartbeatIntervalMs = 20000L;
    private Supplier<Pauser> pauserSupplier = DEFAULT_PAUSER_MODE;
    private String affinityCPU;
    private WireType wireType;
    private byte localIdentifier;
    private ServerThreadingStrategy serverThreadingStrategy;
    private long retryInterval = 1000L;
    private String procPrefix;

    public ClusterContext() {
        this.defaults();
    }

    public void connect(HostDetails hd) {
        ConnectionManager connectionManager = new ConnectionManager();
        this.connManagers.put(hd.hostId(), connectionManager);
        if (this.localIdentifier <= hd.hostId()) {
            return;
        }
        @NotNull HostConnector<T, C> hostConnector = new HostConnector<T, C>(this.castThis(), new RemoteConnector<T>(this.tcpEventHandlerFactory()), hd.hostId(), hd.connectUri());
        this.closeables.add(hostConnector);
        if (this.isClosed()) {
            net.openhft.chronicle.core.io.Closeable.closeQuietly(hostConnector);
            return;
        }
        this.hostConnectors.put(hd.hostId(), hostConnector);
        hostConnector.connect();
    }

    public void accept(HostDetails hd) {
        if (hd.connectUri() == null) {
            return;
        }
        this.acceptorLoop = new BlockingEventLoop(this.eventLoop(), this.clusterNamePrefix() + "acceptor-" + this.localIdentifier);
        try {
            this.acceptorEventHandler = new ClusterAcceptorEventHandler(hd.connectUri(), this.castThis());
            this.acceptorLoop.addHandler(this.acceptorEventHandler);
        }
        catch (IOException ex) {
            throw new IORuntimeException("Couldn't start replication", (Throwable)ex);
        }
        this.acceptorLoop.start();
    }

    public ConnectionManager<T> connectionManager(int hostId) {
        return (ConnectionManager)this.connManagers.get(hostId);
    }

    @NotNull
    public EventLoop eventLoop() {
        EventLoop el = this.eventLoop;
        if (el != null) {
            return el;
        }
        return this.synchronizedEventLoop();
    }

    protected synchronized EventLoop synchronizedEventLoop() {
        EventLoop el = this.eventLoop;
        if (el != null) {
            return el;
        }
        this.eventLoop = new EventGroup(true, this.pauserSupplier.get(), null, this.affinityCPU, this.clusterNamePrefix(), EventGroup.CONC_THREADS, EnumSet.of(HandlerPriority.MEDIUM, HandlerPriority.TIMER, HandlerPriority.BLOCKING, HandlerPriority.REPLICATION, HandlerPriority.REPLICATION_TIMER));
        return this.eventLoop;
    }

    @NotNull
    public C eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
        return this.castThis();
    }

    public String procPrefix() {
        return this.procPrefix;
    }

    public void procPrefix(String procPrefix) {
        this.procPrefix = procPrefix;
    }

    public Function<C, NetworkStatsListener<T>> networkStatsListenerFactory() {
        return this.networkStatsListenerFactory;
    }

    @NotNull
    public C networkStatsListenerFactory(Function<C, NetworkStatsListener<T>> networkStatsListenerFactory) {
        this.networkStatsListenerFactory = networkStatsListenerFactory;
        return this.castThis();
    }

    @NotNull
    public abstract ThrowingFunction<T, TcpEventHandler<T>, IOException> tcpEventHandlerFactory();

    public C serverThreadingStrategy(ServerThreadingStrategy serverThreadingStrategy) {
        this.serverThreadingStrategy = serverThreadingStrategy;
        return this.castThis();
    }

    public ServerThreadingStrategy serverThreadingStrategy() {
        return this.serverThreadingStrategy;
    }

    public Cluster<T, C> cluster() {
        return this.cluster;
    }

    public void cluster(Cluster<T, C> cluster) {
        this.cluster = cluster;
    }

    protected abstract void defaults();

    @NotNull
    public C localIdentifier(byte localIdentifier) {
        this.localIdentifier = localIdentifier;
        return this.castThis();
    }

    public byte localIdentifier() {
        return this.localIdentifier;
    }

    @NotNull
    public C wireType(WireType wireType) {
        this.wireType = wireType;
        return this.castThis();
    }

    public WireType wireType() {
        return this.wireType;
    }

    @NotNull
    public C heartbeatIntervalMs(long heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
        return this.castThis();
    }

    public long heartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    @NotNull
    public C heartbeatTimeoutMs(long heartbeatTimeoutMs) {
        this.heartbeatTimeoutMs = heartbeatTimeoutMs;
        return this.castThis();
    }

    public long heartbeatTimeoutMs() {
        return this.heartbeatTimeoutMs;
    }

    @NotNull
    public C pauserSupplier(@NotNull Supplier<Pauser> pauserSupplier) {
        this.pauserSupplier = pauserSupplier;
        return this.castThis();
    }

    public Supplier<Pauser> pauserSupplier() {
        return this.pauserSupplier;
    }

    public String affinityCPU() {
        return this.affinityCPU;
    }

    public C affinityCPU(String affinityCPU) {
        this.affinityCPU = affinityCPU;
        return this.castThis();
    }

    @NotNull
    public C wireOutPublisherFactory(Function<WireType, WireOutPublisher> wireOutPublisherFactory) {
        this.wireOutPublisherFactory = wireOutPublisherFactory;
        return this.castThis();
    }

    public Function<WireType, WireOutPublisher> wireOutPublisherFactory() {
        return this.wireOutPublisherFactory;
    }

    @NotNull
    public C networkContextFactory(Function<C, T> networkContextFactory) {
        this.networkContextFactory = networkContextFactory;
        return this.castThis();
    }

    public Function<C, T> networkContextFactory() {
        return this.networkContextFactory;
    }

    public C retryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
        return this.castThis();
    }

    public long retryInterval() {
        return this.retryInterval;
    }

    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        this.networkStatsListenerFactory = (Function)wire.read("networkStatsListenerFactory").object(Function.class);
        this.defaults();
        super.readMarshallable(wire);
    }

    public boolean isClosed() {
        return this.closed;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.performClose();
    }

    protected void performClose() {
        net.openhft.chronicle.core.io.Closeable.closeQuietly((Object[])new Object[]{this.closeables, this.acceptorEventHandler, this.wireOutPublisherFactory, this.networkContextFactory, this.networkStatsListenerFactory, this.eventLoop, this.acceptorLoop});
    }

    protected abstract String clusterNamePrefix();

    private C castThis() {
        return (C)((Object)this);
    }
}

