/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.io.IOException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.ClusteredNetworkContext;
import net.openhft.chronicle.network.tcp.ChronicleServerSocket;
import net.openhft.chronicle.network.tcp.ChronicleServerSocketChannel;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterAcceptorEventHandler<C extends ClusterContext<C, T>, T extends ClusteredNetworkContext<T>>
extends AbstractCloseable
implements EventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ClusterAcceptorEventHandler.class);
    @NotNull
    private final ChronicleServerSocketChannel ssc;
    @NotNull
    private final C context;
    private final String hostPort;
    private EventLoop eventLoop;

    public ClusterAcceptorEventHandler(@NotNull String hostPort, @NotNull C context) throws IOException {
        this.hostPort = hostPort;
        this.ssc = TCPRegistry.acquireServerSocketChannel(this.hostPort);
        this.context = context;
    }

    public void eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    public boolean action() throws InvalidEventHandlerException {
        if (!this.ssc.isOpen() || this.isClosed() || this.eventLoop.isClosed()) {
            throw new InvalidEventHandlerException();
        }
        try {
            LOGGER.debug("accepting {}", (Object)this.ssc);
            ChronicleSocketChannel sc = this.ssc.accept();
            if (sc != null) {
                if (this.isClosed() || this.eventLoop.isClosed()) {
                    Closeable.closeQuietly((Object)sc);
                    throw new InvalidEventHandlerException("closed");
                }
                ClusteredNetworkContext nc = (ClusteredNetworkContext)((ClusterContext)((Object)this.context)).networkContextFactory().apply(this.context);
                nc.socketChannel(sc);
                nc.isAcceptor(true);
                NetworkStatsListener nl = nc.networkStatsListener();
                NetworkStatsListener.notifyHostPort(sc, nl);
                TcpEventHandler apply = (TcpEventHandler)((ClusterContext)((Object)this.context)).tcpEventHandlerFactory().apply((Object)nc);
                this.eventLoop.addHandler((EventHandler)apply);
            }
        }
        catch (AsynchronousCloseException e) {
            this.closeSocket();
            throw new InvalidEventHandlerException((Throwable)e);
        }
        catch (ClosedChannelException e) {
            this.closeSocket();
            if (this.isClosed()) {
                throw new InvalidEventHandlerException();
            }
            throw new InvalidEventHandlerException((Throwable)e);
        }
        catch (Exception e) {
            if (!this.isClosed() && !this.eventLoop.isClosed()) {
                ChronicleServerSocket socket = this.ssc.socket();
                LOGGER.warn("{}, port={}", new Object[]{this.hostPort, socket == null ? "unknown" : Integer.valueOf(socket.getLocalPort()), e});
            }
            this.closeSocket();
            throw new InvalidEventHandlerException((Throwable)e);
        }
        return false;
    }

    private void closeSocket() {
        this.ssc.socket().close();
        this.ssc.close();
    }

    @NotNull
    public HandlerPriority priority() {
        return HandlerPriority.BLOCKING;
    }

    protected void performClose() {
        this.closeSocket();
    }
}

