/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.net.InetSocketAddress;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface NetworkStatsListener<N extends NetworkContext<N>>
extends Closeable {
    public static <N extends NetworkContext<N>> void notifyHostPort(@Nullable ChronicleSocketChannel sc, @Nullable NetworkStatsListener<N> nl) {
        if (nl != null && sc != null && sc.socket() != null && sc.socket().getRemoteSocketAddress() instanceof InetSocketAddress) {
            @NotNull InetSocketAddress remoteSocketAddress = (InetSocketAddress)sc.socket().getRemoteSocketAddress();
            nl.onHostPort(remoteSocketAddress.getHostName(), remoteSocketAddress.getPort());
        }
    }

    public void networkContext(N var1);

    public void onNetworkStats(long var1, long var3, long var5);

    public void onHostPort(String var1, int var2);

    public void onRoundTripLatency(long var1);

    default public void procPrefix(String procPrefix) {
    }
}

