/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.RemoteConnector;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.ClusteredNetworkContext;
import net.openhft.chronicle.network.cluster.ConnectionManager;
import net.openhft.chronicle.network.cluster.handlers.HeartbeatHandler;
import net.openhft.chronicle.network.cluster.handlers.UberHandler;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.network.tcp.ChronicleSocketChannel;
import net.openhft.chronicle.wire.WireType;
import org.jetbrains.annotations.NotNull;

public class HostConnector<T extends ClusteredNetworkContext<T>, C extends ClusterContext<C, T>>
implements java.io.Closeable {
    @NotNull
    private final ConnectionManager<T> connectionManager;
    private final WireType wireType;
    private final Function<WireType, WireOutPublisher> wireOutPublisherFactory;
    private final RemoteConnector<T> remoteConnector;
    private final String connectUri;
    private final Function<C, T> networkContextFactory;
    @NotNull
    private final C clusterContext;
    private final Function<C, NetworkStatsListener<T>> networkStatsListenerFactory;
    private final int remoteId;
    private T nc;
    @NotNull
    private final AtomicReference<WireOutPublisher> wireOutPublisher = new AtomicReference();
    @NotNull
    private final EventLoop eventLoop;

    HostConnector(@NotNull C clusterContext, @NotNull RemoteConnector<T> remoteConnector, int remoteId, String connectUri) {
        this.connectionManager = ((ClusterContext)((Object)clusterContext)).connectionManager(remoteId);
        this.clusterContext = clusterContext;
        this.remoteId = remoteId;
        this.remoteConnector = remoteConnector;
        this.networkStatsListenerFactory = ((ClusterContext)((Object)clusterContext)).networkStatsListenerFactory();
        this.networkContextFactory = ((ClusterContext)((Object)clusterContext)).networkContextFactory();
        this.connectUri = connectUri;
        this.wireType = ((ClusterContext)((Object)clusterContext)).wireType();
        this.wireOutPublisherFactory = ((ClusterContext)((Object)clusterContext)).wireOutPublisherFactory();
        this.eventLoop = ((ClusterContext)((Object)clusterContext)).eventLoop();
    }

    @Override
    public synchronized void close() {
        WireOutPublisher wp = this.wireOutPublisher.getAndSet(null);
        ChronicleSocketChannel socketChannel = this.nc.socketChannel();
        if (socketChannel != null) {
            Closeable.closeQuietly((Object[])new Object[]{socketChannel, socketChannel.socket()});
        }
        if (wp != null) {
            wp.close();
        }
    }

    public ConnectionManager<T> connectionManager() {
        return this.connectionManager;
    }

    public synchronized void connect() {
        if (this.connectUri == null || this.connectUri.isEmpty()) {
            return;
        }
        WireOutPublisher wireOutPublisher = this.wireOutPublisherFactory.apply(((ClusterContext)((Object)this.clusterContext)).wireType());
        if (!this.wireOutPublisher.compareAndSet(null, wireOutPublisher)) {
            wireOutPublisher.close();
            return;
        }
        if (this.eventLoop.isClosed()) {
            return;
        }
        this.nc = (ClusteredNetworkContext)((ClusteredNetworkContext)((ClusteredNetworkContext)((ClusteredNetworkContext)((ClusteredNetworkContext)((ClusteredNetworkContext)((ClusteredNetworkContext)this.networkContextFactory.apply(this.clusterContext)).wireOutPublisher(wireOutPublisher)).isAcceptor(false)).heartbeatTimeoutMs(((ClusterContext)((Object)this.clusterContext)).heartbeatTimeoutMs() * 2L)).socketReconnector(this::reconnect)).serverThreadingStrategy(((ClusterContext)((Object)this.clusterContext)).serverThreadingStrategy())).wireType(this.wireType);
        if (this.networkStatsListenerFactory != null) {
            NetworkStatsListener<T> networkStatsListener = this.networkStatsListenerFactory.apply(this.clusterContext);
            this.nc.networkStatsListener(networkStatsListener);
            networkStatsListener.networkContext(this.nc);
        }
        wireOutPublisher.publish(UberHandler.uberHandler(((ClusterContext)((Object)this.clusterContext)).localIdentifier(), this.remoteId, this.wireType));
        wireOutPublisher.publish(HeartbeatHandler.heartbeatHandler(((ClusterContext)((Object)this.clusterContext)).heartbeatTimeoutMs(), ((ClusterContext)((Object)this.clusterContext)).heartbeatIntervalMs(), HeartbeatHandler.class.hashCode()));
        wireOutPublisher.wireType(this.wireType);
        this.remoteConnector.connect(this.connectUri, this.eventLoop, this.nc, ((ClusterContext)((Object)this.clusterContext)).retryInterval());
    }

    synchronized void reconnect() {
        this.close();
        this.connect();
    }
}

