/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.ssl;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.ssl.BufferHandler;

public final class BytesBufferHandler<N extends NetworkContext<N>>
implements BufferHandler {
    private static final Bytes<ByteBuffer> EMPTY_APPLICATION_INPUT = Bytes.wrapForRead((ByteBuffer)ByteBuffer.allocate(0));
    private TcpHandler<N> delegateHandler;
    private Bytes<ByteBuffer> input;
    private Bytes<ByteBuffer> output;
    private N networkContext;

    public void set(TcpHandler<N> delegate, Bytes<ByteBuffer> input, Bytes<ByteBuffer> output, N networkContext) {
        this.delegateHandler = delegate;
        this.input = input;
        this.output = output;
        this.networkContext = networkContext;
    }

    @Override
    public int readData(ByteBuffer target) {
        int toRead = Math.min(target.remaining(), (int)this.input.readRemaining());
        for (int i = 0; i < toRead; ++i) {
            target.put(this.input.readByte());
        }
        return toRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleDecryptedData(ByteBuffer input, ByteBuffer output) {
        Bytes applicationInput;
        if (input.position() != 0) {
            input.flip();
            applicationInput = Bytes.wrapForRead((ByteBuffer)input);
            BytesUtil.unregister((Bytes)applicationInput);
        } else {
            applicationInput = EMPTY_APPLICATION_INPUT;
        }
        Bytes applicationOutput = Bytes.wrapForWrite((ByteBuffer)output);
        BytesUtil.unregister((Bytes)applicationOutput);
        try {
            this.delegateHandler.process(applicationInput, applicationOutput, this.networkContext);
            output.position((int)applicationOutput.writePosition());
        }
        finally {
            applicationOutput.release();
        }
        input.position((int)applicationInput.readPosition());
        if (applicationInput.readPosition() != 0L) {
            input.compact();
        }
    }

    @Override
    public int writeData(ByteBuffer encrypted) {
        if (this.output.readPosition() != 0L) {
            this.output.compact();
        }
        int writeRemaining = (int)(this.output.writeRemaining() > Integer.MAX_VALUE ? Integer.MAX_VALUE : this.output.writeRemaining());
        int toWrite = Math.min(encrypted.remaining(), writeRemaining);
        for (int i = 0; i < toWrite; ++i) {
            this.output.writeByte(encrypted.get());
        }
        return toWrite;
    }
}

