/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.ConnectionStrategy;
import net.openhft.chronicle.network.connection.FatalFailureMonitor;
import net.openhft.chronicle.network.connection.SocketAddressSupplier;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.network.tcp.ISocketChannel;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlwaysStartOnPrimaryConnectionStrategy
extends SelfDescribingMarshallable
implements ConnectionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AlwaysStartOnPrimaryConnectionStrategy.class);
    private int tcpBufferSize = Integer.getInteger("tcp.client.buffer.size", TcpChannelHub.TCP_BUFFER);
    private int pausePeriodMs = Integer.getInteger("client.timeout", 500);
    private int socketConnectionTimeoutMs = Integer.getInteger("connectionStrategy.socketConnectionTimeoutMs", 1);
    private long pauseMillisBeforeReconnect = Integer.getInteger("connectionStrategy.pauseMillisBeforeReconnect", 500).intValue();

    @Override
    @Nullable
    public ISocketChannel connect(@NotNull String name, @NotNull SocketAddressSupplier socketAddressSupplier, boolean didLogIn, @Nullable FatalFailureMonitor fatalFailureMonitor) throws InterruptedException {
        if (socketAddressSupplier.get() == null || didLogIn) {
            socketAddressSupplier.resetToPrimary();
        } else {
            socketAddressSupplier.failoverToNextAddress();
        }
        while (true) {
            ISocketChannel socketChannel = null;
            try {
                @Nullable InetSocketAddress socketAddress = socketAddressSupplier.get();
                if (socketAddress == null) {
                    Jvm.warn().on(AlwaysStartOnPrimaryConnectionStrategy.class, "failed to obtain socketAddress");
                    if (this.isAtEnd(socketAddressSupplier)) {
                        fatalFailureMonitor.onFatalFailure(name, "Failed to connect to any of these servers=" + socketAddressSupplier.remoteAddresses());
                        return null;
                    }
                    socketAddressSupplier.failoverToNextAddress();
                    continue;
                }
                socketChannel = this.openSocketChannel(socketAddress, this.tcpBufferSize, this.pausePeriodMs, this.socketConnectionTimeoutMs);
                if (socketChannel == null) {
                    if (Jvm.isDebugEnabled(this.getClass())) {
                        Jvm.debug().on(this.getClass(), "unable to connected to " + socketAddressSupplier.toString());
                    }
                    if (this.isAtEnd(socketAddressSupplier)) {
                        fatalFailureMonitor.onFatalFailure(name, "Failed to connect to any of these servers=" + socketAddressSupplier.remoteAddresses());
                        return null;
                    }
                    socketAddressSupplier.failoverToNextAddress();
                    continue;
                }
                Jvm.warn().on(this.getClass(), "successfully connected to " + socketAddressSupplier);
                return socketChannel;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
            catch (Throwable e) {
                if (socketChannel != null) {
                    Closeable.closeQuietly(socketChannel);
                }
                if (Jvm.isDebug()) {
                    LOG.info("", e);
                }
                socketAddressSupplier.failoverToNextAddress();
                LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(this.pausePeriodMs));
                continue;
            }
            break;
        }
    }

    private boolean isAtEnd(SocketAddressSupplier socketAddressSupplier) {
        return socketAddressSupplier.size() - 1 == socketAddressSupplier.index();
    }

    @Override
    public long pauseMillisBeforeReconnect() {
        return this.pauseMillisBeforeReconnect;
    }

    public AlwaysStartOnPrimaryConnectionStrategy tcpBufferSize(int tcpBufferSize) {
        this.tcpBufferSize = tcpBufferSize;
        return this;
    }

    public AlwaysStartOnPrimaryConnectionStrategy pausePeriodMs(int pausePeriodMs) {
        this.pausePeriodMs = pausePeriodMs;
        return this;
    }

    public AlwaysStartOnPrimaryConnectionStrategy socketConnectionTimeoutMs(int socketConnectionTimeoutMs) {
        this.socketConnectionTimeoutMs = socketConnectionTimeoutMs;
        return this;
    }

    public AlwaysStartOnPrimaryConnectionStrategy pauseMillisBeforeReconnect(long pauseMillisBeforeReconnect) {
        this.pauseMillisBeforeReconnect = pauseMillisBeforeReconnect;
        return this;
    }
}

