/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.openhft.chronicle.core.io.AbstractCloseable;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.RemoteConnector;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.ClusteredNetworkContext;
import net.openhft.chronicle.network.cluster.HostDetails;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.network.tcp.ISocketChannel;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class HostConnector<T extends ClusteredNetworkContext<T>>
extends AbstractCloseable {
    private final WireType wireType;
    private final Function<WireType, WireOutPublisher> wireOutPublisherFactory;
    private final List<WriteMarshallable> bootstraps = new LinkedList<WriteMarshallable>();
    private final RemoteConnector<T> remoteConnector;
    private final String connectUri;
    private final Function<ClusterContext<T>, T> networkContextFactory;
    @NotNull
    private final ClusterContext<T> clusterContext;
    private final Function<ClusterContext<T>, NetworkStatsListener<T>> networkStatsListenerFactory;
    private T nc;
    @NotNull
    private final AtomicReference<WireOutPublisher> wireOutPublisher = new AtomicReference();
    @NotNull
    private final EventLoop eventLoop;

    HostConnector(@NotNull ClusterContext<T> clusterContext, RemoteConnector<T> remoteConnector, @NotNull HostDetails hostdetails) {
        this.clusterContext = clusterContext;
        this.remoteConnector = remoteConnector;
        this.networkStatsListenerFactory = clusterContext.networkStatsListenerFactory();
        this.networkContextFactory = clusterContext.networkContextFactory();
        this.connectUri = hostdetails.connectUri();
        this.wireType = clusterContext.wireType();
        this.wireOutPublisherFactory = clusterContext.wireOutPublisherFactory();
        this.eventLoop = clusterContext.eventLoop();
    }

    protected synchronized void performClose() {
        WireOutPublisher wp = this.wireOutPublisher.getAndSet(null);
        ISocketChannel socketChannel = this.nc.socketChannel();
        if (socketChannel != null) {
            Closeable.closeQuietly((Object)socketChannel);
            Closeable.closeQuietly((Object)socketChannel.socket());
        }
        if (wp != null) {
            wp.close();
        }
    }

    public synchronized void bootstrap(WriteMarshallable subscription) {
        this.bootstraps.add(subscription);
        WireOutPublisher wp = this.wireOutPublisher.get();
        if (wp != null) {
            wp.publish(subscription);
            wp.wireType(this.wireType);
        }
    }

    public synchronized void connect() {
        WireOutPublisher wireOutPublisher = this.wireOutPublisherFactory.apply(this.clusterContext.wireType());
        if (!this.wireOutPublisher.compareAndSet(null, wireOutPublisher)) {
            wireOutPublisher.close();
            return;
        }
        this.nc = (ClusteredNetworkContext)((ClusteredNetworkContext)((ClusteredNetworkContext)((ClusteredNetworkContext)((ClusteredNetworkContext)((ClusteredNetworkContext)((ClusteredNetworkContext)this.networkContextFactory.apply(this.clusterContext)).wireOutPublisher(wireOutPublisher)).isAcceptor(false)).heartbeatTimeoutMs(this.clusterContext.heartbeatTimeoutMs() * 2L)).socketReconnector(this::reconnect)).serverThreadingStrategy(this.clusterContext.serverThreadingStrategy())).wireType(this.wireType);
        if (this.networkStatsListenerFactory != null) {
            NetworkStatsListener<T> networkStatsListener = this.networkStatsListenerFactory.apply(this.clusterContext);
            this.nc.networkStatsListener(networkStatsListener);
            networkStatsListener.networkContext(this.nc);
        }
        for (WriteMarshallable bootstrap : this.bootstraps) {
            wireOutPublisher.publish(bootstrap);
            wireOutPublisher.wireType(this.wireType);
        }
        this.remoteConnector.connect(this.connectUri, this.eventLoop, this.nc, this.clusterContext.retryInterval());
    }

    synchronized void reconnect() {
        this.close();
        if (!this.nc.isAcceptor() && !this.isClosed()) {
            this.connect();
        }
    }

    public String connectUri() {
        return this.connectUri;
    }
}

