/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.util.ThrowingFunction;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.RemoteConnector;
import net.openhft.chronicle.network.ServerThreadingStrategy;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.cluster.ClusterNotifier;
import net.openhft.chronicle.network.cluster.ClusteredNetworkContext;
import net.openhft.chronicle.network.cluster.ConnectionManager;
import net.openhft.chronicle.network.cluster.ConnectionNotifier;
import net.openhft.chronicle.network.cluster.HostConnector;
import net.openhft.chronicle.network.cluster.HostDetails;
import net.openhft.chronicle.network.cluster.handlers.UberHandler;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.SelfDescribingMarshallable;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public abstract class ClusterContext<T extends ClusteredNetworkContext<T>>
extends SelfDescribingMarshallable
implements Consumer<HostDetails> {
    private transient UberHandler.Factory<T> handlerFactory;
    private transient Function<WireType, WireOutPublisher> wireOutPublisherFactory;
    private transient Function<ClusterContext<T>, T> networkContextFactory;
    private transient Function<ClusterContext<T>, WriteMarshallable> heartbeatFactory;
    private transient Function<ClusterContext<T>, NetworkStatsListener<T>> networkStatsListenerFactory;
    private transient Supplier<ConnectionManager<T>> connectionEventHandler;
    private transient EventLoop eventLoop;
    private long heartbeatTimeoutMs = 40000L;
    private long heartbeatIntervalMs = 20000L;
    private ConnectionNotifier connectionNotifier;
    private WireType wireType;
    private String clusterName;
    private byte localIdentifier;
    private ServerThreadingStrategy serverThreadingStrategy;
    private long retryInterval = 1000L;
    private String procPrefix;

    public ClusterContext() {
        this.defaults();
    }

    public String procPrefix() {
        return this.procPrefix;
    }

    public void procPrefix(String procPrefix) {
        this.procPrefix = procPrefix;
    }

    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        wire.read("networkStatsListenerFactory").object(this.networkStatsListenerFactory, Function.class);
        this.defaults();
        super.readMarshallable(wire);
    }

    public Function<ClusterContext<T>, NetworkStatsListener<T>> networkStatsListenerFactory() {
        return this.networkStatsListenerFactory;
    }

    @NotNull
    public ClusterContext<T> networkStatsListenerFactory(Function<ClusterContext<T>, NetworkStatsListener<T>> networkStatsListenerFactory) {
        this.networkStatsListenerFactory = networkStatsListenerFactory;
        return this;
    }

    public long heartbeatIntervalMs() {
        return this.heartbeatIntervalMs;
    }

    @NotNull
    public abstract ThrowingFunction<T, TcpEventHandler<T>, IOException> tcpEventHandlerFactory();

    public ClusterContext<T> serverThreadingStrategy(ServerThreadingStrategy serverThreadingStrategy) {
        this.serverThreadingStrategy = serverThreadingStrategy;
        return this;
    }

    public ServerThreadingStrategy serverThreadingStrategy() {
        return this.serverThreadingStrategy;
    }

    private UberHandler.Factory<T> handlerFactory() {
        return this.handlerFactory;
    }

    public ClusterContext<T> handlerFactory(UberHandler.Factory<T> handlerFactory) {
        this.handlerFactory = handlerFactory;
        return this;
    }

    public void clusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public EventLoop eventLoop() {
        return this.eventLoop;
    }

    @NotNull
    public ClusterContext<T> eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
        return this;
    }

    protected void closeEventLoop() {
        if (this.eventLoop != null) {
            this.eventLoop.close();
            this.eventLoop = null;
        }
    }

    protected abstract void defaults();

    @NotNull
    public ClusterContext<T> localIdentifier(byte localIdentifier) {
        this.localIdentifier = localIdentifier;
        return this;
    }

    @NotNull
    public ClusterContext<T> wireType(WireType wireType) {
        this.wireType = wireType;
        return this;
    }

    @NotNull
    public ClusterContext<T> heartbeatFactory(Function<ClusterContext<T>, WriteMarshallable> heartbeatFactor) {
        this.heartbeatFactory = heartbeatFactor;
        return this;
    }

    @NotNull
    public ClusterContext<T> heartbeatIntervalMs(long heartbeatIntervalMs) {
        this.heartbeatIntervalMs = heartbeatIntervalMs;
        return this;
    }

    @NotNull
    public ClusterContext<T> heartbeatTimeoutMs(long heartbeatTimeoutMs) {
        this.heartbeatTimeoutMs = heartbeatTimeoutMs;
        return this;
    }

    @NotNull
    public ClusterContext<T> wireOutPublisherFactory(Function<WireType, WireOutPublisher> wireOutPublisherFactory) {
        this.wireOutPublisherFactory = wireOutPublisherFactory;
        return this;
    }

    @NotNull
    public ClusterContext<T> networkContextFactory(Function<ClusterContext<T>, T> networkContextFactory) {
        this.networkContextFactory = networkContextFactory;
        return this;
    }

    public WireType wireType() {
        return this.wireType;
    }

    public Function<WireType, WireOutPublisher> wireOutPublisherFactory() {
        return this.wireOutPublisherFactory;
    }

    public long heartbeatTimeoutMs() {
        return this.heartbeatTimeoutMs;
    }

    public String clusterName() {
        return this.clusterName;
    }

    public byte localIdentifier() {
        return this.localIdentifier;
    }

    public Function<ClusterContext<T>, T> networkContextFactory() {
        return this.networkContextFactory;
    }

    @NotNull
    public ClusterContext<T> connectionNotifier(ConnectionNotifier connectionNotifier) {
        this.connectionNotifier = connectionNotifier;
        return this;
    }

    private ConnectionNotifier connectionNotifier() {
        return this.connectionNotifier;
    }

    private Supplier<ConnectionManager<T>> connectionEventHandler() {
        return this.connectionEventHandler;
    }

    @NotNull
    public ClusterContext<T> connectionEventHandler(Supplier<ConnectionManager<T>> connectionEventHandler) {
        this.connectionEventHandler = connectionEventHandler;
        return this;
    }

    private Function<ClusterContext<T>, WriteMarshallable> heartbeatFactory() {
        return this.heartbeatFactory;
    }

    @Override
    public void accept(@NotNull HostDetails hd) {
        if (this.localIdentifier == hd.hostId()) {
            return;
        }
        ConnectionNotifier connectionNotifier = this.connectionNotifier();
        hd.connectionNotifier(connectionNotifier);
        ConnectionManager<T> connectionManager = this.connectionEventHandler().get();
        hd.connectionManager(connectionManager);
        @NotNull HostConnector<T> hostConnector = new HostConnector<T>(this, new RemoteConnector<T>(this.tcpEventHandlerFactory()), hd);
        hd.hostConnector(hostConnector);
        @NotNull ClusterNotifier clusterNotifier = new ClusterNotifier(connectionManager, hostConnector, this.bootstraps(hd));
        hd.clusterNotifier(clusterNotifier);
        hd.terminationEventHandler(clusterNotifier);
        clusterNotifier.connect();
    }

    @NotNull
    private List<WriteMarshallable> bootstraps(HostDetails hd) {
        UberHandler.Factory<T> handler = this.handlerFactory();
        Function<ClusterContext<ClusterContext>, WriteMarshallable> heartbeat = this.heartbeatFactory();
        @NotNull ArrayList<WriteMarshallable> result = new ArrayList<WriteMarshallable>();
        result.add(handler.apply(this, hd));
        result.add(heartbeat.apply(this));
        return result;
    }

    public long retryInterval() {
        return this.retryInterval;
    }

    public ClusterContext<T> retryInterval(long retryInterval) {
        this.retryInterval = retryInterval;
        return this;
    }
}

