/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedByInterruptException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.bytes.BytesUtil;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.Maths;
import net.openhft.chronicle.core.OS;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.tcp.ISocketChannel;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.network.HeartbeatListener;
import net.openhft.chronicle.network.MarshallableFunction;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkLog;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.ServerThreadingStrategy;
import net.openhft.chronicle.network.TcpEventHandlerManager;
import net.openhft.chronicle.network.WanSimulator;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TcpEventHandler
implements EventHandler,
Closeable,
TcpEventHandlerManager {
    private static final int MONITOR_POLL_EVERY_SEC = Integer.getInteger("tcp.event.monitor.secs", 10);
    private static final Logger LOG = LoggerFactory.getLogger(TcpEventHandler.class);
    private static final AtomicBoolean FIRST_HANDLER = new AtomicBoolean();
    public static boolean DISABLE_TCP_NODELAY = Boolean.getBoolean("disable.tcp_nodelay");
    @NotNull
    private final ISocketChannel sc;
    @NotNull
    private final NetworkContext nc;
    @NotNull
    private final NetworkLog readLog;
    @NotNull
    private final NetworkLog writeLog;
    @NotNull
    private final Bytes<ByteBuffer> inBBB;
    @NotNull
    private final Bytes<ByteBuffer> outBBB;
    private final boolean fair;
    private int oneInTen;
    @Nullable
    private volatile TcpHandler tcpHandler;
    private long lastTickReadTime = System.currentTimeMillis();
    private volatile boolean closed;
    private int socketPollCount;
    private long bytesReadCount;
    private long bytesWriteCount;
    private long lastMonitor;

    public TcpEventHandler(@NotNull NetworkContext nc) {
        this(nc, false);
    }

    public TcpEventHandler(@NotNull NetworkContext nc, boolean fair) {
        this.sc = ISocketChannel.wrapUnsafe((SocketChannel)nc.socketChannel());
        this.nc = nc;
        this.fair = fair;
        try {
            this.sc.configureBlocking(false);
            Socket sock = this.sc.socket();
            if (!DISABLE_TCP_NODELAY) {
                sock.setTcpNoDelay(true);
            }
            if (TcpChannelHub.TCP_BUFFER >= 65536) {
                sock.setReceiveBufferSize(TcpChannelHub.TCP_BUFFER);
                sock.setSendBufferSize(TcpChannelHub.TCP_BUFFER);
                this.checkBufSize(sock.getReceiveBufferSize(), "recv");
                this.checkBufSize(sock.getSendBufferSize(), "send");
            }
        }
        catch (IOException e) {
            Jvm.warn().on(this.getClass(), (Throwable)e);
        }
        this.inBBB = Bytes.elasticByteBuffer((int)(TcpChannelHub.TCP_BUFFER + OS.pageSize()));
        this.outBBB = Bytes.elasticByteBuffer((int)TcpChannelHub.TCP_BUFFER);
        BytesUtil.unregister(this.inBBB);
        BytesUtil.unregister(this.outBBB);
        ((ByteBuffer)this.outBBB.underlyingObject()).limit(0);
        this.readLog = new NetworkLog(this.sc, "read");
        this.writeLog = new NetworkLog(this.sc, "write");
        if (FIRST_HANDLER.compareAndSet(false, true)) {
            this.warmUp();
        }
    }

    public void warmUp() {
        System.out.println(TcpEventHandler.class.getSimpleName() + " - Warming up...");
        int runs = 12000;
        long start = System.nanoTime();
        for (int i = 0; i < runs; ++i) {
            this.inBBB.readPositionRemaining(8L, 1024L);
            this.compactBuffer();
            this.clearBuffer();
        }
        long time = System.nanoTime() - start;
        System.out.println(TcpEventHandler.class.getSimpleName() + " - ... warmed up - took " + (double)(time / (long)runs) / 1000.0 + " us avg");
    }

    private void checkBufSize(int bufSize, String name) {
        if (bufSize < TcpChannelHub.TCP_BUFFER) {
            LOG.warn("Attempted to set " + name + " tcp buffer to " + TcpChannelHub.TCP_BUFFER + " but kernel only allowed " + bufSize);
        }
    }

    public ISocketChannel socketChannel() {
        return this.sc;
    }

    public boolean isClosed() {
        return this.closed;
    }

    @NotNull
    public HandlerPriority priority() {
        ServerThreadingStrategy sts = this.nc.serverThreadingStrategy();
        switch (sts) {
            case SINGLE_THREADED: {
                return this.singleThreadedPriority();
            }
            case CONCURRENT: {
                return HandlerPriority.CONCURRENT;
            }
        }
        throw new UnsupportedOperationException("todo");
    }

    @NotNull
    public HandlerPriority singleThreadedPriority() {
        return HandlerPriority.MEDIUM;
    }

    @Nullable
    public TcpHandler tcpHandler() {
        return this.tcpHandler;
    }

    @Override
    public void tcpHandler(TcpHandler tcpHandler) {
        this.nc.onHandlerChanged(tcpHandler);
        this.tcpHandler = tcpHandler;
    }

    public synchronized boolean action() throws InvalidEventHandlerException {
        Jvm.optionalSafepoint();
        if (this.closed) {
            this.inBBB.release();
            this.outBBB.release();
            throw new InvalidEventHandlerException();
        }
        if (this.tcpHandler == null) {
            return false;
        }
        if (!this.sc.isOpen()) {
            this.tcpHandler.onEndOfConnection(false);
            Closeable.closeQuietly((Object)this.nc);
            throw new InvalidEventHandlerException("socket is closed");
        }
        ++this.socketPollCount;
        boolean busy = false;
        if (this.fair || this.oneInTen++ >= 8) {
            this.oneInTen = 0;
            try {
                busy = this.writeAction();
            }
            catch (Exception e) {
                Jvm.warn().on(this.getClass(), (Throwable)e);
            }
        }
        try {
            int read;
            ByteBuffer inBB = (ByteBuffer)this.inBBB.underlyingObject();
            int start = inBB.position();
            int n = read = inBB.remaining() > 0 ? this.sc.read(inBB) : Integer.MAX_VALUE;
            if (read == Integer.MAX_VALUE) {
                this.onInBBFul();
            }
            if (read > 0) {
                WanSimulator.dataRead(read);
                this.tcpHandler.onReadTime(System.nanoTime(), inBB, start, inBB.position());
                this.lastTickReadTime = System.currentTimeMillis();
                this.readLog.log(inBB, start, inBB.position());
                if (this.invokeHandler()) {
                    ++this.oneInTen;
                }
                busy = true;
            } else if (read == 0) {
                long tickTime;
                if (this.outBBB.readRemaining() > 0L) {
                    busy |= this.invokeHandler();
                }
                if (this.nc.heartbeatTimeoutMs() > 0L && (tickTime = System.currentTimeMillis()) > this.lastTickReadTime + this.nc.heartbeatTimeoutMs()) {
                    HeartbeatListener heartbeatListener = this.nc.heartbeatListener();
                    if (heartbeatListener != null && heartbeatListener.onMissedHeartbeat()) {
                        this.lastTickReadTime += heartbeatListener.lingerTimeBeforeDisconnect();
                    } else {
                        this.tcpHandler.onEndOfConnection(true);
                        this.closeSC();
                        throw new InvalidEventHandlerException("heartbeat timeout");
                    }
                }
                if (!busy) {
                    this.monitorStats();
                }
            } else {
                this.close();
                throw new InvalidEventHandlerException("socket closed " + this.sc);
            }
            return busy;
        }
        catch (ClosedChannelException e) {
            this.close();
            throw new InvalidEventHandlerException((Throwable)e);
        }
        catch (IOException e) {
            this.close();
            this.handleIOE(e, this.tcpHandler.hasClientClosed(), this.nc.heartbeatListener());
            throw new InvalidEventHandlerException();
        }
        catch (InvalidEventHandlerException e) {
            this.close();
            throw e;
        }
        catch (Exception e) {
            this.close();
            Jvm.warn().on(this.getClass(), "", (Throwable)e);
            throw new InvalidEventHandlerException((Throwable)e);
        }
    }

    public void onInBBFul() {
        LOG.trace("inBB is full, can't read from socketChannel");
    }

    private void monitorStats() {
        long now = System.currentTimeMillis();
        if (now > this.lastMonitor + (long)(MONITOR_POLL_EVERY_SEC * 1000)) {
            NetworkStatsListener networkStatsListener = this.nc.networkStatsListener();
            if (networkStatsListener != null) {
                if (this.lastMonitor == 0L) {
                    networkStatsListener.onNetworkStats(0L, 0L, 0L);
                } else {
                    networkStatsListener.onNetworkStats(this.bytesWriteCount / (long)MONITOR_POLL_EVERY_SEC, this.bytesReadCount / (long)MONITOR_POLL_EVERY_SEC, this.socketPollCount / MONITOR_POLL_EVERY_SEC);
                    this.socketPollCount = 0;
                    this.bytesWriteCount = this.bytesReadCount = (long)0;
                }
            }
            this.lastMonitor = now;
        }
    }

    boolean invokeHandler() throws IOException {
        long lastInBBBReadPosition;
        Jvm.optionalSafepoint();
        boolean busy = false;
        int position = ((ByteBuffer)this.inBBB.underlyingObject()).position();
        this.inBBB.readLimit((long)position);
        this.outBBB.writePosition((long)((ByteBuffer)this.outBBB.underlyingObject()).limit());
        do {
            lastInBBBReadPosition = this.inBBB.readPosition();
            this.tcpHandler.process(this.inBBB, this.outBBB, this.nc);
            this.bytesReadCount += this.inBBB.readPosition() - lastInBBBReadPosition;
            ByteBuffer outBB = (ByteBuffer)this.outBBB.underlyingObject();
            if (this.outBBB.writePosition() <= (long)outBB.limit() && this.outBBB.writePosition() < 4L) continue;
            outBB.limit(Maths.toInt32((long)this.outBBB.writePosition()));
            busy |= this.tryWrite(outBB);
            break;
        } while (lastInBBBReadPosition != this.inBBB.readPosition());
        Jvm.optionalSafepoint();
        if (this.inBBB.readRemaining() == 0L) {
            this.clearBuffer();
        } else if (this.inBBB.readPosition() > (long)(TcpChannelHub.TCP_BUFFER / 4)) {
            this.compactBuffer();
            busy = true;
        }
        return busy;
    }

    private void clearBuffer() {
        this.inBBB.clear();
        ByteBuffer inBB = (ByteBuffer)this.inBBB.underlyingObject();
        inBB.clear();
    }

    private void compactBuffer() {
        ByteBuffer inBB = (ByteBuffer)this.inBBB.underlyingObject();
        inBB.position((int)this.inBBB.readPosition());
        inBB.limit((int)this.inBBB.readLimit());
        Jvm.optionalSafepoint();
        inBB.compact();
        Jvm.optionalSafepoint();
        this.inBBB.readPosition(0L);
        this.inBBB.readLimit((long)inBB.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleIOE(@NotNull IOException e, boolean clientIntentionallyClosed, @Nullable HeartbeatListener heartbeatListener) {
        try {
            if (clientIntentionallyClosed) {
                return;
            }
            if (e.getMessage() != null && e.getMessage().startsWith("Connection reset by peer")) {
                LOG.trace("", (Object)e.getMessage());
            } else if (e.getMessage() != null && e.getMessage().startsWith("An existing connection was forcibly closed")) {
                Jvm.debug().on(this.getClass(), e.getMessage());
            } else if (!(e instanceof ClosedByInterruptException)) {
                Jvm.warn().on(this.getClass(), "", (Throwable)e);
            }
            if (heartbeatListener != null) {
                heartbeatListener.onMissedHeartbeat();
            }
        }
        finally {
            this.closeSC();
        }
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.closeSC();
    }

    void closeSC() {
        Closeable.closeQuietly((Object)this.tcpHandler);
        Closeable.closeQuietly((Object)this.nc.networkStatsListener());
        Closeable.closeQuietly((Object)this.sc);
        Closeable.closeQuietly((Object)this.nc);
    }

    boolean tryWrite(ByteBuffer outBB) throws IOException {
        if (outBB.remaining() <= 0) {
            return false;
        }
        int start = outBB.position();
        long writeTime = System.nanoTime();
        assert (!this.sc.isBlocking());
        int wrote = this.sc.write(outBB);
        this.tcpHandler.onWriteTime(writeTime, outBB, start, outBB.position());
        this.bytesWriteCount += (long)(outBB.position() - start);
        this.writeLog.log(outBB, start, outBB.position());
        if (wrote < 0) {
            this.closeSC();
        } else if (wrote > 0) {
            outBB.compact().flip();
            this.outBBB.writePosition((long)outBB.limit());
            return true;
        }
        return false;
    }

    public boolean writeAction() {
        boolean busy;
        block5: {
            Jvm.optionalSafepoint();
            busy = false;
            try {
                ByteBuffer outBB = (ByteBuffer)this.outBBB.underlyingObject();
                int remaining = outBB.remaining();
                boolean bl = busy = remaining > 0;
                if (busy) {
                    this.tryWrite(outBB);
                }
                if (outBB.remaining() == remaining && !(busy |= this.invokeHandler())) {
                    busy = this.tryWrite(outBB);
                }
            }
            catch (ClosedChannelException cce) {
                this.closeSC();
            }
            catch (IOException e) {
                if (this.closed) break block5;
                this.handleIOE(e, this.tcpHandler.hasClientClosed(), this.nc.heartbeatListener());
            }
        }
        return busy;
    }

    static {
        if (DISABLE_TCP_NODELAY) {
            System.out.println("tcpNoDelay disabled");
        }
    }

    public static class Factory
    implements MarshallableFunction<NetworkContext, TcpEventHandler> {
        @Override
        @NotNull
        public TcpEventHandler apply(@NotNull NetworkContext nc) {
            return new TcpEventHandler(nc);
        }
    }
}

