/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.net.ServerSocket;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.network.AcceptStrategy;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import org.jetbrains.annotations.NotNull;

public class AcceptorEventHandler<T extends NetworkContext<T>>
implements EventHandler,
Closeable {
    @NotNull
    private final Function<T, TcpEventHandler<T>> handlerFactory;
    @NotNull
    private final ServerSocketChannel ssc;
    @NotNull
    private final Supplier<T> ncFactory;
    private final String hostPort;
    private final AcceptStrategy acceptStrategy;
    private EventLoop eventLoop;
    private volatile boolean closed;

    public AcceptorEventHandler(@NotNull String hostPort, @NotNull Function<T, TcpEventHandler<T>> handlerFactory, @NotNull Supplier<T> ncFactory) throws IOException {
        this(hostPort, handlerFactory, ncFactory, AcceptStrategy.ACCEPT_ALL);
    }

    public AcceptorEventHandler(@NotNull String hostPort, @NotNull Function<T, TcpEventHandler<T>> handlerFactory, @NotNull Supplier<T> ncFactory, @NotNull AcceptStrategy acceptStrategy) throws IOException {
        this.handlerFactory = handlerFactory;
        this.hostPort = hostPort;
        this.ssc = TCPRegistry.acquireServerSocketChannel(this.hostPort);
        this.ncFactory = ncFactory;
        this.acceptStrategy = acceptStrategy;
    }

    public void eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    public boolean action() throws InvalidEventHandlerException {
        if (!this.ssc.isOpen() || this.closed || this.eventLoop.isClosed()) {
            throw new InvalidEventHandlerException();
        }
        try {
            SocketChannel sc;
            if (Jvm.isDebugEnabled(this.getClass())) {
                Jvm.debug().on(this.getClass(), "accepting " + this.ssc);
            }
            if ((sc = this.acceptStrategy.accept(this.ssc)) != null) {
                if (this.closed || this.eventLoop.isClosed()) {
                    Closeable.closeQuietly((Object)sc);
                    throw new InvalidEventHandlerException("closed");
                }
                NetworkContext nc = (NetworkContext)this.ncFactory.get();
                nc.socketChannel(sc);
                nc.isAcceptor(true);
                NetworkStatsListener nl = nc.networkStatsListener();
                NetworkStatsListener.notifyHostPort(sc, nl);
                TcpEventHandler<T> apply = this.handlerFactory.apply(nc);
                this.eventLoop.addHandler(apply);
            }
        }
        catch (AsynchronousCloseException e) {
            this.closeSocket();
            throw new InvalidEventHandlerException((Throwable)e);
        }
        catch (Exception e) {
            if (!this.closed && !this.eventLoop.isClosed()) {
                ServerSocket socket = this.ssc.socket();
                if (socket != null) {
                    Jvm.warn().on(this.getClass(), this.hostPort + ", port=" + socket.getLocalPort(), (Throwable)e);
                } else {
                    Jvm.warn().on(this.getClass(), this.hostPort, (Throwable)e);
                }
            }
            this.closeSocket();
            throw new InvalidEventHandlerException((Throwable)e);
        }
        return false;
    }

    private void closeSocket() {
        try {
            this.ssc.socket().close();
        }
        catch (IOException e) {
            Jvm.debug().on(this.getClass(), (Throwable)e);
        }
        try {
            this.ssc.close();
        }
        catch (IOException e) {
            Jvm.debug().on(this.getClass(), (Throwable)e);
        }
    }

    @NotNull
    public HandlerPriority priority() {
        return HandlerPriority.BLOCKING;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.closeSocket();
    }
}

