/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.connection.FatalFailureMonitor;
import net.openhft.chronicle.network.connection.SocketAddressSupplier;
import net.openhft.chronicle.wire.Marshallable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface ConnectionStrategy
extends Marshallable {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static SocketChannel socketChannel(@NotNull InetSocketAddress socketAddress, int tcpBufferSize, int socketConnectionTimeoutMs) throws IOException {
        SocketChannel socketChannel;
        boolean failed;
        Selector selector;
        SocketChannel result;
        block16: {
            SocketChannel socketChannel2;
            block15: {
                SocketChannel socketChannel3;
                block14: {
                    result = SocketChannel.open();
                    selector = null;
                    failed = true;
                    try {
                        result.configureBlocking(false);
                        Socket socket = result.socket();
                        if (!TcpEventHandler.DISABLE_TCP_NODELAY) {
                            socket.setTcpNoDelay(true);
                        }
                        socket.setReceiveBufferSize(tcpBufferSize);
                        socket.setSendBufferSize(tcpBufferSize);
                        socket.setSoTimeout(0);
                        socket.setSoLinger(false, 0);
                        result.connect(socketAddress);
                        selector = Selector.open();
                        result.register(selector, 8);
                        int select = selector.select(socketConnectionTimeoutMs);
                        if (select == 0) {
                            if (Jvm.isDebugEnabled(ConnectionStrategy.class)) {
                                Jvm.debug().on(ConnectionStrategy.class, "Timed out attempting to connect to " + socketAddress);
                            }
                            socketChannel3 = null;
                            Closeable.closeQuietly((Object)selector);
                            if (!failed) return socketChannel3;
                            break block14;
                        }
                        if (!result.finishConnect()) {
                            socketChannel2 = null;
                            Closeable.closeQuietly((Object)selector);
                            break block15;
                        }
                        failed = false;
                        socketChannel = result;
                        Closeable.closeQuietly((Object)selector);
                        break block16;
                    }
                    catch (Exception e) {
                        SocketChannel socketChannel4 = null;
                        return socketChannel4;
                    }
                }
                Closeable.closeQuietly((Object)result);
                return socketChannel3;
            }
            if (!failed) return socketChannel2;
            Closeable.closeQuietly((Object)result);
            return socketChannel2;
        }
        if (!failed) return socketChannel;
        Closeable.closeQuietly((Object)result);
        return socketChannel;
        finally {
            Closeable.closeQuietly(selector);
            if (failed) {
                Closeable.closeQuietly((Object)result);
            }
        }
    }

    public SocketChannel connect(@NotNull String var1, @NotNull SocketAddressSupplier var2, boolean var3, @NotNull FatalFailureMonitor var4) throws InterruptedException;

    @Nullable
    default public SocketChannel openSocketChannel(@NotNull InetSocketAddress socketAddress, int tcpBufferSize, long timeoutMs) throws IOException, InterruptedException {
        return this.openSocketChannel(socketAddress, tcpBufferSize, timeoutMs, 1);
    }

    @Nullable
    default public SocketChannel openSocketChannel(@NotNull InetSocketAddress socketAddress, int tcpBufferSize, long timeoutMs, int socketConnectionTimeoutMs) throws IOException, InterruptedException {
        if (!1.$assertionsDisabled && timeoutMs <= 0L) {
            throw new AssertionError();
        }
        long start = System.currentTimeMillis();
        SocketChannel sc = ConnectionStrategy.socketChannel(socketAddress, tcpBufferSize, socketConnectionTimeoutMs);
        if (sc != null) {
            return sc;
        }
        while (true) {
            if (Thread.currentThread().isInterrupted()) {
                throw new InterruptedException();
            }
            long startMs = System.currentTimeMillis();
            if (start + timeoutMs < startMs) {
                Jvm.warn().on(ConnectionStrategy.class, "Timed out attempting to connect to " + socketAddress);
                return null;
            }
            sc = ConnectionStrategy.socketChannel(socketAddress, tcpBufferSize, socketConnectionTimeoutMs);
            if (sc != null) {
                return sc;
            }
            Thread.yield();
            long pauseMillis = startMs + this.pauseMillisBeforeReconnect() - System.currentTimeMillis();
            if (Jvm.isDebugEnabled(this.getClass())) {
                Jvm.debug().on(this.getClass(), "Waiting for reconnect " + pauseMillis + " ms");
            }
            LockSupport.parkNanos(TimeUnit.MILLISECONDS.toNanos(pauseMillis));
        }
    }

    default public long pauseMillisBeforeReconnect() {
        return 500L;
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

