/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.concurrent.TimeUnit;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.io.IORuntimeException;
import net.openhft.chronicle.core.util.Time;
import net.openhft.chronicle.network.ConnectionStrategy;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.connection.FatalFailureMonitor;
import net.openhft.chronicle.network.connection.SocketAddressSupplier;
import net.openhft.chronicle.network.connection.TcpChannelHub;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlwaysStartOnPrimaryConnectionStrategy
implements ConnectionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AlwaysStartOnPrimaryConnectionStrategy.class);
    private int tcpBufferSize = Integer.getInteger("tcp.client.buffer.size", TcpChannelHub.TCP_BUFFER);
    private int pausePeriodMs = Integer.getInteger("client.timeout", 500);

    public void readMarshallable(@NotNull WireIn wire) throws IORuntimeException {
        Wires.readMarshallable((Object)this, (WireIn)wire, (boolean)false);
    }

    @Override
    @Nullable
    public SocketChannel connect(@NotNull String name, @NotNull SocketAddressSupplier socketAddressSupplier, @Nullable NetworkStatsListener<? extends NetworkContext> networkStatsListener, boolean didLogIn, @Nullable FatalFailureMonitor fatalFailureMonitor) throws InterruptedException {
        if (socketAddressSupplier.get() == null || didLogIn) {
            socketAddressSupplier.resetToPrimary();
        } else {
            socketAddressSupplier.failoverToNextAddress();
        }
        while (true) {
            SocketChannel socketChannel = null;
            try {
                InetSocketAddress socketAddress = socketAddressSupplier.get();
                if (socketAddress == null) {
                    Jvm.warn().on(AlwaysStartOnPrimaryConnectionStrategy.class, "failed to obtain socketAddress");
                    if (this.isAtEnd(socketAddressSupplier)) {
                        fatalFailureMonitor.onFatalFailure(name, "Failed to connect to any of these servers=" + socketAddressSupplier.remoteAddresses());
                        return null;
                    }
                    socketAddressSupplier.failoverToNextAddress();
                    continue;
                }
                socketChannel = this.openSocketChannel(socketAddress, this.tcpBufferSize, 500L);
                if (socketChannel == null) {
                    Jvm.debug().on(this.getClass(), "unable to connected to " + socketAddressSupplier.toString());
                    if (this.isAtEnd(socketAddressSupplier)) {
                        fatalFailureMonitor.onFatalFailure(name, "Failed to connect to any of these servers=" + socketAddressSupplier.remoteAddresses());
                        return null;
                    }
                    socketAddressSupplier.failoverToNextAddress();
                    continue;
                }
                Jvm.debug().on(this.getClass(), "successfully connected to " + socketAddressSupplier.toString());
                if (networkStatsListener != null) {
                    networkStatsListener.onHostPort(socketAddress.getHostString(), socketAddress.getPort());
                }
                return socketChannel;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            catch (Throwable e) {
                if (socketChannel != null) {
                    Closeable.closeQuietly(socketChannel);
                }
                if (Jvm.isDebug()) {
                    LOG.info("", e);
                }
                socketAddressSupplier.failoverToNextAddress();
                Time.parkNanos((long)TimeUnit.MILLISECONDS.toNanos(this.pausePeriodMs));
                continue;
            }
            break;
        }
    }

    private boolean isAtEnd(SocketAddressSupplier socketAddressSupplier) {
        return socketAddressSupplier.size() - 1 == socketAddressSupplier.index();
    }
}

