/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkContextManager;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import org.jetbrains.annotations.NotNull;

public class WireTypeSniffingTcpHandler<T extends NetworkContext>
implements TcpHandler {
    @NotNull
    private final TcpEventHandler handlerManager;
    @NotNull
    private final T nc;
    @NotNull
    private final Function<T, TcpHandler> delegateHandlerFactory;

    public WireTypeSniffingTcpHandler(@NotNull TcpEventHandler handlerManager, @NotNull T nc, @NotNull Function<T, TcpHandler> delegateHandlerFactory) {
        this.handlerManager = handlerManager;
        this.nc = nc;
        this.delegateHandlerFactory = delegateHandlerFactory;
    }

    @Override
    public void process(@NotNull Bytes in, @NotNull Bytes out) {
        WireType wireType;
        WireOutPublisher publisher = this.nc.wireOutPublisher();
        if (publisher != null) {
            publisher.applyAction(out);
        }
        if (in.readRemaining() < 5L) {
            return;
        }
        int required = Wires.lengthOf((int)in.readInt(in.readPosition()));
        assert (required < 0xA00000);
        if (in.readRemaining() < (long)(required + 4)) {
            return;
        }
        byte b = in.readByte(4L);
        if (b < 0) {
            wireType = WireType.DELTA_BINARY.isAvailable() ? WireType.DELTA_BINARY : WireType.BINARY;
        } else if (b > 32) {
            wireType = WireType.TEXT;
        } else {
            throw new IllegalStateException("Unable to identify the wire type from " + Integer.toHexString(b & 0xFF));
        }
        this.nc.wireType(wireType);
        TcpHandler handler = this.delegateHandlerFactory.apply(this.nc);
        if (handler instanceof NetworkContextManager) {
            ((NetworkContextManager)((Object)handler)).nc(this.nc);
        }
        this.handlerManager.tcpHandler(handler);
    }
}

