/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.util.function.Function;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkContextManager;
import net.openhft.chronicle.network.TcpEventHandler;
import net.openhft.chronicle.network.VanillaSessionDetails;
import net.openhft.chronicle.network.api.TcpHandler;
import net.openhft.chronicle.network.api.session.SessionDetailsProvider;
import net.openhft.chronicle.wire.DocumentContext;
import net.openhft.chronicle.wire.ValueIn;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireIn;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HeaderTcpHandler<T extends NetworkContext>
implements TcpHandler {
    public static final String HANDLER = "handler";
    private static final Logger LOG = LoggerFactory.getLogger(HeaderTcpHandler.class);
    @NotNull
    private final TcpEventHandler handlerManager;
    @NotNull
    private final Function<Object, TcpHandler> handlerFunction;
    @NotNull
    private final NetworkContext nc;

    public HeaderTcpHandler(@NotNull TcpEventHandler handlerManager, @NotNull Function<Object, TcpHandler> handlerFunction, @NotNull T nc) {
        this.handlerManager = handlerManager;
        this.handlerFunction = handlerFunction;
        this.nc = nc;
    }

    @Override
    public void process(@NotNull Bytes in, @NotNull Bytes out) {
        assert (this.nc.wireType() != null);
        Wire inWire = (Wire)this.nc.wireType().apply((Object)in);
        long start = in.readPosition();
        try (DocumentContext dc = inWire.readingDocument();){
            Object o;
            if (!dc.isPresent()) {
                return;
            }
            if (YamlLogging.showServerReads()) {
                LOG.info("nc.isAcceptor=" + this.nc.isAcceptor() + ", read:\n" + Wires.fromSizePrefixedBlobs((Bytes)in, (long)start, (long)(in.readLimit() - start)));
            }
            long readPosition = inWire.bytes().readPosition();
            ValueIn read = inWire.read(() -> HANDLER);
            if (dc.isMetaData() && read.isTyped()) {
                o = read.typedMarshallable();
            } else {
                inWire.bytes().readPosition(readPosition);
                o = this.toSessionDetails(inWire);
            }
            TcpHandler handler = this.handlerFunction.apply(o);
            if (handler instanceof NetworkContextManager) {
                ((NetworkContextManager)((Object)handler)).nc(this.nc);
            }
            this.handlerManager.tcpHandler(handler);
        }
        catch (Exception e) {
            Jvm.warn().on(this.getClass(), "wirein=" + Wires.fromSizePrefixedBlobs((WireIn)inWire), (Throwable)e);
        }
    }

    @NotNull
    private SessionDetailsProvider toSessionDetails(@NotNull Wire inWire) {
        VanillaSessionDetails sd = new VanillaSessionDetails();
        sd.readMarshallable((WireIn)inWire);
        return sd;
    }
}

