/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.function.Function;
import java.util.function.Supplier;
import net.openhft.chronicle.core.Jvm;
import net.openhft.chronicle.core.threads.EventHandler;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.core.threads.HandlerPriority;
import net.openhft.chronicle.core.threads.InvalidEventHandlerException;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.TCPRegistry;
import net.openhft.chronicle.network.TcpEventHandler;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AcceptorEventHandler
implements EventHandler,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(AcceptorEventHandler.class);
    @NotNull
    private final Function<NetworkContext, TcpEventHandler> handlerFactory;
    @NotNull
    private final ServerSocketChannel ssc;
    private final Supplier<? extends NetworkContext> ncFactory;
    private EventLoop eventLoop;
    private volatile boolean closed;

    public AcceptorEventHandler(@NotNull String description, @NotNull Function<NetworkContext, TcpEventHandler> handlerFactory, @NotNull Supplier<NetworkContext> ncFactory) throws IOException {
        this.handlerFactory = handlerFactory;
        this.ssc = TCPRegistry.acquireServerSocketChannel(description);
        this.ncFactory = ncFactory;
    }

    public void eventLoop(EventLoop eventLoop) {
        this.eventLoop = eventLoop;
    }

    public boolean action() throws InvalidEventHandlerException {
        block6: {
            if (!this.ssc.isOpen()) {
                throw new InvalidEventHandlerException();
            }
            try {
                System.out.println(Thread.currentThread() + " accepting " + this.ssc);
                SocketChannel sc = this.ssc.accept();
                if (sc != null) {
                    NetworkContext nc = this.ncFactory.get();
                    nc.socketChannel(sc);
                    nc.isAcceptor(true);
                    NetworkStatsListener networkStatsListener = nc.networkStatsListener();
                    if (networkStatsListener != null && sc.socket() != null && sc.socket().getRemoteSocketAddress() instanceof InetSocketAddress) {
                        networkStatsListener.onHostPort(((InetSocketAddress)sc.socket().getRemoteSocketAddress()).getHostName(), ((InetSocketAddress)sc.socket().getRemoteSocketAddress()).getPort());
                    }
                    this.eventLoop.addHandler((EventHandler)this.handlerFactory.apply(nc));
                }
            }
            catch (AsynchronousCloseException e) {
                this.closeSocket();
            }
            catch (Exception e) {
                if (this.closed) break block6;
                Jvm.debug().on(this.getClass(), (Throwable)e);
                this.closeSocket();
            }
        }
        return false;
    }

    private void closeSocket() {
        try {
            this.ssc.socket().close();
        }
        catch (IOException e) {
            Jvm.debug().on(this.getClass(), (Throwable)e);
        }
        try {
            this.ssc.close();
        }
        catch (IOException e) {
            Jvm.debug().on(this.getClass(), (Throwable)e);
        }
    }

    @NotNull
    public HandlerPriority priority() {
        return HandlerPriority.BLOCKING;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.closeSocket();
    }
}

