/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.NetworkStatsListener;
import net.openhft.chronicle.network.RemoteConnector;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.HostDetails;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class HostConnector
implements Closeable {
    private final WireType wireType;
    private final Function<WireType, WireOutPublisher> wireOutPublisherFactory;
    private final List<WriteMarshallable> bootstraps = new LinkedList<WriteMarshallable>();
    private final RemoteConnector remoteConnector;
    private final String connectUri;
    private final Function<ClusterContext, NetworkContext> networkContextFactory;
    private final ClusterContext clusterContext;
    private NetworkContext nc;
    private volatile AtomicReference<WireOutPublisher> wireOutPublisher = new AtomicReference();
    @NotNull
    private EventLoop eventLoop;
    private final Function<ClusterContext, NetworkStatsListener> networkStatsListenerFactory;

    HostConnector(@NotNull ClusterContext clusterContext, RemoteConnector remoteConnector, HostDetails hostdetails) {
        this.clusterContext = clusterContext;
        this.remoteConnector = remoteConnector;
        this.networkStatsListenerFactory = clusterContext.networkStatsListenerFactory();
        this.networkContextFactory = clusterContext.networkContextFactory();
        this.connectUri = hostdetails.connectUri();
        this.wireType = clusterContext.wireType();
        this.wireOutPublisherFactory = clusterContext.wireOutPublisherFactory();
        this.eventLoop = clusterContext.eventLoop();
    }

    public synchronized void close() {
        WireOutPublisher wp = this.wireOutPublisher.getAndSet(null);
        if (this.nc.socketChannel() != null) {
            Closeable.closeQuietly((Object)this.nc.socketChannel());
        }
        if (wp != null) {
            wp.close();
        }
    }

    public synchronized void bootstrap(WriteMarshallable subscription) {
        this.bootstraps.add(subscription);
        WireOutPublisher wp = this.wireOutPublisher.get();
        if (wp != null) {
            wp.put("", subscription);
        }
    }

    public synchronized void connect() {
        WireOutPublisher wireOutPublisher = this.wireOutPublisherFactory.apply(WireType.TEXT);
        if (!this.wireOutPublisher.compareAndSet(null, wireOutPublisher)) {
            wireOutPublisher.close();
            return;
        }
        this.nc = this.networkContextFactory.apply(this.clusterContext);
        this.nc.wireOutPublisher(wireOutPublisher);
        this.nc.isAcceptor(false);
        this.nc.heartbeatTimeoutMs(this.clusterContext.heartbeatTimeoutMs() * 2L);
        this.nc.socketReconnector(this::reconnect);
        if (this.networkStatsListenerFactory != null) {
            NetworkStatsListener networkStatsListener = this.networkStatsListenerFactory.apply(this.clusterContext);
            SocketChannel socketChannel = this.nc.socketChannel();
            if (socketChannel != null && socketChannel.socket() != null && socketChannel.socket().getRemoteSocketAddress() instanceof InetSocketAddress) {
                InetSocketAddress remoteSocketAddress = (InetSocketAddress)socketChannel.socket().getRemoteSocketAddress();
                networkStatsListener.onHostPort(remoteSocketAddress.getHostName(), remoteSocketAddress.getPort());
            }
            this.nc.networkStatsListener(networkStatsListener);
        }
        boolean firstTime = true;
        for (WriteMarshallable bootstrap : this.bootstraps) {
            wireOutPublisher.publish(bootstrap);
            if (!firstTime) continue;
            wireOutPublisher.wireType(this.wireType);
        }
        this.nc.wireType(this.wireType);
        this.remoteConnector.connect(this.connectUri, this.eventLoop, this.nc, 1000L);
    }

    synchronized void reconnect() {
        this.close();
        if (!this.nc.isAcceptor()) {
            this.connect();
        }
    }
}

