/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.connection;

import java.nio.ByteBuffer;
import net.openhft.chronicle.bytes.Bytes;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.ReadDocumentContext;
import net.openhft.chronicle.wire.Wire;
import net.openhft.chronicle.wire.WireOut;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.Wires;
import net.openhft.chronicle.wire.WriteMarshallable;
import net.openhft.chronicle.wire.YamlLogging;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VanillaWireOutPublisher
implements WireOutPublisher {
    private static final Logger LOG = LoggerFactory.getLogger(VanillaWireOutPublisher.class);
    private final Bytes<ByteBuffer> bytes = Bytes.elasticByteBuffer((int)0x200000);
    private Wire wrapperWire = (Wire)WireType.BINARY.apply(this.bytes);
    private volatile boolean closed = false;
    private Wire wire;

    public VanillaWireOutPublisher(WireType wireType) {
        this.wire = (Wire)wireType.apply(this.bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void applyAction(@NotNull Bytes out) {
        if (this.bytes.readRemaining() == 0L) {
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            while (true) {
                if (this.bytes.readRemaining() <= 0L) {
                    this.bytes.compact();
                    return;
                }
                long readPosition = this.bytes.readPosition();
                ReadDocumentContext dc = (ReadDocumentContext)this.wrapperWire.readingDocument();
                Throwable throwable = null;
                try {
                    if (!dc.isPresent() || out.writeRemaining() < this.bytes.readRemaining()) {
                        dc.closeReadPosition(readPosition);
                        return;
                    }
                    if (YamlLogging.showServerWrites()) {
                        LOG.info("Server sends:" + Wires.fromSizePrefixedBlobs(this.bytes));
                    }
                    out.write(this.bytes);
                    continue;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dc == null) continue;
                    if (throwable != null) {
                        try {
                            dc.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dc.close();
                    continue;
                }
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(Object key, WriteMarshallable event) {
        if (this.closed) {
            LOG.debug("message ignored as closed");
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            this.wrapperWire.writeDocument(false, d -> {
                long start = this.wire.bytes().writePosition();
                event.writeMarshallable((WireOut)this.wire);
                if (YamlLogging.showServerWrites()) {
                    LOG.info("Server is about to send:" + Wires.fromSizePrefixedBlobs((Bytes)this.wire.bytes(), (long)start, (long)(this.wire.bytes().writePosition() - start)));
                }
            });
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    private Object lock() {
        return this.bytes;
    }

    @Override
    public synchronized void close() {
        this.closed = true;
        this.clear();
    }

    @Override
    public boolean canTakeMoreData() {
        return this.wrapperWire.bytes().writePosition() < 0x200000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wireType(@NotNull WireType wireType) {
        if (WireType.valueOf((Wire)this.wire) == wireType) {
            return;
        }
        Object object = this.lock();
        synchronized (object) {
            this.wire = (Wire)wireType.apply(this.bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Object object = this.lock();
        synchronized (object) {
            this.wrapperWire.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        Object object = this.lock();
        synchronized (object) {
            return this.bytes.isEmpty();
        }
    }

    public String toString() {
        return "VanillaWireOutPublisher{, closed=" + this.closed + ", " + this.wire.getClass().getSimpleName() + "=" + this.bytes + '}';
    }
}

