/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.core.threads.EventLoop;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.RemoteConnector;
import net.openhft.chronicle.network.cluster.ClusterContext;
import net.openhft.chronicle.network.cluster.HeartbeatHandler;
import net.openhft.chronicle.network.cluster.HostDetails;
import net.openhft.chronicle.network.connection.WireOutPublisher;
import net.openhft.chronicle.wire.WireType;
import net.openhft.chronicle.wire.WriteMarshallable;
import org.jetbrains.annotations.NotNull;

public class HostConnector
implements Closeable {
    private final WireType wireType;
    private final Function<WireType, WireOutPublisher> wireOutPublisherFactory;
    private final List<WriteMarshallable> bootstraps = new LinkedList<WriteMarshallable>();
    private final RemoteConnector remoteConnector;
    private final String connectUri;
    private WireOutPublisher wireOutPublisher;
    private NetworkContext nc;
    private final Function<ClusterContext, NetworkContext> networkContextFactory;
    private final ClusterContext clusterContext;
    private volatile boolean isConnected;
    @NotNull
    private EventLoop eventLoop;

    HostConnector(@NotNull ClusterContext clusterContext, RemoteConnector remoteConnector, HostDetails hostdetails) {
        this.clusterContext = clusterContext;
        this.remoteConnector = remoteConnector;
        this.networkContextFactory = clusterContext.networkContextFactory();
        this.connectUri = hostdetails.connectUri();
        this.wireType = clusterContext.wireType();
        this.wireOutPublisherFactory = clusterContext.wireOutPublisherFactory();
        this.eventLoop = clusterContext.eventLoop();
        this.wireOutPublisher = this.wireOutPublisherFactory.apply(WireType.TEXT);
    }

    public synchronized void close() {
        this.isConnected = false;
        Closeable.closeQuietly((Object)this.wireOutPublisher);
        if (this.nc.socketChannel() != null) {
            Closeable.closeQuietly((Object)this.nc.socketChannel());
        }
        this.wireOutPublisher.clear();
    }

    public synchronized void bootstrap(WriteMarshallable subscription) {
        this.bootstraps.add(subscription);
        if (this.isConnected && this.wireOutPublisher != null) {
            this.wireOutPublisher.put("", subscription);
        }
    }

    public synchronized void connect() {
        this.isConnected = true;
        this.nc = this.networkContextFactory.apply(this.clusterContext);
        this.nc.wireOutPublisher(this.wireOutPublisher);
        this.nc.wireType(this.wireType);
        this.nc.closeTask(this);
        this.nc.heartbeatTimeoutMs(this.clusterContext.heartbeatTimeoutMs() * 2L);
        this.nc.heartbeatListener(() -> {
            if (this.nc.socketChannel() != null) {
                Closeable.closeQuietly((Object)this.nc.socketChannel());
            }
            this.wireOutPublisher.clear();
            this.reconnect();
        });
        this.wireOutPublisher.wireType(this.wireType);
        for (WriteMarshallable bootstrap : this.bootstraps) {
            this.wireOutPublisher.publish(bootstrap);
        }
        this.remoteConnector.connect(this.connectUri, this.eventLoop, this.nc, 1000L);
    }

    public void reconnect() {
        HeartbeatHandler.HEARTBEAT_EXECUTOR.submit(() -> {
            HostConnector hostConnector = this;
            synchronized (hostConnector) {
                if (!this.nc.isAcceptor()) {
                    this.connect();
                }
            }
        });
    }
}

