/*
 * Decompiled with CFR 0.152.
 */
package net.openhft.chronicle.network.cluster;

import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.openhft.chronicle.core.io.Closeable;
import net.openhft.chronicle.network.NetworkContext;
import net.openhft.chronicle.network.cluster.ConnectionChangedNotifier;
import net.openhft.chronicle.network.cluster.HostConnector;
import net.openhft.chronicle.network.cluster.HostDetails;
import net.openhft.chronicle.network.cluster.TerminationEventHandler;
import net.openhft.chronicle.wire.WriteMarshallable;

class ClusterNotifier<E extends HostDetails>
implements TerminationEventHandler,
ConnectionChangedNotifier {
    private final List<WriteMarshallable> bootstaps;
    private final AtomicBoolean terminated = new AtomicBoolean();
    private final ConnectionChangedNotifier connectionEventManager;
    private final HostConnector hostConnector;

    <E extends HostDetails> ClusterNotifier(ConnectionChangedNotifier connectionEventManager, HostConnector hostConnector, List<WriteMarshallable> bootstaps) {
        this.connectionEventManager = connectionEventManager;
        this.hostConnector = hostConnector;
        this.bootstaps = bootstaps;
    }

    public void connect() {
        this.bootstaps.forEach(this.hostConnector::bootstrap);
        this.hostConnector.connect();
    }

    @Override
    public void onConnectionChanged(boolean isConnected, NetworkContext nc) {
        if (!isConnected) {
            this.onClose();
        }
        this.connectionEventManager.onConnectionChanged(isConnected, nc);
    }

    private void onClose() {
        if (this.terminated.get()) {
            Closeable.closeQuietly((Object)this.hostConnector);
            return;
        }
        this.hostConnector.reconnect();
    }

    @Override
    public void onTerminate() {
        this.terminated.set(true);
        this.hostConnector.close();
    }
}

